/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AuthorSpecifiedAggregation;
import software.amazon.awssdk.services.quicksight.model.AuthorSpecifiedAggregationsCopier;
import software.amazon.awssdk.services.quicksight.model.CellValueSynonym;
import software.amazon.awssdk.services.quicksight.model.CellValueSynonymsCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnDataRole;
import software.amazon.awssdk.services.quicksight.model.ComparativeOrder;
import software.amazon.awssdk.services.quicksight.model.DefaultAggregation;
import software.amazon.awssdk.services.quicksight.model.DefaultFormatting;
import software.amazon.awssdk.services.quicksight.model.SemanticType;
import software.amazon.awssdk.services.quicksight.model.SynonymsCopier;
import software.amazon.awssdk.services.quicksight.model.TopicTimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicColumn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(TopicColumn.getter(TopicColumn::columnName)).setter(TopicColumn.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> COLUMN_FRIENDLY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnFriendlyName").getter(TopicColumn.getter(TopicColumn::columnFriendlyName)).setter(TopicColumn.setter(Builder::columnFriendlyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnFriendlyName").build()}).build();
    private static final SdkField<String> COLUMN_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnDescription").getter(TopicColumn.getter(TopicColumn::columnDescription)).setter(TopicColumn.setter(Builder::columnDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDescription").build()}).build();
    private static final SdkField<List<String>> COLUMN_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnSynonyms").getter(TopicColumn.getter(TopicColumn::columnSynonyms)).setter(TopicColumn.setter(Builder::columnSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COLUMN_DATA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnDataRole").getter(TopicColumn.getter(TopicColumn::columnDataRoleAsString)).setter(TopicColumn.setter(Builder::columnDataRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDataRole").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(TopicColumn.getter(TopicColumn::aggregationAsString)).setter(TopicColumn.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final SdkField<Boolean> IS_INCLUDED_IN_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsIncludedInTopic").getter(TopicColumn.getter(TopicColumn::isIncludedInTopic)).setter(TopicColumn.setter(Builder::isIncludedInTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIncludedInTopic").build()}).build();
    private static final SdkField<Boolean> DISABLE_INDEXING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableIndexing").getter(TopicColumn.getter(TopicColumn::disableIndexing)).setter(TopicColumn.setter(Builder::disableIndexing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableIndexing").build()}).build();
    private static final SdkField<ComparativeOrder> COMPARATIVE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComparativeOrder").getter(TopicColumn.getter(TopicColumn::comparativeOrder)).setter(TopicColumn.setter(Builder::comparativeOrder)).constructor(ComparativeOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparativeOrder").build()}).build();
    private static final SdkField<SemanticType> SEMANTIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SemanticType").getter(TopicColumn.getter(TopicColumn::semanticType)).setter(TopicColumn.setter(Builder::semanticType)).constructor(SemanticType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticType").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TopicColumn.getter(TopicColumn::timeGranularityAsString)).setter(TopicColumn.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<List<String>> ALLOWED_AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedAggregations").getter(TopicColumn.getter(TopicColumn::allowedAggregationsAsStrings)).setter(TopicColumn.setter(Builder::allowedAggregationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_ALLOWED_AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotAllowedAggregations").getter(TopicColumn.getter(TopicColumn::notAllowedAggregationsAsStrings)).setter(TopicColumn.setter(Builder::notAllowedAggregationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAllowedAggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DefaultFormatting> DEFAULT_FORMATTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultFormatting").getter(TopicColumn.getter(TopicColumn::defaultFormatting)).setter(TopicColumn.setter(Builder::defaultFormatting)).constructor(DefaultFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFormatting").build()}).build();
    private static final SdkField<Boolean> NEVER_AGGREGATE_IN_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NeverAggregateInFilter").getter(TopicColumn.getter(TopicColumn::neverAggregateInFilter)).setter(TopicColumn.setter(Builder::neverAggregateInFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverAggregateInFilter").build()}).build();
    private static final SdkField<List<CellValueSynonym>> CELL_VALUE_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CellValueSynonyms").getter(TopicColumn.getter(TopicColumn::cellValueSynonyms)).setter(TopicColumn.setter(Builder::cellValueSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellValueSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CellValueSynonym::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NON_ADDITIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NonAdditive").getter(TopicColumn.getter(TopicColumn::nonAdditive)).setter(TopicColumn.setter(Builder::nonAdditive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAdditive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, COLUMN_FRIENDLY_NAME_FIELD, COLUMN_DESCRIPTION_FIELD, COLUMN_SYNONYMS_FIELD, COLUMN_DATA_ROLE_FIELD, AGGREGATION_FIELD, IS_INCLUDED_IN_TOPIC_FIELD, DISABLE_INDEXING_FIELD, COMPARATIVE_ORDER_FIELD, SEMANTIC_TYPE_FIELD, TIME_GRANULARITY_FIELD, ALLOWED_AGGREGATIONS_FIELD, NOT_ALLOWED_AGGREGATIONS_FIELD, DEFAULT_FORMATTING_FIELD, NEVER_AGGREGATE_IN_FILTER_FIELD, CELL_VALUE_SYNONYMS_FIELD, NON_ADDITIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ColumnName", COLUMN_NAME_FIELD);
            this.put("ColumnFriendlyName", COLUMN_FRIENDLY_NAME_FIELD);
            this.put("ColumnDescription", COLUMN_DESCRIPTION_FIELD);
            this.put("ColumnSynonyms", COLUMN_SYNONYMS_FIELD);
            this.put("ColumnDataRole", COLUMN_DATA_ROLE_FIELD);
            this.put("Aggregation", AGGREGATION_FIELD);
            this.put("IsIncludedInTopic", IS_INCLUDED_IN_TOPIC_FIELD);
            this.put("DisableIndexing", DISABLE_INDEXING_FIELD);
            this.put("ComparativeOrder", COMPARATIVE_ORDER_FIELD);
            this.put("SemanticType", SEMANTIC_TYPE_FIELD);
            this.put("TimeGranularity", TIME_GRANULARITY_FIELD);
            this.put("AllowedAggregations", ALLOWED_AGGREGATIONS_FIELD);
            this.put("NotAllowedAggregations", NOT_ALLOWED_AGGREGATIONS_FIELD);
            this.put("DefaultFormatting", DEFAULT_FORMATTING_FIELD);
            this.put("NeverAggregateInFilter", NEVER_AGGREGATE_IN_FILTER_FIELD);
            this.put("CellValueSynonyms", CELL_VALUE_SYNONYMS_FIELD);
            this.put("NonAdditive", NON_ADDITIVE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final String columnFriendlyName;
    private final String columnDescription;
    private final List<String> columnSynonyms;
    private final String columnDataRole;
    private final String aggregation;
    private final Boolean isIncludedInTopic;
    private final Boolean disableIndexing;
    private final ComparativeOrder comparativeOrder;
    private final SemanticType semanticType;
    private final String timeGranularity;
    private final List<String> allowedAggregations;
    private final List<String> notAllowedAggregations;
    private final DefaultFormatting defaultFormatting;
    private final Boolean neverAggregateInFilter;
    private final List<CellValueSynonym> cellValueSynonyms;
    private final Boolean nonAdditive;

    private TopicColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnFriendlyName = builder.columnFriendlyName;
        this.columnDescription = builder.columnDescription;
        this.columnSynonyms = builder.columnSynonyms;
        this.columnDataRole = builder.columnDataRole;
        this.aggregation = builder.aggregation;
        this.isIncludedInTopic = builder.isIncludedInTopic;
        this.disableIndexing = builder.disableIndexing;
        this.comparativeOrder = builder.comparativeOrder;
        this.semanticType = builder.semanticType;
        this.timeGranularity = builder.timeGranularity;
        this.allowedAggregations = builder.allowedAggregations;
        this.notAllowedAggregations = builder.notAllowedAggregations;
        this.defaultFormatting = builder.defaultFormatting;
        this.neverAggregateInFilter = builder.neverAggregateInFilter;
        this.cellValueSynonyms = builder.cellValueSynonyms;
        this.nonAdditive = builder.nonAdditive;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final String columnFriendlyName() {
        return this.columnFriendlyName;
    }

    public final String columnDescription() {
        return this.columnDescription;
    }

    public final boolean hasColumnSynonyms() {
        return this.columnSynonyms != null && !(this.columnSynonyms instanceof SdkAutoConstructList);
    }

    public final List<String> columnSynonyms() {
        return this.columnSynonyms;
    }

    public final ColumnDataRole columnDataRole() {
        return ColumnDataRole.fromValue(this.columnDataRole);
    }

    public final String columnDataRoleAsString() {
        return this.columnDataRole;
    }

    public final DefaultAggregation aggregation() {
        return DefaultAggregation.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final Boolean isIncludedInTopic() {
        return this.isIncludedInTopic;
    }

    public final Boolean disableIndexing() {
        return this.disableIndexing;
    }

    public final ComparativeOrder comparativeOrder() {
        return this.comparativeOrder;
    }

    public final SemanticType semanticType() {
        return this.semanticType;
    }

    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final List<AuthorSpecifiedAggregation> allowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(this.allowedAggregations);
    }

    public final boolean hasAllowedAggregations() {
        return this.allowedAggregations != null && !(this.allowedAggregations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAggregationsAsStrings() {
        return this.allowedAggregations;
    }

    public final List<AuthorSpecifiedAggregation> notAllowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(this.notAllowedAggregations);
    }

    public final boolean hasNotAllowedAggregations() {
        return this.notAllowedAggregations != null && !(this.notAllowedAggregations instanceof SdkAutoConstructList);
    }

    public final List<String> notAllowedAggregationsAsStrings() {
        return this.notAllowedAggregations;
    }

    public final DefaultFormatting defaultFormatting() {
        return this.defaultFormatting;
    }

    public final Boolean neverAggregateInFilter() {
        return this.neverAggregateInFilter;
    }

    public final boolean hasCellValueSynonyms() {
        return this.cellValueSynonyms != null && !(this.cellValueSynonyms instanceof SdkAutoConstructList);
    }

    public final List<CellValueSynonym> cellValueSynonyms() {
        return this.cellValueSynonyms;
    }

    public final Boolean nonAdditive() {
        return this.nonAdditive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnFriendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnSynonyms() ? this.columnSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.columnDataRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIncludedInTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableIndexing());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparativeOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticType());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAggregations() ? this.allowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotAllowedAggregations() ? this.notAllowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFormatting());
        hashCode = 31 * hashCode + Objects.hashCode(this.neverAggregateInFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellValueSynonyms() ? this.cellValueSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nonAdditive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicColumn)) {
            return false;
        }
        TopicColumn other = (TopicColumn)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.columnFriendlyName(), other.columnFriendlyName()) && Objects.equals(this.columnDescription(), other.columnDescription()) && this.hasColumnSynonyms() == other.hasColumnSynonyms() && Objects.equals(this.columnSynonyms(), other.columnSynonyms()) && Objects.equals(this.columnDataRoleAsString(), other.columnDataRoleAsString()) && Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && Objects.equals(this.isIncludedInTopic(), other.isIncludedInTopic()) && Objects.equals(this.disableIndexing(), other.disableIndexing()) && Objects.equals(this.comparativeOrder(), other.comparativeOrder()) && Objects.equals(this.semanticType(), other.semanticType()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && this.hasAllowedAggregations() == other.hasAllowedAggregations() && Objects.equals(this.allowedAggregationsAsStrings(), other.allowedAggregationsAsStrings()) && this.hasNotAllowedAggregations() == other.hasNotAllowedAggregations() && Objects.equals(this.notAllowedAggregationsAsStrings(), other.notAllowedAggregationsAsStrings()) && Objects.equals(this.defaultFormatting(), other.defaultFormatting()) && Objects.equals(this.neverAggregateInFilter(), other.neverAggregateInFilter()) && this.hasCellValueSynonyms() == other.hasCellValueSynonyms() && Objects.equals(this.cellValueSynonyms(), other.cellValueSynonyms()) && Objects.equals(this.nonAdditive(), other.nonAdditive());
    }

    public final String toString() {
        return ToString.builder((String)"TopicColumn").add("ColumnName", (Object)this.columnName()).add("ColumnFriendlyName", (Object)this.columnFriendlyName()).add("ColumnDescription", (Object)this.columnDescription()).add("ColumnSynonyms", this.hasColumnSynonyms() ? this.columnSynonyms() : null).add("ColumnDataRole", (Object)this.columnDataRoleAsString()).add("Aggregation", (Object)this.aggregationAsString()).add("IsIncludedInTopic", (Object)this.isIncludedInTopic()).add("DisableIndexing", (Object)this.disableIndexing()).add("ComparativeOrder", (Object)this.comparativeOrder()).add("SemanticType", (Object)this.semanticType()).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("AllowedAggregations", this.hasAllowedAggregations() ? this.allowedAggregationsAsStrings() : null).add("NotAllowedAggregations", this.hasNotAllowedAggregations() ? this.notAllowedAggregationsAsStrings() : null).add("DefaultFormatting", (Object)this.defaultFormatting()).add("NeverAggregateInFilter", (Object)this.neverAggregateInFilter()).add("CellValueSynonyms", this.hasCellValueSynonyms() ? this.cellValueSynonyms() : null).add("NonAdditive", (Object)this.nonAdditive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "ColumnFriendlyName": {
                return Optional.ofNullable(clazz.cast(this.columnFriendlyName()));
            }
            case "ColumnDescription": {
                return Optional.ofNullable(clazz.cast(this.columnDescription()));
            }
            case "ColumnSynonyms": {
                return Optional.ofNullable(clazz.cast(this.columnSynonyms()));
            }
            case "ColumnDataRole": {
                return Optional.ofNullable(clazz.cast(this.columnDataRoleAsString()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "IsIncludedInTopic": {
                return Optional.ofNullable(clazz.cast(this.isIncludedInTopic()));
            }
            case "DisableIndexing": {
                return Optional.ofNullable(clazz.cast(this.disableIndexing()));
            }
            case "ComparativeOrder": {
                return Optional.ofNullable(clazz.cast(this.comparativeOrder()));
            }
            case "SemanticType": {
                return Optional.ofNullable(clazz.cast(this.semanticType()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "AllowedAggregations": {
                return Optional.ofNullable(clazz.cast(this.allowedAggregationsAsStrings()));
            }
            case "NotAllowedAggregations": {
                return Optional.ofNullable(clazz.cast(this.notAllowedAggregationsAsStrings()));
            }
            case "DefaultFormatting": {
                return Optional.ofNullable(clazz.cast(this.defaultFormatting()));
            }
            case "NeverAggregateInFilter": {
                return Optional.ofNullable(clazz.cast(this.neverAggregateInFilter()));
            }
            case "CellValueSynonyms": {
                return Optional.ofNullable(clazz.cast(this.cellValueSynonyms()));
            }
            case "NonAdditive": {
                return Optional.ofNullable(clazz.cast(this.nonAdditive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicColumn, T> g) {
        return obj -> g.apply((TopicColumn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private String columnFriendlyName;
        private String columnDescription;
        private List<String> columnSynonyms = DefaultSdkAutoConstructList.getInstance();
        private String columnDataRole;
        private String aggregation;
        private Boolean isIncludedInTopic;
        private Boolean disableIndexing;
        private ComparativeOrder comparativeOrder;
        private SemanticType semanticType;
        private String timeGranularity;
        private List<String> allowedAggregations = DefaultSdkAutoConstructList.getInstance();
        private List<String> notAllowedAggregations = DefaultSdkAutoConstructList.getInstance();
        private DefaultFormatting defaultFormatting;
        private Boolean neverAggregateInFilter;
        private List<CellValueSynonym> cellValueSynonyms = DefaultSdkAutoConstructList.getInstance();
        private Boolean nonAdditive;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicColumn model) {
            this.columnName(model.columnName);
            this.columnFriendlyName(model.columnFriendlyName);
            this.columnDescription(model.columnDescription);
            this.columnSynonyms(model.columnSynonyms);
            this.columnDataRole(model.columnDataRole);
            this.aggregation(model.aggregation);
            this.isIncludedInTopic(model.isIncludedInTopic);
            this.disableIndexing(model.disableIndexing);
            this.comparativeOrder(model.comparativeOrder);
            this.semanticType(model.semanticType);
            this.timeGranularity(model.timeGranularity);
            this.allowedAggregationsWithStrings(model.allowedAggregations);
            this.notAllowedAggregationsWithStrings(model.notAllowedAggregations);
            this.defaultFormatting(model.defaultFormatting);
            this.neverAggregateInFilter(model.neverAggregateInFilter);
            this.cellValueSynonyms(model.cellValueSynonyms);
            this.nonAdditive(model.nonAdditive);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnFriendlyName() {
            return this.columnFriendlyName;
        }

        public final void setColumnFriendlyName(String columnFriendlyName) {
            this.columnFriendlyName = columnFriendlyName;
        }

        @Override
        public final Builder columnFriendlyName(String columnFriendlyName) {
            this.columnFriendlyName = columnFriendlyName;
            return this;
        }

        public final String getColumnDescription() {
            return this.columnDescription;
        }

        public final void setColumnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
        }

        @Override
        public final Builder columnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
            return this;
        }

        public final Collection<String> getColumnSynonyms() {
            if (this.columnSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnSynonyms;
        }

        public final void setColumnSynonyms(Collection<String> columnSynonyms) {
            this.columnSynonyms = SynonymsCopier.copy(columnSynonyms);
        }

        @Override
        public final Builder columnSynonyms(Collection<String> columnSynonyms) {
            this.columnSynonyms = SynonymsCopier.copy(columnSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnSynonyms(String ... columnSynonyms) {
            this.columnSynonyms(Arrays.asList(columnSynonyms));
            return this;
        }

        public final String getColumnDataRole() {
            return this.columnDataRole;
        }

        public final void setColumnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
        }

        @Override
        public final Builder columnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
            return this;
        }

        @Override
        public final Builder columnDataRole(ColumnDataRole columnDataRole) {
            this.columnDataRole(columnDataRole == null ? null : columnDataRole.toString());
            return this;
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(DefaultAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Boolean getIsIncludedInTopic() {
            return this.isIncludedInTopic;
        }

        public final void setIsIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
        }

        @Override
        public final Builder isIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
            return this;
        }

        public final Boolean getDisableIndexing() {
            return this.disableIndexing;
        }

        public final void setDisableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
        }

        @Override
        public final Builder disableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
            return this;
        }

        public final ComparativeOrder.Builder getComparativeOrder() {
            return this.comparativeOrder != null ? this.comparativeOrder.toBuilder() : null;
        }

        public final void setComparativeOrder(ComparativeOrder.BuilderImpl comparativeOrder) {
            this.comparativeOrder = comparativeOrder != null ? comparativeOrder.build() : null;
        }

        @Override
        public final Builder comparativeOrder(ComparativeOrder comparativeOrder) {
            this.comparativeOrder = comparativeOrder;
            return this;
        }

        public final SemanticType.Builder getSemanticType() {
            return this.semanticType != null ? this.semanticType.toBuilder() : null;
        }

        public final void setSemanticType(SemanticType.BuilderImpl semanticType) {
            this.semanticType = semanticType != null ? semanticType.build() : null;
        }

        @Override
        public final Builder semanticType(SemanticType semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final Collection<String> getAllowedAggregations() {
            if (this.allowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAggregations;
        }

        public final void setAllowedAggregations(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
        }

        @Override
        public final Builder allowedAggregationsWithStrings(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregationsWithStrings(String ... allowedAggregations) {
            this.allowedAggregationsWithStrings(Arrays.asList(allowedAggregations));
            return this;
        }

        @Override
        public final Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregations(AuthorSpecifiedAggregation ... allowedAggregations) {
            this.allowedAggregations(Arrays.asList(allowedAggregations));
            return this;
        }

        public final Collection<String> getNotAllowedAggregations() {
            if (this.notAllowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notAllowedAggregations;
        }

        public final void setNotAllowedAggregations(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
        }

        @Override
        public final Builder notAllowedAggregationsWithStrings(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregationsWithStrings(String ... notAllowedAggregations) {
            this.notAllowedAggregationsWithStrings(Arrays.asList(notAllowedAggregations));
            return this;
        }

        @Override
        public final Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregations(AuthorSpecifiedAggregation ... notAllowedAggregations) {
            this.notAllowedAggregations(Arrays.asList(notAllowedAggregations));
            return this;
        }

        public final DefaultFormatting.Builder getDefaultFormatting() {
            return this.defaultFormatting != null ? this.defaultFormatting.toBuilder() : null;
        }

        public final void setDefaultFormatting(DefaultFormatting.BuilderImpl defaultFormatting) {
            this.defaultFormatting = defaultFormatting != null ? defaultFormatting.build() : null;
        }

        @Override
        public final Builder defaultFormatting(DefaultFormatting defaultFormatting) {
            this.defaultFormatting = defaultFormatting;
            return this;
        }

        public final Boolean getNeverAggregateInFilter() {
            return this.neverAggregateInFilter;
        }

        public final void setNeverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
        }

        @Override
        public final Builder neverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
            return this;
        }

        public final List<CellValueSynonym.Builder> getCellValueSynonyms() {
            List<CellValueSynonym.Builder> result = CellValueSynonymsCopier.copyToBuilder(this.cellValueSynonyms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellValueSynonyms(Collection<CellValueSynonym.BuilderImpl> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copyFromBuilder(cellValueSynonyms);
        }

        @Override
        public final Builder cellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copy(cellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(CellValueSynonym ... cellValueSynonyms) {
            this.cellValueSynonyms(Arrays.asList(cellValueSynonyms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder> ... cellValueSynonyms) {
            this.cellValueSynonyms(Stream.of(cellValueSynonyms).map(c -> (CellValueSynonym)((CellValueSynonym.Builder)CellValueSynonym.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getNonAdditive() {
            return this.nonAdditive;
        }

        public final void setNonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
        }

        @Override
        public final Builder nonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
            return this;
        }

        public TopicColumn build() {
            return new TopicColumn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicColumn> {
        public Builder columnName(String var1);

        public Builder columnFriendlyName(String var1);

        public Builder columnDescription(String var1);

        public Builder columnSynonyms(Collection<String> var1);

        public Builder columnSynonyms(String ... var1);

        public Builder columnDataRole(String var1);

        public Builder columnDataRole(ColumnDataRole var1);

        public Builder aggregation(String var1);

        public Builder aggregation(DefaultAggregation var1);

        public Builder isIncludedInTopic(Boolean var1);

        public Builder disableIndexing(Boolean var1);

        public Builder comparativeOrder(ComparativeOrder var1);

        default public Builder comparativeOrder(Consumer<ComparativeOrder.Builder> comparativeOrder) {
            return this.comparativeOrder((ComparativeOrder)((ComparativeOrder.Builder)ComparativeOrder.builder().applyMutation(comparativeOrder)).build());
        }

        public Builder semanticType(SemanticType var1);

        default public Builder semanticType(Consumer<SemanticType.Builder> semanticType) {
            return this.semanticType((SemanticType)((SemanticType.Builder)SemanticType.builder().applyMutation(semanticType)).build());
        }

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TopicTimeGranularity var1);

        public Builder allowedAggregationsWithStrings(Collection<String> var1);

        public Builder allowedAggregationsWithStrings(String ... var1);

        public Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> var1);

        public Builder allowedAggregations(AuthorSpecifiedAggregation ... var1);

        public Builder notAllowedAggregationsWithStrings(Collection<String> var1);

        public Builder notAllowedAggregationsWithStrings(String ... var1);

        public Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> var1);

        public Builder notAllowedAggregations(AuthorSpecifiedAggregation ... var1);

        public Builder defaultFormatting(DefaultFormatting var1);

        default public Builder defaultFormatting(Consumer<DefaultFormatting.Builder> defaultFormatting) {
            return this.defaultFormatting((DefaultFormatting)((DefaultFormatting.Builder)DefaultFormatting.builder().applyMutation(defaultFormatting)).build());
        }

        public Builder neverAggregateInFilter(Boolean var1);

        public Builder cellValueSynonyms(Collection<CellValueSynonym> var1);

        public Builder cellValueSynonyms(CellValueSynonym ... var1);

        public Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder> ... var1);

        public Builder nonAdditive(Boolean var1);
    }
}

