/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FailedKeyRegistrationEntriesCopier;
import software.amazon.awssdk.services.quicksight.model.FailedKeyRegistrationEntry;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.SuccessfulKeyRegistrationEntriesCopier;
import software.amazon.awssdk.services.quicksight.model.SuccessfulKeyRegistrationEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKeyRegistrationResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateKeyRegistrationResponse> {
    private static final SdkField<List<FailedKeyRegistrationEntry>> FAILED_KEY_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedKeyRegistration").getter(UpdateKeyRegistrationResponse.getter(UpdateKeyRegistrationResponse::failedKeyRegistration)).setter(UpdateKeyRegistrationResponse.setter(Builder::failedKeyRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedKeyRegistration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedKeyRegistrationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SuccessfulKeyRegistrationEntry>> SUCCESSFUL_KEY_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulKeyRegistration").getter(UpdateKeyRegistrationResponse.getter(UpdateKeyRegistrationResponse::successfulKeyRegistration)).setter(UpdateKeyRegistrationResponse.setter(Builder::successfulKeyRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulKeyRegistration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulKeyRegistrationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateKeyRegistrationResponse.getter(UpdateKeyRegistrationResponse::requestId)).setter(UpdateKeyRegistrationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_KEY_REGISTRATION_FIELD, SUCCESSFUL_KEY_REGISTRATION_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FailedKeyRegistration", FAILED_KEY_REGISTRATION_FIELD);
            this.put("SuccessfulKeyRegistration", SUCCESSFUL_KEY_REGISTRATION_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
        }
    });
    private final List<FailedKeyRegistrationEntry> failedKeyRegistration;
    private final List<SuccessfulKeyRegistrationEntry> successfulKeyRegistration;
    private final String requestId;

    private UpdateKeyRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.failedKeyRegistration = builder.failedKeyRegistration;
        this.successfulKeyRegistration = builder.successfulKeyRegistration;
        this.requestId = builder.requestId;
    }

    public final boolean hasFailedKeyRegistration() {
        return this.failedKeyRegistration != null && !(this.failedKeyRegistration instanceof SdkAutoConstructList);
    }

    public final List<FailedKeyRegistrationEntry> failedKeyRegistration() {
        return this.failedKeyRegistration;
    }

    public final boolean hasSuccessfulKeyRegistration() {
        return this.successfulKeyRegistration != null && !(this.successfulKeyRegistration instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulKeyRegistrationEntry> successfulKeyRegistration() {
        return this.successfulKeyRegistration;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedKeyRegistration() ? this.failedKeyRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulKeyRegistration() ? this.successfulKeyRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyRegistrationResponse)) {
            return false;
        }
        UpdateKeyRegistrationResponse other = (UpdateKeyRegistrationResponse)((Object)obj);
        return this.hasFailedKeyRegistration() == other.hasFailedKeyRegistration() && Objects.equals(this.failedKeyRegistration(), other.failedKeyRegistration()) && this.hasSuccessfulKeyRegistration() == other.hasSuccessfulKeyRegistration() && Objects.equals(this.successfulKeyRegistration(), other.successfulKeyRegistration()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKeyRegistrationResponse").add("FailedKeyRegistration", this.hasFailedKeyRegistration() ? this.failedKeyRegistration() : null).add("SuccessfulKeyRegistration", this.hasSuccessfulKeyRegistration() ? this.successfulKeyRegistration() : null).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedKeyRegistration": {
                return Optional.ofNullable(clazz.cast(this.failedKeyRegistration()));
            }
            case "SuccessfulKeyRegistration": {
                return Optional.ofNullable(clazz.cast(this.successfulKeyRegistration()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyRegistrationResponse, T> g) {
        return obj -> g.apply((UpdateKeyRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<FailedKeyRegistrationEntry> failedKeyRegistration = DefaultSdkAutoConstructList.getInstance();
        private List<SuccessfulKeyRegistrationEntry> successfulKeyRegistration = DefaultSdkAutoConstructList.getInstance();
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyRegistrationResponse model) {
            super(model);
            this.failedKeyRegistration(model.failedKeyRegistration);
            this.successfulKeyRegistration(model.successfulKeyRegistration);
            this.requestId(model.requestId);
        }

        public final List<FailedKeyRegistrationEntry.Builder> getFailedKeyRegistration() {
            List<FailedKeyRegistrationEntry.Builder> result = FailedKeyRegistrationEntriesCopier.copyToBuilder(this.failedKeyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedKeyRegistration(Collection<FailedKeyRegistrationEntry.BuilderImpl> failedKeyRegistration) {
            this.failedKeyRegistration = FailedKeyRegistrationEntriesCopier.copyFromBuilder(failedKeyRegistration);
        }

        @Override
        public final Builder failedKeyRegistration(Collection<FailedKeyRegistrationEntry> failedKeyRegistration) {
            this.failedKeyRegistration = FailedKeyRegistrationEntriesCopier.copy(failedKeyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedKeyRegistration(FailedKeyRegistrationEntry ... failedKeyRegistration) {
            this.failedKeyRegistration(Arrays.asList(failedKeyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedKeyRegistration(Consumer<FailedKeyRegistrationEntry.Builder> ... failedKeyRegistration) {
            this.failedKeyRegistration(Stream.of(failedKeyRegistration).map(c -> (FailedKeyRegistrationEntry)((FailedKeyRegistrationEntry.Builder)FailedKeyRegistrationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SuccessfulKeyRegistrationEntry.Builder> getSuccessfulKeyRegistration() {
            List<SuccessfulKeyRegistrationEntry.Builder> result = SuccessfulKeyRegistrationEntriesCopier.copyToBuilder(this.successfulKeyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulKeyRegistration(Collection<SuccessfulKeyRegistrationEntry.BuilderImpl> successfulKeyRegistration) {
            this.successfulKeyRegistration = SuccessfulKeyRegistrationEntriesCopier.copyFromBuilder(successfulKeyRegistration);
        }

        @Override
        public final Builder successfulKeyRegistration(Collection<SuccessfulKeyRegistrationEntry> successfulKeyRegistration) {
            this.successfulKeyRegistration = SuccessfulKeyRegistrationEntriesCopier.copy(successfulKeyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulKeyRegistration(SuccessfulKeyRegistrationEntry ... successfulKeyRegistration) {
            this.successfulKeyRegistration(Arrays.asList(successfulKeyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulKeyRegistration(Consumer<SuccessfulKeyRegistrationEntry.Builder> ... successfulKeyRegistration) {
            this.successfulKeyRegistration(Stream.of(successfulKeyRegistration).map(c -> (SuccessfulKeyRegistrationEntry)((SuccessfulKeyRegistrationEntry.Builder)SuccessfulKeyRegistrationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public UpdateKeyRegistrationResponse build() {
            return new UpdateKeyRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKeyRegistrationResponse> {
        public Builder failedKeyRegistration(Collection<FailedKeyRegistrationEntry> var1);

        public Builder failedKeyRegistration(FailedKeyRegistrationEntry ... var1);

        public Builder failedKeyRegistration(Consumer<FailedKeyRegistrationEntry.Builder> ... var1);

        public Builder successfulKeyRegistration(Collection<SuccessfulKeyRegistrationEntry> var1);

        public Builder successfulKeyRegistration(SuccessfulKeyRegistrationEntry ... var1);

        public Builder successfulKeyRegistration(Consumer<SuccessfulKeyRegistrationEntry.Builder> ... var1);

        public Builder requestId(String var1);
    }
}

