/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserSnapshotJobResult;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserSnapshotJobResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotJobResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotJobResult> {
    private static final SdkField<List<AnonymousUserSnapshotJobResult>> ANONYMOUS_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnonymousUsers").getter(SnapshotJobResult.getter(SnapshotJobResult::anonymousUsers)).setter(SnapshotJobResult.setter(Builder::anonymousUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnonymousUserSnapshotJobResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMOUS_USERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AnonymousUsers", ANONYMOUS_USERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AnonymousUserSnapshotJobResult> anonymousUsers;

    private SnapshotJobResult(BuilderImpl builder) {
        this.anonymousUsers = builder.anonymousUsers;
    }

    public final boolean hasAnonymousUsers() {
        return this.anonymousUsers != null && !(this.anonymousUsers instanceof SdkAutoConstructList);
    }

    public final List<AnonymousUserSnapshotJobResult> anonymousUsers() {
        return this.anonymousUsers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnonymousUsers() ? this.anonymousUsers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotJobResult)) {
            return false;
        }
        SnapshotJobResult other = (SnapshotJobResult)obj;
        return this.hasAnonymousUsers() == other.hasAnonymousUsers() && Objects.equals(this.anonymousUsers(), other.anonymousUsers());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotJobResult").add("AnonymousUsers", this.hasAnonymousUsers() ? this.anonymousUsers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnonymousUsers": {
                return Optional.ofNullable(clazz.cast(this.anonymousUsers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotJobResult, T> g) {
        return obj -> g.apply((SnapshotJobResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnonymousUserSnapshotJobResult> anonymousUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotJobResult model) {
            this.anonymousUsers(model.anonymousUsers);
        }

        public final List<AnonymousUserSnapshotJobResult.Builder> getAnonymousUsers() {
            List<AnonymousUserSnapshotJobResult.Builder> result = AnonymousUserSnapshotJobResultListCopier.copyToBuilder(this.anonymousUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnonymousUsers(Collection<AnonymousUserSnapshotJobResult.BuilderImpl> anonymousUsers) {
            this.anonymousUsers = AnonymousUserSnapshotJobResultListCopier.copyFromBuilder(anonymousUsers);
        }

        @Override
        public final Builder anonymousUsers(Collection<AnonymousUserSnapshotJobResult> anonymousUsers) {
            this.anonymousUsers = AnonymousUserSnapshotJobResultListCopier.copy(anonymousUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(AnonymousUserSnapshotJobResult ... anonymousUsers) {
            this.anonymousUsers(Arrays.asList(anonymousUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(Consumer<AnonymousUserSnapshotJobResult.Builder> ... anonymousUsers) {
            this.anonymousUsers(Stream.of(anonymousUsers).map(c -> (AnonymousUserSnapshotJobResult)((AnonymousUserSnapshotJobResult.Builder)AnonymousUserSnapshotJobResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SnapshotJobResult build() {
            return new SnapshotJobResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotJobResult> {
        public Builder anonymousUsers(Collection<AnonymousUserSnapshotJobResult> var1);

        public Builder anonymousUsers(AnonymousUserSnapshotJobResult ... var1);

        public Builder anonymousUsers(Consumer<AnonymousUserSnapshotJobResult.Builder> ... var1);
    }
}

