/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.BodySectionConfiguration;
import software.amazon.awssdk.services.quicksight.model.BodySectionConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration;
import software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.SectionBasedLayoutCanvasSizeOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SectionBasedLayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SectionBasedLayoutConfiguration> {
    private static final SdkField<List<HeaderFooterSectionConfiguration>> HEADER_SECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeaderSections").getter(SectionBasedLayoutConfiguration.getter(SectionBasedLayoutConfiguration::headerSections)).setter(SectionBasedLayoutConfiguration.setter(Builder::headerSections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderSections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HeaderFooterSectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BodySectionConfiguration>> BODY_SECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BodySections").getter(SectionBasedLayoutConfiguration.getter(SectionBasedLayoutConfiguration::bodySections)).setter(SectionBasedLayoutConfiguration.setter(Builder::bodySections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodySections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BodySectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HeaderFooterSectionConfiguration>> FOOTER_SECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FooterSections").getter(SectionBasedLayoutConfiguration.getter(SectionBasedLayoutConfiguration::footerSections)).setter(SectionBasedLayoutConfiguration.setter(Builder::footerSections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FooterSections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HeaderFooterSectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SectionBasedLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CanvasSizeOptions").getter(SectionBasedLayoutConfiguration.getter(SectionBasedLayoutConfiguration::canvasSizeOptions)).setter(SectionBasedLayoutConfiguration.setter(Builder::canvasSizeOptions)).constructor(SectionBasedLayoutCanvasSizeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_SECTIONS_FIELD, BODY_SECTIONS_FIELD, FOOTER_SECTIONS_FIELD, CANVAS_SIZE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HeaderSections", HEADER_SECTIONS_FIELD);
            this.put("BodySections", BODY_SECTIONS_FIELD);
            this.put("FooterSections", FOOTER_SECTIONS_FIELD);
            this.put("CanvasSizeOptions", CANVAS_SIZE_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<HeaderFooterSectionConfiguration> headerSections;
    private final List<BodySectionConfiguration> bodySections;
    private final List<HeaderFooterSectionConfiguration> footerSections;
    private final SectionBasedLayoutCanvasSizeOptions canvasSizeOptions;

    private SectionBasedLayoutConfiguration(BuilderImpl builder) {
        this.headerSections = builder.headerSections;
        this.bodySections = builder.bodySections;
        this.footerSections = builder.footerSections;
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    public final boolean hasHeaderSections() {
        return this.headerSections != null && !(this.headerSections instanceof SdkAutoConstructList);
    }

    public final List<HeaderFooterSectionConfiguration> headerSections() {
        return this.headerSections;
    }

    public final boolean hasBodySections() {
        return this.bodySections != null && !(this.bodySections instanceof SdkAutoConstructList);
    }

    public final List<BodySectionConfiguration> bodySections() {
        return this.bodySections;
    }

    public final boolean hasFooterSections() {
        return this.footerSections != null && !(this.footerSections instanceof SdkAutoConstructList);
    }

    public final List<HeaderFooterSectionConfiguration> footerSections() {
        return this.footerSections;
    }

    public final SectionBasedLayoutCanvasSizeOptions canvasSizeOptions() {
        return this.canvasSizeOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderSections() ? this.headerSections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBodySections() ? this.bodySections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFooterSections() ? this.footerSections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canvasSizeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionBasedLayoutConfiguration)) {
            return false;
        }
        SectionBasedLayoutConfiguration other = (SectionBasedLayoutConfiguration)obj;
        return this.hasHeaderSections() == other.hasHeaderSections() && Objects.equals(this.headerSections(), other.headerSections()) && this.hasBodySections() == other.hasBodySections() && Objects.equals(this.bodySections(), other.bodySections()) && this.hasFooterSections() == other.hasFooterSections() && Objects.equals(this.footerSections(), other.footerSections()) && Objects.equals(this.canvasSizeOptions(), other.canvasSizeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"SectionBasedLayoutConfiguration").add("HeaderSections", this.hasHeaderSections() ? this.headerSections() : null).add("BodySections", this.hasBodySections() ? this.bodySections() : null).add("FooterSections", this.hasFooterSections() ? this.footerSections() : null).add("CanvasSizeOptions", (Object)this.canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HeaderSections": {
                return Optional.ofNullable(clazz.cast(this.headerSections()));
            }
            case "BodySections": {
                return Optional.ofNullable(clazz.cast(this.bodySections()));
            }
            case "FooterSections": {
                return Optional.ofNullable(clazz.cast(this.footerSections()));
            }
            case "CanvasSizeOptions": {
                return Optional.ofNullable(clazz.cast(this.canvasSizeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SectionBasedLayoutConfiguration, T> g) {
        return obj -> g.apply((SectionBasedLayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HeaderFooterSectionConfiguration> headerSections = DefaultSdkAutoConstructList.getInstance();
        private List<BodySectionConfiguration> bodySections = DefaultSdkAutoConstructList.getInstance();
        private List<HeaderFooterSectionConfiguration> footerSections = DefaultSdkAutoConstructList.getInstance();
        private SectionBasedLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionBasedLayoutConfiguration model) {
            this.headerSections(model.headerSections);
            this.bodySections(model.bodySections);
            this.footerSections(model.footerSections);
            this.canvasSizeOptions(model.canvasSizeOptions);
        }

        public final List<HeaderFooterSectionConfiguration.Builder> getHeaderSections() {
            List<HeaderFooterSectionConfiguration.Builder> result = HeaderFooterSectionConfigurationListCopier.copyToBuilder(this.headerSections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaderSections(Collection<HeaderFooterSectionConfiguration.BuilderImpl> headerSections) {
            this.headerSections = HeaderFooterSectionConfigurationListCopier.copyFromBuilder(headerSections);
        }

        @Override
        public final Builder headerSections(Collection<HeaderFooterSectionConfiguration> headerSections) {
            this.headerSections = HeaderFooterSectionConfigurationListCopier.copy(headerSections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerSections(HeaderFooterSectionConfiguration ... headerSections) {
            this.headerSections(Arrays.asList(headerSections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerSections(Consumer<HeaderFooterSectionConfiguration.Builder> ... headerSections) {
            this.headerSections(Stream.of(headerSections).map(c -> (HeaderFooterSectionConfiguration)((HeaderFooterSectionConfiguration.Builder)HeaderFooterSectionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BodySectionConfiguration.Builder> getBodySections() {
            List<BodySectionConfiguration.Builder> result = BodySectionConfigurationListCopier.copyToBuilder(this.bodySections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBodySections(Collection<BodySectionConfiguration.BuilderImpl> bodySections) {
            this.bodySections = BodySectionConfigurationListCopier.copyFromBuilder(bodySections);
        }

        @Override
        public final Builder bodySections(Collection<BodySectionConfiguration> bodySections) {
            this.bodySections = BodySectionConfigurationListCopier.copy(bodySections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodySections(BodySectionConfiguration ... bodySections) {
            this.bodySections(Arrays.asList(bodySections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodySections(Consumer<BodySectionConfiguration.Builder> ... bodySections) {
            this.bodySections(Stream.of(bodySections).map(c -> (BodySectionConfiguration)((BodySectionConfiguration.Builder)BodySectionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HeaderFooterSectionConfiguration.Builder> getFooterSections() {
            List<HeaderFooterSectionConfiguration.Builder> result = HeaderFooterSectionConfigurationListCopier.copyToBuilder(this.footerSections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFooterSections(Collection<HeaderFooterSectionConfiguration.BuilderImpl> footerSections) {
            this.footerSections = HeaderFooterSectionConfigurationListCopier.copyFromBuilder(footerSections);
        }

        @Override
        public final Builder footerSections(Collection<HeaderFooterSectionConfiguration> footerSections) {
            this.footerSections = HeaderFooterSectionConfigurationListCopier.copy(footerSections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerSections(HeaderFooterSectionConfiguration ... footerSections) {
            this.footerSections(Arrays.asList(footerSections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerSections(Consumer<HeaderFooterSectionConfiguration.Builder> ... footerSections) {
            this.footerSections(Stream.of(footerSections).map(c -> (HeaderFooterSectionConfiguration)((HeaderFooterSectionConfiguration.Builder)HeaderFooterSectionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SectionBasedLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return this.canvasSizeOptions != null ? this.canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(SectionBasedLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        public SectionBasedLayoutConfiguration build() {
            return new SectionBasedLayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SectionBasedLayoutConfiguration> {
        public Builder headerSections(Collection<HeaderFooterSectionConfiguration> var1);

        public Builder headerSections(HeaderFooterSectionConfiguration ... var1);

        public Builder headerSections(Consumer<HeaderFooterSectionConfiguration.Builder> ... var1);

        public Builder bodySections(Collection<BodySectionConfiguration> var1);

        public Builder bodySections(BodySectionConfiguration ... var1);

        public Builder bodySections(Consumer<BodySectionConfiguration.Builder> ... var1);

        public Builder footerSections(Collection<HeaderFooterSectionConfiguration> var1);

        public Builder footerSections(HeaderFooterSectionConfiguration ... var1);

        public Builder footerSections(Consumer<HeaderFooterSectionConfiguration.Builder> ... var1);

        public Builder canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions var1);

        default public Builder canvasSizeOptions(Consumer<SectionBasedLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return this.canvasSizeOptions((SectionBasedLayoutCanvasSizeOptions)((SectionBasedLayoutCanvasSizeOptions.Builder)SectionBasedLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions)).build());
        }
    }
}

