/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MappedDataSetParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MappedDataSetParameter> {
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetIdentifier").getter(MappedDataSetParameter.getter(MappedDataSetParameter::dataSetIdentifier)).setter(MappedDataSetParameter.setter(Builder::dataSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()}).build();
    private static final SdkField<String> DATA_SET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetParameterName").getter(MappedDataSetParameter.getter(MappedDataSetParameter::dataSetParameterName)).setter(MappedDataSetParameter.setter(Builder::dataSetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetParameterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDENTIFIER_FIELD, DATA_SET_PARAMETER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSetIdentifier", DATA_SET_IDENTIFIER_FIELD);
            this.put("DataSetParameterName", DATA_SET_PARAMETER_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataSetIdentifier;
    private final String dataSetParameterName;

    private MappedDataSetParameter(BuilderImpl builder) {
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.dataSetParameterName = builder.dataSetParameterName;
    }

    public final String dataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public final String dataSetParameterName() {
        return this.dataSetParameterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetParameterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappedDataSetParameter)) {
            return false;
        }
        MappedDataSetParameter other = (MappedDataSetParameter)obj;
        return Objects.equals(this.dataSetIdentifier(), other.dataSetIdentifier()) && Objects.equals(this.dataSetParameterName(), other.dataSetParameterName());
    }

    public final String toString() {
        return ToString.builder((String)"MappedDataSetParameter").add("DataSetIdentifier", (Object)this.dataSetIdentifier()).add("DataSetParameterName", (Object)this.dataSetParameterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataSetIdentifier()));
            }
            case "DataSetParameterName": {
                return Optional.ofNullable(clazz.cast(this.dataSetParameterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MappedDataSetParameter, T> g) {
        return obj -> g.apply((MappedDataSetParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetIdentifier;
        private String dataSetParameterName;

        private BuilderImpl() {
        }

        private BuilderImpl(MappedDataSetParameter model) {
            this.dataSetIdentifier(model.dataSetIdentifier);
            this.dataSetParameterName(model.dataSetParameterName);
        }

        public final String getDataSetIdentifier() {
            return this.dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final String getDataSetParameterName() {
            return this.dataSetParameterName;
        }

        public final void setDataSetParameterName(String dataSetParameterName) {
            this.dataSetParameterName = dataSetParameterName;
        }

        @Override
        public final Builder dataSetParameterName(String dataSetParameterName) {
            this.dataSetParameterName = dataSetParameterName;
            return this;
        }

        public MappedDataSetParameter build() {
            return new MappedDataSetParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MappedDataSetParameter> {
        public Builder dataSetIdentifier(String var1);

        public Builder dataSetParameterName(String var1);
    }
}

