/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(LabelOptions.getter(LabelOptions::visibilityAsString)).setter(LabelOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontConfiguration").getter(LabelOptions.getter(LabelOptions::fontConfiguration)).setter(LabelOptions.setter(Builder::fontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()}).build();
    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLabel").getter(LabelOptions.getter(LabelOptions::customLabel)).setter(LabelOptions.setter(Builder::customLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, FONT_CONFIGURATION_FIELD, CUSTOM_LABEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Visibility", VISIBILITY_FIELD);
            this.put("FontConfiguration", FONT_CONFIGURATION_FIELD);
            this.put("CustomLabel", CUSTOM_LABEL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final FontConfiguration fontConfiguration;
    private final String customLabel;

    private LabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.fontConfiguration = builder.fontConfiguration;
        this.customLabel = builder.customLabel;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final FontConfiguration fontConfiguration() {
        return this.fontConfiguration;
    }

    public final String customLabel() {
        return this.customLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelOptions)) {
            return false;
        }
        LabelOptions other = (LabelOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.fontConfiguration(), other.fontConfiguration()) && Objects.equals(this.customLabel(), other.customLabel());
    }

    public final String toString() {
        return ToString.builder((String)"LabelOptions").add("Visibility", (Object)this.visibilityAsString()).add("FontConfiguration", (Object)this.fontConfiguration()).add("CustomLabel", (Object)this.customLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "FontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fontConfiguration()));
            }
            case "CustomLabel": {
                return Optional.ofNullable(clazz.cast(this.customLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LabelOptions, T> g) {
        return obj -> g.apply((LabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private FontConfiguration fontConfiguration;
        private String customLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelOptions model) {
            this.visibility(model.visibility);
            this.fontConfiguration(model.fontConfiguration);
            this.customLabel(model.customLabel);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return this.fontConfiguration != null ? this.fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getCustomLabel() {
            return this.customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public LabelOptions build() {
            return new LabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder fontConfiguration(FontConfiguration var1);

        default public Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return this.fontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(fontConfiguration)).build());
        }

        public Builder customLabel(String var1);
    }
}

