/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPathLabelType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPathLabelType> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(DataPathLabelType.getter(DataPathLabelType::fieldId)).setter(DataPathLabelType.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldValue").getter(DataPathLabelType.getter(DataPathLabelType::fieldValue)).setter(DataPathLabelType.setter(Builder::fieldValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(DataPathLabelType.getter(DataPathLabelType::visibilityAsString)).setter(DataPathLabelType.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, FIELD_VALUE_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FieldId", FIELD_ID_FIELD);
            this.put("FieldValue", FIELD_VALUE_FIELD);
            this.put("Visibility", VISIBILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String fieldValue;
    private final String visibility;

    private DataPathLabelType(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.fieldValue = builder.fieldValue;
        this.visibility = builder.visibility;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String fieldValue() {
        return this.fieldValue;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathLabelType)) {
            return false;
        }
        DataPathLabelType other = (DataPathLabelType)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.fieldValue(), other.fieldValue()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataPathLabelType").add("FieldId", (Object)this.fieldId()).add("FieldValue", (Object)(this.fieldValue() == null ? null : "*** Sensitive Data Redacted ***")).add("Visibility", (Object)this.visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "FieldValue": {
                return Optional.ofNullable(clazz.cast(this.fieldValue()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataPathLabelType, T> g) {
        return obj -> g.apply((DataPathLabelType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String fieldValue;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathLabelType model) {
            this.fieldId(model.fieldId);
            this.fieldValue(model.fieldValue);
            this.visibility(model.visibility);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getFieldValue() {
            return this.fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public DataPathLabelType build() {
            return new DataPathLabelType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPathLabelType> {
        public Builder fieldId(String var1);

        public Builder fieldValue(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);
    }
}

