/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AuthenticationMethodOption;
import software.amazon.awssdk.services.quicksight.model.Edition;
import software.amazon.awssdk.services.quicksight.model.GroupsListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccountSubscriptionRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateAccountSubscriptionRequest> {
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::editionAsString)).setter(CreateAccountSubscriptionRequest.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMethod").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::authenticationMethodAsString)).setter(CreateAccountSubscriptionRequest.setter(Builder::authenticationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::awsAccountId)).setter(CreateAccountSubscriptionRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::accountName)).setter(CreateAccountSubscriptionRequest.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationEmail").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::notificationEmail)).setter(CreateAccountSubscriptionRequest.setter(Builder::notificationEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()}).build();
    private static final SdkField<String> ACTIVE_DIRECTORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveDirectoryName").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::activeDirectoryName)).setter(CreateAccountSubscriptionRequest.setter(Builder::activeDirectoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryName").build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::realm)).setter(CreateAccountSubscriptionRequest.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::directoryId)).setter(CreateAccountSubscriptionRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> ADMIN_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminGroup").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::adminGroup)).setter(CreateAccountSubscriptionRequest.setter(Builder::adminGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTHOR_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorGroup").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::authorGroup)).setter(CreateAccountSubscriptionRequest.setter(Builder::authorGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> READER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReaderGroup").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::readerGroup)).setter(CreateAccountSubscriptionRequest.setter(Builder::readerGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADMIN_PRO_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminProGroup").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::adminProGroup)).setter(CreateAccountSubscriptionRequest.setter(Builder::adminProGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminProGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTHOR_PRO_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorProGroup").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::authorProGroup)).setter(CreateAccountSubscriptionRequest.setter(Builder::authorProGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorProGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> READER_PRO_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReaderProGroup").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::readerProGroup)).setter(CreateAccountSubscriptionRequest.setter(Builder::readerProGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderProGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::firstName)).setter(CreateAccountSubscriptionRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::lastName)).setter(CreateAccountSubscriptionRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::emailAddress)).setter(CreateAccountSubscriptionRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> CONTACT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactNumber").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::contactNumber)).setter(CreateAccountSubscriptionRequest.setter(Builder::contactNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactNumber").build()}).build();
    private static final SdkField<String> IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMIdentityCenterInstanceArn").getter(CreateAccountSubscriptionRequest.getter(CreateAccountSubscriptionRequest::iamIdentityCenterInstanceArn)).setter(CreateAccountSubscriptionRequest.setter(Builder::iamIdentityCenterInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMIdentityCenterInstanceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITION_FIELD, AUTHENTICATION_METHOD_FIELD, AWS_ACCOUNT_ID_FIELD, ACCOUNT_NAME_FIELD, NOTIFICATION_EMAIL_FIELD, ACTIVE_DIRECTORY_NAME_FIELD, REALM_FIELD, DIRECTORY_ID_FIELD, ADMIN_GROUP_FIELD, AUTHOR_GROUP_FIELD, READER_GROUP_FIELD, ADMIN_PRO_GROUP_FIELD, AUTHOR_PRO_GROUP_FIELD, READER_PRO_GROUP_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_ADDRESS_FIELD, CONTACT_NUMBER_FIELD, IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Edition", EDITION_FIELD);
            this.put("AuthenticationMethod", AUTHENTICATION_METHOD_FIELD);
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("AccountName", ACCOUNT_NAME_FIELD);
            this.put("NotificationEmail", NOTIFICATION_EMAIL_FIELD);
            this.put("ActiveDirectoryName", ACTIVE_DIRECTORY_NAME_FIELD);
            this.put("Realm", REALM_FIELD);
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("AdminGroup", ADMIN_GROUP_FIELD);
            this.put("AuthorGroup", AUTHOR_GROUP_FIELD);
            this.put("ReaderGroup", READER_GROUP_FIELD);
            this.put("AdminProGroup", ADMIN_PRO_GROUP_FIELD);
            this.put("AuthorProGroup", AUTHOR_PRO_GROUP_FIELD);
            this.put("ReaderProGroup", READER_PRO_GROUP_FIELD);
            this.put("FirstName", FIRST_NAME_FIELD);
            this.put("LastName", LAST_NAME_FIELD);
            this.put("EmailAddress", EMAIL_ADDRESS_FIELD);
            this.put("ContactNumber", CONTACT_NUMBER_FIELD);
            this.put("IAMIdentityCenterInstanceArn", IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        }
    });
    private final String edition;
    private final String authenticationMethod;
    private final String awsAccountId;
    private final String accountName;
    private final String notificationEmail;
    private final String activeDirectoryName;
    private final String realm;
    private final String directoryId;
    private final List<String> adminGroup;
    private final List<String> authorGroup;
    private final List<String> readerGroup;
    private final List<String> adminProGroup;
    private final List<String> authorProGroup;
    private final List<String> readerProGroup;
    private final String firstName;
    private final String lastName;
    private final String emailAddress;
    private final String contactNumber;
    private final String iamIdentityCenterInstanceArn;

    private CreateAccountSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.edition = builder.edition;
        this.authenticationMethod = builder.authenticationMethod;
        this.awsAccountId = builder.awsAccountId;
        this.accountName = builder.accountName;
        this.notificationEmail = builder.notificationEmail;
        this.activeDirectoryName = builder.activeDirectoryName;
        this.realm = builder.realm;
        this.directoryId = builder.directoryId;
        this.adminGroup = builder.adminGroup;
        this.authorGroup = builder.authorGroup;
        this.readerGroup = builder.readerGroup;
        this.adminProGroup = builder.adminProGroup;
        this.authorProGroup = builder.authorProGroup;
        this.readerProGroup = builder.readerProGroup;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.emailAddress = builder.emailAddress;
        this.contactNumber = builder.contactNumber;
        this.iamIdentityCenterInstanceArn = builder.iamIdentityCenterInstanceArn;
    }

    public final Edition edition() {
        return Edition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public final AuthenticationMethodOption authenticationMethod() {
        return AuthenticationMethodOption.fromValue(this.authenticationMethod);
    }

    public final String authenticationMethodAsString() {
        return this.authenticationMethod;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final String notificationEmail() {
        return this.notificationEmail;
    }

    public final String activeDirectoryName() {
        return this.activeDirectoryName;
    }

    public final String realm() {
        return this.realm;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasAdminGroup() {
        return this.adminGroup != null && !(this.adminGroup instanceof SdkAutoConstructList);
    }

    public final List<String> adminGroup() {
        return this.adminGroup;
    }

    public final boolean hasAuthorGroup() {
        return this.authorGroup != null && !(this.authorGroup instanceof SdkAutoConstructList);
    }

    public final List<String> authorGroup() {
        return this.authorGroup;
    }

    public final boolean hasReaderGroup() {
        return this.readerGroup != null && !(this.readerGroup instanceof SdkAutoConstructList);
    }

    public final List<String> readerGroup() {
        return this.readerGroup;
    }

    public final boolean hasAdminProGroup() {
        return this.adminProGroup != null && !(this.adminProGroup instanceof SdkAutoConstructList);
    }

    public final List<String> adminProGroup() {
        return this.adminProGroup;
    }

    public final boolean hasAuthorProGroup() {
        return this.authorProGroup != null && !(this.authorProGroup instanceof SdkAutoConstructList);
    }

    public final List<String> authorProGroup() {
        return this.authorProGroup;
    }

    public final boolean hasReaderProGroup() {
        return this.readerProGroup != null && !(this.readerProGroup instanceof SdkAutoConstructList);
    }

    public final List<String> readerProGroup() {
        return this.readerProGroup;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String contactNumber() {
        return this.contactNumber;
    }

    public final String iamIdentityCenterInstanceArn() {
        return this.iamIdentityCenterInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminGroup() ? this.adminGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorGroup() ? this.authorGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReaderGroup() ? this.readerGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminProGroup() ? this.adminProGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorProGroup() ? this.authorProGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReaderProGroup() ? this.readerProGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterInstanceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountSubscriptionRequest)) {
            return false;
        }
        CreateAccountSubscriptionRequest other = (CreateAccountSubscriptionRequest)((Object)obj);
        return Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.authenticationMethodAsString(), other.authenticationMethodAsString()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.notificationEmail(), other.notificationEmail()) && Objects.equals(this.activeDirectoryName(), other.activeDirectoryName()) && Objects.equals(this.realm(), other.realm()) && Objects.equals(this.directoryId(), other.directoryId()) && this.hasAdminGroup() == other.hasAdminGroup() && Objects.equals(this.adminGroup(), other.adminGroup()) && this.hasAuthorGroup() == other.hasAuthorGroup() && Objects.equals(this.authorGroup(), other.authorGroup()) && this.hasReaderGroup() == other.hasReaderGroup() && Objects.equals(this.readerGroup(), other.readerGroup()) && this.hasAdminProGroup() == other.hasAdminProGroup() && Objects.equals(this.adminProGroup(), other.adminProGroup()) && this.hasAuthorProGroup() == other.hasAuthorProGroup() && Objects.equals(this.authorProGroup(), other.authorProGroup()) && this.hasReaderProGroup() == other.hasReaderProGroup() && Objects.equals(this.readerProGroup(), other.readerProGroup()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.contactNumber(), other.contactNumber()) && Objects.equals(this.iamIdentityCenterInstanceArn(), other.iamIdentityCenterInstanceArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccountSubscriptionRequest").add("Edition", (Object)this.editionAsString()).add("AuthenticationMethod", (Object)this.authenticationMethodAsString()).add("AwsAccountId", (Object)this.awsAccountId()).add("AccountName", (Object)this.accountName()).add("NotificationEmail", (Object)this.notificationEmail()).add("ActiveDirectoryName", (Object)this.activeDirectoryName()).add("Realm", (Object)this.realm()).add("DirectoryId", (Object)this.directoryId()).add("AdminGroup", this.hasAdminGroup() ? this.adminGroup() : null).add("AuthorGroup", this.hasAuthorGroup() ? this.authorGroup() : null).add("ReaderGroup", this.hasReaderGroup() ? this.readerGroup() : null).add("AdminProGroup", this.hasAdminProGroup() ? this.adminProGroup() : null).add("AuthorProGroup", this.hasAuthorProGroup() ? this.authorProGroup() : null).add("ReaderProGroup", this.hasReaderProGroup() ? this.readerProGroup() : null).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("EmailAddress", (Object)this.emailAddress()).add("ContactNumber", (Object)this.contactNumber()).add("IAMIdentityCenterInstanceArn", (Object)this.iamIdentityCenterInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "AuthenticationMethod": {
                return Optional.ofNullable(clazz.cast(this.authenticationMethodAsString()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "NotificationEmail": {
                return Optional.ofNullable(clazz.cast(this.notificationEmail()));
            }
            case "ActiveDirectoryName": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryName()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "AdminGroup": {
                return Optional.ofNullable(clazz.cast(this.adminGroup()));
            }
            case "AuthorGroup": {
                return Optional.ofNullable(clazz.cast(this.authorGroup()));
            }
            case "ReaderGroup": {
                return Optional.ofNullable(clazz.cast(this.readerGroup()));
            }
            case "AdminProGroup": {
                return Optional.ofNullable(clazz.cast(this.adminProGroup()));
            }
            case "AuthorProGroup": {
                return Optional.ofNullable(clazz.cast(this.authorProGroup()));
            }
            case "ReaderProGroup": {
                return Optional.ofNullable(clazz.cast(this.readerProGroup()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "ContactNumber": {
                return Optional.ofNullable(clazz.cast(this.contactNumber()));
            }
            case "IAMIdentityCenterInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterInstanceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateAccountSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String edition;
        private String authenticationMethod;
        private String awsAccountId;
        private String accountName;
        private String notificationEmail;
        private String activeDirectoryName;
        private String realm;
        private String directoryId;
        private List<String> adminGroup = DefaultSdkAutoConstructList.getInstance();
        private List<String> authorGroup = DefaultSdkAutoConstructList.getInstance();
        private List<String> readerGroup = DefaultSdkAutoConstructList.getInstance();
        private List<String> adminProGroup = DefaultSdkAutoConstructList.getInstance();
        private List<String> authorProGroup = DefaultSdkAutoConstructList.getInstance();
        private List<String> readerProGroup = DefaultSdkAutoConstructList.getInstance();
        private String firstName;
        private String lastName;
        private String emailAddress;
        private String contactNumber;
        private String iamIdentityCenterInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountSubscriptionRequest model) {
            super(model);
            this.edition(model.edition);
            this.authenticationMethod(model.authenticationMethod);
            this.awsAccountId(model.awsAccountId);
            this.accountName(model.accountName);
            this.notificationEmail(model.notificationEmail);
            this.activeDirectoryName(model.activeDirectoryName);
            this.realm(model.realm);
            this.directoryId(model.directoryId);
            this.adminGroup(model.adminGroup);
            this.authorGroup(model.authorGroup);
            this.readerGroup(model.readerGroup);
            this.adminProGroup(model.adminProGroup);
            this.authorProGroup(model.authorProGroup);
            this.readerProGroup(model.readerProGroup);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.emailAddress(model.emailAddress);
            this.contactNumber(model.contactNumber);
            this.iamIdentityCenterInstanceArn(model.iamIdentityCenterInstanceArn);
        }

        public final String getEdition() {
            return this.edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getAuthenticationMethod() {
            return this.authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(AuthenticationMethodOption authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getNotificationEmail() {
            return this.notificationEmail;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final String getActiveDirectoryName() {
            return this.activeDirectoryName;
        }

        public final void setActiveDirectoryName(String activeDirectoryName) {
            this.activeDirectoryName = activeDirectoryName;
        }

        @Override
        public final Builder activeDirectoryName(String activeDirectoryName) {
            this.activeDirectoryName = activeDirectoryName;
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getAdminGroup() {
            if (this.adminGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adminGroup;
        }

        public final void setAdminGroup(Collection<String> adminGroup) {
            this.adminGroup = GroupsListCopier.copy(adminGroup);
        }

        @Override
        public final Builder adminGroup(Collection<String> adminGroup) {
            this.adminGroup = GroupsListCopier.copy(adminGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminGroup(String ... adminGroup) {
            this.adminGroup(Arrays.asList(adminGroup));
            return this;
        }

        public final Collection<String> getAuthorGroup() {
            if (this.authorGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorGroup;
        }

        public final void setAuthorGroup(Collection<String> authorGroup) {
            this.authorGroup = GroupsListCopier.copy(authorGroup);
        }

        @Override
        public final Builder authorGroup(Collection<String> authorGroup) {
            this.authorGroup = GroupsListCopier.copy(authorGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorGroup(String ... authorGroup) {
            this.authorGroup(Arrays.asList(authorGroup));
            return this;
        }

        public final Collection<String> getReaderGroup() {
            if (this.readerGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readerGroup;
        }

        public final void setReaderGroup(Collection<String> readerGroup) {
            this.readerGroup = GroupsListCopier.copy(readerGroup);
        }

        @Override
        public final Builder readerGroup(Collection<String> readerGroup) {
            this.readerGroup = GroupsListCopier.copy(readerGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readerGroup(String ... readerGroup) {
            this.readerGroup(Arrays.asList(readerGroup));
            return this;
        }

        public final Collection<String> getAdminProGroup() {
            if (this.adminProGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adminProGroup;
        }

        public final void setAdminProGroup(Collection<String> adminProGroup) {
            this.adminProGroup = GroupsListCopier.copy(adminProGroup);
        }

        @Override
        public final Builder adminProGroup(Collection<String> adminProGroup) {
            this.adminProGroup = GroupsListCopier.copy(adminProGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminProGroup(String ... adminProGroup) {
            this.adminProGroup(Arrays.asList(adminProGroup));
            return this;
        }

        public final Collection<String> getAuthorProGroup() {
            if (this.authorProGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorProGroup;
        }

        public final void setAuthorProGroup(Collection<String> authorProGroup) {
            this.authorProGroup = GroupsListCopier.copy(authorProGroup);
        }

        @Override
        public final Builder authorProGroup(Collection<String> authorProGroup) {
            this.authorProGroup = GroupsListCopier.copy(authorProGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorProGroup(String ... authorProGroup) {
            this.authorProGroup(Arrays.asList(authorProGroup));
            return this;
        }

        public final Collection<String> getReaderProGroup() {
            if (this.readerProGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readerProGroup;
        }

        public final void setReaderProGroup(Collection<String> readerProGroup) {
            this.readerProGroup = GroupsListCopier.copy(readerProGroup);
        }

        @Override
        public final Builder readerProGroup(Collection<String> readerProGroup) {
            this.readerProGroup = GroupsListCopier.copy(readerProGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readerProGroup(String ... readerProGroup) {
            this.readerProGroup(Arrays.asList(readerProGroup));
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getContactNumber() {
            return this.contactNumber;
        }

        public final void setContactNumber(String contactNumber) {
            this.contactNumber = contactNumber;
        }

        @Override
        public final Builder contactNumber(String contactNumber) {
            this.contactNumber = contactNumber;
            return this;
        }

        public final String getIamIdentityCenterInstanceArn() {
            return this.iamIdentityCenterInstanceArn;
        }

        public final void setIamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
        }

        @Override
        public final Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccountSubscriptionRequest build() {
            return new CreateAccountSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccountSubscriptionRequest> {
        public Builder edition(String var1);

        public Builder edition(Edition var1);

        public Builder authenticationMethod(String var1);

        public Builder authenticationMethod(AuthenticationMethodOption var1);

        public Builder awsAccountId(String var1);

        public Builder accountName(String var1);

        public Builder notificationEmail(String var1);

        public Builder activeDirectoryName(String var1);

        public Builder realm(String var1);

        public Builder directoryId(String var1);

        public Builder adminGroup(Collection<String> var1);

        public Builder adminGroup(String ... var1);

        public Builder authorGroup(Collection<String> var1);

        public Builder authorGroup(String ... var1);

        public Builder readerGroup(Collection<String> var1);

        public Builder readerGroup(String ... var1);

        public Builder adminProGroup(Collection<String> var1);

        public Builder adminProGroup(String ... var1);

        public Builder authorProGroup(Collection<String> var1);

        public Builder authorProGroup(String ... var1);

        public Builder readerProGroup(Collection<String> var1);

        public Builder readerProGroup(String ... var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder emailAddress(String var1);

        public Builder contactNumber(String var1);

        public Builder iamIdentityCenterInstanceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

