/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDashboardLinksResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateDashboardLinksResponse.Builder, UpdateDashboardLinksResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateDashboardLinksResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(UpdateDashboardLinksResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardArn").getter(getter(UpdateDashboardLinksResponse::dashboardArn))
            .setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<List<String>> LINK_ENTITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkEntities")
            .getter(getter(UpdateDashboardLinksResponse::linkEntities))
            .setter(setter(Builder::linkEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            STATUS_FIELD, DASHBOARD_ARN_FIELD, LINK_ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestId;

    private final Integer status;

    private final String dashboardArn;

    private final List<String> linkEntities;

    private UpdateDashboardLinksResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.dashboardArn = builder.dashboardArn;
        this.linkEntities = builder.linkEntities;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dashboard.
     */
    public final String dashboardArn() {
        return dashboardArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkEntities() {
        return linkEntities != null && !(linkEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkEntities} method.
     * </p>
     * 
     * @return A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
     */
    public final List<String> linkEntities() {
        return linkEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkEntities() ? linkEntities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardLinksResponse)) {
            return false;
        }
        UpdateDashboardLinksResponse other = (UpdateDashboardLinksResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status())
                && Objects.equals(dashboardArn(), other.dashboardArn()) && hasLinkEntities() == other.hasLinkEntities()
                && Objects.equals(linkEntities(), other.linkEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDashboardLinksResponse").add("RequestId", requestId()).add("Status", status())
                .add("DashboardArn", dashboardArn()).add("LinkEntities", hasLinkEntities() ? linkEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "LinkEntities":
            return Optional.ofNullable(clazz.cast(linkEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("LinkEntities", LINK_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardLinksResponse, T> g) {
        return obj -> g.apply((UpdateDashboardLinksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDashboardLinksResponse> {
        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The Amazon Resource Name (ARN) of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
         * </p>
         * 
         * @param linkEntities
         *        A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkEntities(Collection<String> linkEntities);

        /**
         * <p>
         * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
         * </p>
         * 
         * @param linkEntities
         *        A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkEntities(String... linkEntities);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String requestId;

        private Integer status;

        private String dashboardArn;

        private List<String> linkEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardLinksResponse model) {
            super(model);
            requestId(model.requestId);
            status(model.status);
            dashboardArn(model.dashboardArn);
            linkEntities(model.linkEntities);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final Collection<String> getLinkEntities() {
            if (linkEntities instanceof SdkAutoConstructList) {
                return null;
            }
            return linkEntities;
        }

        public final void setLinkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
        }

        @Override
        public final Builder linkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkEntities(String... linkEntities) {
            linkEntities(Arrays.asList(linkEntities));
            return this;
        }

        @Override
        public UpdateDashboardLinksResponse build() {
            return new UpdateDashboardLinksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
