/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unique values computation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UniqueValuesComputation implements SdkPojo, Serializable,
        ToCopyableBuilder<UniqueValuesComputation.Builder, UniqueValuesComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationId").getter(getter(UniqueValuesComputation::computationId))
            .setter(setter(Builder::computationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UniqueValuesComputation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DimensionField> CATEGORY_FIELD = SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
            .memberName("Category").getter(getter(UniqueValuesComputation::category)).setter(setter(Builder::category))
            .constructor(DimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD,
            NAME_FIELD, CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computationId;

    private final String name;

    private final DimensionField category;

    private UniqueValuesComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.category = builder.category;
    }

    /**
     * <p>
     * The ID for a computation.
     * </p>
     * 
     * @return The ID for a computation.
     */
    public final String computationId() {
        return computationId;
    }

    /**
     * <p>
     * The name of a computation.
     * </p>
     * 
     * @return The name of a computation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The category field that is used in a computation.
     * </p>
     * 
     * @return The category field that is used in a computation.
     */
    public final DimensionField category() {
        return category;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueValuesComputation)) {
            return false;
        }
        UniqueValuesComputation other = (UniqueValuesComputation) obj;
        return Objects.equals(computationId(), other.computationId()) && Objects.equals(name(), other.name())
                && Objects.equals(category(), other.category());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UniqueValuesComputation").add("ComputationId", computationId()).add("Name", name())
                .add("Category", category()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputationId":
            return Optional.ofNullable(clazz.cast(computationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputationId", COMPUTATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Category", CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UniqueValuesComputation, T> g) {
        return obj -> g.apply((UniqueValuesComputation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UniqueValuesComputation> {
        /**
         * <p>
         * The ID for a computation.
         * </p>
         * 
         * @param computationId
         *        The ID for a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationId(String computationId);

        /**
         * <p>
         * The name of a computation.
         * </p>
         * 
         * @param name
         *        The name of a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The category field that is used in a computation.
         * </p>
         * 
         * @param category
         *        The category field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField category);

        /**
         * <p>
         * The category field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionField.Builder} avoiding the need
         * to create one manually via {@link DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #category(DimensionField)}.
         * 
         * @param category
         *        a consumer that will call methods on {@link DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(DimensionField)
         */
        default Builder category(Consumer<DimensionField.Builder> category) {
            return category(DimensionField.builder().applyMutation(category).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String computationId;

        private String name;

        private DimensionField category;

        private BuilderImpl() {
        }

        private BuilderImpl(UniqueValuesComputation model) {
            computationId(model.computationId);
            name(model.name);
            category(model.category);
        }

        public final String getComputationId() {
            return computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getCategory() {
            return category != null ? category.toBuilder() : null;
        }

        public final void setCategory(DimensionField.BuilderImpl category) {
            this.category = category != null ? category.build() : null;
        }

        @Override
        public final Builder category(DimensionField category) {
            this.category = category;
            return this;
        }

        @Override
        public UniqueValuesComputation build() {
            return new UniqueValuesComputation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
