/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the refresh schedule details for a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRefreshScheduleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRefreshScheduleSummary.Builder, TopicRefreshScheduleSummary> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetId").getter(getter(TopicRefreshScheduleSummary::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(TopicRefreshScheduleSummary::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(TopicRefreshScheduleSummary::datasetName))
            .setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<TopicRefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<TopicRefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(TopicRefreshScheduleSummary::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(TopicRefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATASET_ARN_FIELD, DATASET_NAME_FIELD, REFRESH_SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetId;

    private final String datasetArn;

    private final String datasetName;

    private final TopicRefreshSchedule refreshSchedule;

    private TopicRefreshScheduleSummary(BuilderImpl builder) {
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.refreshSchedule = builder.refreshSchedule;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The definition of a refresh schedule.
     * </p>
     * 
     * @return The definition of a refresh schedule.
     */
    public final TopicRefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRefreshScheduleSummary)) {
            return false;
        }
        TopicRefreshScheduleSummary other = (TopicRefreshScheduleSummary) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(refreshSchedule(), other.refreshSchedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRefreshScheduleSummary").add("DatasetId", datasetId()).add("DatasetArn", datasetArn())
                .add("DatasetName", datasetName()).add("RefreshSchedule", refreshSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetId", DATASET_ID_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRefreshScheduleSummary, T> g) {
        return obj -> g.apply((TopicRefreshScheduleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRefreshScheduleSummary> {
        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param datasetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The definition of a refresh schedule.
         * </p>
         * 
         * @param refreshSchedule
         *        The definition of a refresh schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(TopicRefreshSchedule refreshSchedule);

        /**
         * <p>
         * The definition of a refresh schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRefreshSchedule.Builder} avoiding
         * the need to create one manually via {@link TopicRefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRefreshSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #refreshSchedule(TopicRefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link TopicRefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(TopicRefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<TopicRefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(TopicRefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String datasetId;

        private String datasetArn;

        private String datasetName;

        private TopicRefreshSchedule refreshSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRefreshScheduleSummary model) {
            datasetId(model.datasetId);
            datasetArn(model.datasetArn);
            datasetName(model.datasetName);
            refreshSchedule(model.refreshSchedule);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final TopicRefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(TopicRefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(TopicRefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        @Override
        public TopicRefreshScheduleSummary build() {
            return new TopicRefreshScheduleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
