/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a semantic type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemanticType implements SdkPojo, Serializable, ToCopyableBuilder<SemanticType.Builder, SemanticType> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(SemanticType::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> SUB_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubTypeName").getter(getter(SemanticType::subTypeName)).setter(setter(Builder::subTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubTypeName").build()).build();

    private static final SdkField<Map<String, String>> TYPE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TypeParameters")
            .getter(getter(SemanticType::typeParameters))
            .setter(setter(Builder::typeParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRUTHY_CELL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TruthyCellValue").getter(getter(SemanticType::truthyCellValue)).setter(setter(Builder::truthyCellValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruthyCellValue").build()).build();

    private static final SdkField<List<String>> TRUTHY_CELL_VALUE_SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TruthyCellValueSynonyms")
            .getter(getter(SemanticType::truthyCellValueSynonyms))
            .setter(setter(Builder::truthyCellValueSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruthyCellValueSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FALSEY_CELL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FalseyCellValue").getter(getter(SemanticType::falseyCellValue)).setter(setter(Builder::falseyCellValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FalseyCellValue").build()).build();

    private static final SdkField<List<String>> FALSEY_CELL_VALUE_SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FalseyCellValueSynonyms")
            .getter(getter(SemanticType::falseyCellValueSynonyms))
            .setter(setter(Builder::falseyCellValueSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FalseyCellValueSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            SUB_TYPE_NAME_FIELD, TYPE_PARAMETERS_FIELD, TRUTHY_CELL_VALUE_FIELD, TRUTHY_CELL_VALUE_SYNONYMS_FIELD,
            FALSEY_CELL_VALUE_FIELD, FALSEY_CELL_VALUE_SYNONYMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String typeName;

    private final String subTypeName;

    private final Map<String, String> typeParameters;

    private final String truthyCellValue;

    private final List<String> truthyCellValueSynonyms;

    private final String falseyCellValue;

    private final List<String> falseyCellValueSynonyms;

    private SemanticType(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.subTypeName = builder.subTypeName;
        this.typeParameters = builder.typeParameters;
        this.truthyCellValue = builder.truthyCellValue;
        this.truthyCellValueSynonyms = builder.truthyCellValueSynonyms;
        this.falseyCellValue = builder.falseyCellValue;
        this.falseyCellValueSynonyms = builder.falseyCellValueSynonyms;
    }

    /**
     * <p>
     * The semantic type name.
     * </p>
     * 
     * @return The semantic type name.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The semantic type sub type name.
     * </p>
     * 
     * @return The semantic type sub type name.
     */
    public final String subTypeName() {
        return subTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TypeParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTypeParameters() {
        return typeParameters != null && !(typeParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The semantic type parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypeParameters} method.
     * </p>
     * 
     * @return The semantic type parameters.
     */
    public final Map<String, String> typeParameters() {
        return typeParameters;
    }

    /**
     * <p>
     * The semantic type truthy cell value.
     * </p>
     * 
     * @return The semantic type truthy cell value.
     */
    public final String truthyCellValue() {
        return truthyCellValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the TruthyCellValueSynonyms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTruthyCellValueSynonyms() {
        return truthyCellValueSynonyms != null && !(truthyCellValueSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the true cell value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTruthyCellValueSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the true cell value.
     */
    public final List<String> truthyCellValueSynonyms() {
        return truthyCellValueSynonyms;
    }

    /**
     * <p>
     * The semantic type falsey cell value.
     * </p>
     * 
     * @return The semantic type falsey cell value.
     */
    public final String falseyCellValue() {
        return falseyCellValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the FalseyCellValueSynonyms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFalseyCellValueSynonyms() {
        return falseyCellValueSynonyms != null && !(falseyCellValueSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the false cell value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFalseyCellValueSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the false cell value.
     */
    public final List<String> falseyCellValueSynonyms() {
        return falseyCellValueSynonyms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(subTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypeParameters() ? typeParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(truthyCellValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasTruthyCellValueSynonyms() ? truthyCellValueSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(falseyCellValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasFalseyCellValueSynonyms() ? falseyCellValueSynonyms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticType)) {
            return false;
        }
        SemanticType other = (SemanticType) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(subTypeName(), other.subTypeName())
                && hasTypeParameters() == other.hasTypeParameters() && Objects.equals(typeParameters(), other.typeParameters())
                && Objects.equals(truthyCellValue(), other.truthyCellValue())
                && hasTruthyCellValueSynonyms() == other.hasTruthyCellValueSynonyms()
                && Objects.equals(truthyCellValueSynonyms(), other.truthyCellValueSynonyms())
                && Objects.equals(falseyCellValue(), other.falseyCellValue())
                && hasFalseyCellValueSynonyms() == other.hasFalseyCellValueSynonyms()
                && Objects.equals(falseyCellValueSynonyms(), other.falseyCellValueSynonyms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemanticType").add("TypeName", typeName()).add("SubTypeName", subTypeName())
                .add("TypeParameters", hasTypeParameters() ? typeParameters() : null)
                .add("TruthyCellValue", truthyCellValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TruthyCellValueSynonyms", truthyCellValueSynonyms() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FalseyCellValue", falseyCellValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FalseyCellValueSynonyms", falseyCellValueSynonyms() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "SubTypeName":
            return Optional.ofNullable(clazz.cast(subTypeName()));
        case "TypeParameters":
            return Optional.ofNullable(clazz.cast(typeParameters()));
        case "TruthyCellValue":
            return Optional.ofNullable(clazz.cast(truthyCellValue()));
        case "TruthyCellValueSynonyms":
            return Optional.ofNullable(clazz.cast(truthyCellValueSynonyms()));
        case "FalseyCellValue":
            return Optional.ofNullable(clazz.cast(falseyCellValue()));
        case "FalseyCellValueSynonyms":
            return Optional.ofNullable(clazz.cast(falseyCellValueSynonyms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("SubTypeName", SUB_TYPE_NAME_FIELD);
        map.put("TypeParameters", TYPE_PARAMETERS_FIELD);
        map.put("TruthyCellValue", TRUTHY_CELL_VALUE_FIELD);
        map.put("TruthyCellValueSynonyms", TRUTHY_CELL_VALUE_SYNONYMS_FIELD);
        map.put("FalseyCellValue", FALSEY_CELL_VALUE_FIELD);
        map.put("FalseyCellValueSynonyms", FALSEY_CELL_VALUE_SYNONYMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticType, T> g) {
        return obj -> g.apply((SemanticType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemanticType> {
        /**
         * <p>
         * The semantic type name.
         * </p>
         * 
         * @param typeName
         *        The semantic type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The semantic type sub type name.
         * </p>
         * 
         * @param subTypeName
         *        The semantic type sub type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subTypeName(String subTypeName);

        /**
         * <p>
         * The semantic type parameters.
         * </p>
         * 
         * @param typeParameters
         *        The semantic type parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeParameters(Map<String, String> typeParameters);

        /**
         * <p>
         * The semantic type truthy cell value.
         * </p>
         * 
         * @param truthyCellValue
         *        The semantic type truthy cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truthyCellValue(String truthyCellValue);

        /**
         * <p>
         * The other names or aliases for the true cell value.
         * </p>
         * 
         * @param truthyCellValueSynonyms
         *        The other names or aliases for the true cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms);

        /**
         * <p>
         * The other names or aliases for the true cell value.
         * </p>
         * 
         * @param truthyCellValueSynonyms
         *        The other names or aliases for the true cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truthyCellValueSynonyms(String... truthyCellValueSynonyms);

        /**
         * <p>
         * The semantic type falsey cell value.
         * </p>
         * 
         * @param falseyCellValue
         *        The semantic type falsey cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder falseyCellValue(String falseyCellValue);

        /**
         * <p>
         * The other names or aliases for the false cell value.
         * </p>
         * 
         * @param falseyCellValueSynonyms
         *        The other names or aliases for the false cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder falseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms);

        /**
         * <p>
         * The other names or aliases for the false cell value.
         * </p>
         * 
         * @param falseyCellValueSynonyms
         *        The other names or aliases for the false cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder falseyCellValueSynonyms(String... falseyCellValueSynonyms);
    }

    static final class BuilderImpl implements Builder {
        private String typeName;

        private String subTypeName;

        private Map<String, String> typeParameters = DefaultSdkAutoConstructMap.getInstance();

        private String truthyCellValue;

        private List<String> truthyCellValueSynonyms = DefaultSdkAutoConstructList.getInstance();

        private String falseyCellValue;

        private List<String> falseyCellValueSynonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticType model) {
            typeName(model.typeName);
            subTypeName(model.subTypeName);
            typeParameters(model.typeParameters);
            truthyCellValue(model.truthyCellValue);
            truthyCellValueSynonyms(model.truthyCellValueSynonyms);
            falseyCellValue(model.falseyCellValue);
            falseyCellValueSynonyms(model.falseyCellValueSynonyms);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSubTypeName() {
            return subTypeName;
        }

        public final void setSubTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
        }

        @Override
        public final Builder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public final Map<String, String> getTypeParameters() {
            if (typeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return typeParameters;
        }

        public final void setTypeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
        }

        @Override
        public final Builder typeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
            return this;
        }

        public final String getTruthyCellValue() {
            return truthyCellValue;
        }

        public final void setTruthyCellValue(String truthyCellValue) {
            this.truthyCellValue = truthyCellValue;
        }

        @Override
        public final Builder truthyCellValue(String truthyCellValue) {
            this.truthyCellValue = truthyCellValue;
            return this;
        }

        public final Collection<String> getTruthyCellValueSynonyms() {
            if (truthyCellValueSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return truthyCellValueSynonyms;
        }

        public final void setTruthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms) {
            this.truthyCellValueSynonyms = SensitiveStringListCopier.copy(truthyCellValueSynonyms);
        }

        @Override
        public final Builder truthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms) {
            this.truthyCellValueSynonyms = SensitiveStringListCopier.copy(truthyCellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truthyCellValueSynonyms(String... truthyCellValueSynonyms) {
            truthyCellValueSynonyms(Arrays.asList(truthyCellValueSynonyms));
            return this;
        }

        public final String getFalseyCellValue() {
            return falseyCellValue;
        }

        public final void setFalseyCellValue(String falseyCellValue) {
            this.falseyCellValue = falseyCellValue;
        }

        @Override
        public final Builder falseyCellValue(String falseyCellValue) {
            this.falseyCellValue = falseyCellValue;
            return this;
        }

        public final Collection<String> getFalseyCellValueSynonyms() {
            if (falseyCellValueSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return falseyCellValueSynonyms;
        }

        public final void setFalseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms) {
            this.falseyCellValueSynonyms = SensitiveStringListCopier.copy(falseyCellValueSynonyms);
        }

        @Override
        public final Builder falseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms) {
            this.falseyCellValueSynonyms = SensitiveStringListCopier.copy(falseyCellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder falseyCellValueSynonyms(String... falseyCellValueSynonyms) {
            falseyCellValueSynonyms(Arrays.asList(falseyCellValueSynonyms));
            return this;
        }

        @Override
        public SemanticType build() {
            return new SemanticType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
