/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a section-based layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionBasedLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SectionBasedLayoutConfiguration.Builder, SectionBasedLayoutConfiguration> {
    private static final SdkField<List<HeaderFooterSectionConfiguration>> HEADER_SECTIONS_FIELD = SdkField
            .<List<HeaderFooterSectionConfiguration>> builder(MarshallingType.LIST)
            .memberName("HeaderSections")
            .getter(getter(SectionBasedLayoutConfiguration::headerSections))
            .setter(setter(Builder::headerSections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderSections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HeaderFooterSectionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HeaderFooterSectionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BodySectionConfiguration>> BODY_SECTIONS_FIELD = SdkField
            .<List<BodySectionConfiguration>> builder(MarshallingType.LIST)
            .memberName("BodySections")
            .getter(getter(SectionBasedLayoutConfiguration::bodySections))
            .setter(setter(Builder::bodySections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodySections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BodySectionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(BodySectionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HeaderFooterSectionConfiguration>> FOOTER_SECTIONS_FIELD = SdkField
            .<List<HeaderFooterSectionConfiguration>> builder(MarshallingType.LIST)
            .memberName("FooterSections")
            .getter(getter(SectionBasedLayoutConfiguration::footerSections))
            .setter(setter(Builder::footerSections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FooterSections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HeaderFooterSectionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HeaderFooterSectionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SectionBasedLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField
            .<SectionBasedLayoutCanvasSizeOptions> builder(MarshallingType.SDK_POJO).memberName("CanvasSizeOptions")
            .getter(getter(SectionBasedLayoutConfiguration::canvasSizeOptions)).setter(setter(Builder::canvasSizeOptions))
            .constructor(SectionBasedLayoutCanvasSizeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_SECTIONS_FIELD,
            BODY_SECTIONS_FIELD, FOOTER_SECTIONS_FIELD, CANVAS_SIZE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<HeaderFooterSectionConfiguration> headerSections;

    private final List<BodySectionConfiguration> bodySections;

    private final List<HeaderFooterSectionConfiguration> footerSections;

    private final SectionBasedLayoutCanvasSizeOptions canvasSizeOptions;

    private SectionBasedLayoutConfiguration(BuilderImpl builder) {
        this.headerSections = builder.headerSections;
        this.bodySections = builder.bodySections;
        this.footerSections = builder.footerSections;
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeaderSections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeaderSections() {
        return headerSections != null && !(headerSections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of header section configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaderSections} method.
     * </p>
     * 
     * @return A list of header section configurations.
     */
    public final List<HeaderFooterSectionConfiguration> headerSections() {
        return headerSections;
    }

    /**
     * For responses, this returns true if the service returned a value for the BodySections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBodySections() {
        return bodySections != null && !(bodySections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of body section configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBodySections} method.
     * </p>
     * 
     * @return A list of body section configurations.
     */
    public final List<BodySectionConfiguration> bodySections() {
        return bodySections;
    }

    /**
     * For responses, this returns true if the service returned a value for the FooterSections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFooterSections() {
        return footerSections != null && !(footerSections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of footer section configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFooterSections} method.
     * </p>
     * 
     * @return A list of footer section configurations.
     */
    public final List<HeaderFooterSectionConfiguration> footerSections() {
        return footerSections;
    }

    /**
     * <p>
     * The options for the canvas of a section-based layout.
     * </p>
     * 
     * @return The options for the canvas of a section-based layout.
     */
    public final SectionBasedLayoutCanvasSizeOptions canvasSizeOptions() {
        return canvasSizeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderSections() ? headerSections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBodySections() ? bodySections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFooterSections() ? footerSections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(canvasSizeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionBasedLayoutConfiguration)) {
            return false;
        }
        SectionBasedLayoutConfiguration other = (SectionBasedLayoutConfiguration) obj;
        return hasHeaderSections() == other.hasHeaderSections() && Objects.equals(headerSections(), other.headerSections())
                && hasBodySections() == other.hasBodySections() && Objects.equals(bodySections(), other.bodySections())
                && hasFooterSections() == other.hasFooterSections() && Objects.equals(footerSections(), other.footerSections())
                && Objects.equals(canvasSizeOptions(), other.canvasSizeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionBasedLayoutConfiguration")
                .add("HeaderSections", hasHeaderSections() ? headerSections() : null)
                .add("BodySections", hasBodySections() ? bodySections() : null)
                .add("FooterSections", hasFooterSections() ? footerSections() : null)
                .add("CanvasSizeOptions", canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderSections":
            return Optional.ofNullable(clazz.cast(headerSections()));
        case "BodySections":
            return Optional.ofNullable(clazz.cast(bodySections()));
        case "FooterSections":
            return Optional.ofNullable(clazz.cast(footerSections()));
        case "CanvasSizeOptions":
            return Optional.ofNullable(clazz.cast(canvasSizeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HeaderSections", HEADER_SECTIONS_FIELD);
        map.put("BodySections", BODY_SECTIONS_FIELD);
        map.put("FooterSections", FOOTER_SECTIONS_FIELD);
        map.put("CanvasSizeOptions", CANVAS_SIZE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SectionBasedLayoutConfiguration, T> g) {
        return obj -> g.apply((SectionBasedLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionBasedLayoutConfiguration> {
        /**
         * <p>
         * A list of header section configurations.
         * </p>
         * 
         * @param headerSections
         *        A list of header section configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerSections(Collection<HeaderFooterSectionConfiguration> headerSections);

        /**
         * <p>
         * A list of header section configurations.
         * </p>
         * 
         * @param headerSections
         *        A list of header section configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerSections(HeaderFooterSectionConfiguration... headerSections);

        /**
         * <p>
         * A list of header section configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #headerSections(List<HeaderFooterSectionConfiguration>)}.
         * 
         * @param headerSections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerSections(java.util.Collection<HeaderFooterSectionConfiguration>)
         */
        Builder headerSections(Consumer<HeaderFooterSectionConfiguration.Builder>... headerSections);

        /**
         * <p>
         * A list of body section configurations.
         * </p>
         * 
         * @param bodySections
         *        A list of body section configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodySections(Collection<BodySectionConfiguration> bodySections);

        /**
         * <p>
         * A list of body section configurations.
         * </p>
         * 
         * @param bodySections
         *        A list of body section configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodySections(BodySectionConfiguration... bodySections);

        /**
         * <p>
         * A list of body section configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.BodySectionConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.BodySectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.BodySectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #bodySections(List<BodySectionConfiguration>)}.
         * 
         * @param bodySections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.BodySectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bodySections(java.util.Collection<BodySectionConfiguration>)
         */
        Builder bodySections(Consumer<BodySectionConfiguration.Builder>... bodySections);

        /**
         * <p>
         * A list of footer section configurations.
         * </p>
         * 
         * @param footerSections
         *        A list of footer section configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder footerSections(Collection<HeaderFooterSectionConfiguration> footerSections);

        /**
         * <p>
         * A list of footer section configurations.
         * </p>
         * 
         * @param footerSections
         *        A list of footer section configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder footerSections(HeaderFooterSectionConfiguration... footerSections);

        /**
         * <p>
         * A list of footer section configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #footerSections(List<HeaderFooterSectionConfiguration>)}.
         * 
         * @param footerSections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.HeaderFooterSectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #footerSections(java.util.Collection<HeaderFooterSectionConfiguration>)
         */
        Builder footerSections(Consumer<HeaderFooterSectionConfiguration.Builder>... footerSections);

        /**
         * <p>
         * The options for the canvas of a section-based layout.
         * </p>
         * 
         * @param canvasSizeOptions
         *        The options for the canvas of a section-based layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions canvasSizeOptions);

        /**
         * <p>
         * The options for the canvas of a section-based layout.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SectionBasedLayoutCanvasSizeOptions.Builder} avoiding the need to create one manually via
         * {@link SectionBasedLayoutCanvasSizeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionBasedLayoutCanvasSizeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions)}.
         * 
         * @param canvasSizeOptions
         *        a consumer that will call methods on {@link SectionBasedLayoutCanvasSizeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions)
         */
        default Builder canvasSizeOptions(Consumer<SectionBasedLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<HeaderFooterSectionConfiguration> headerSections = DefaultSdkAutoConstructList.getInstance();

        private List<BodySectionConfiguration> bodySections = DefaultSdkAutoConstructList.getInstance();

        private List<HeaderFooterSectionConfiguration> footerSections = DefaultSdkAutoConstructList.getInstance();

        private SectionBasedLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionBasedLayoutConfiguration model) {
            headerSections(model.headerSections);
            bodySections(model.bodySections);
            footerSections(model.footerSections);
            canvasSizeOptions(model.canvasSizeOptions);
        }

        public final List<HeaderFooterSectionConfiguration.Builder> getHeaderSections() {
            List<HeaderFooterSectionConfiguration.Builder> result = HeaderFooterSectionConfigurationListCopier
                    .copyToBuilder(this.headerSections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaderSections(Collection<HeaderFooterSectionConfiguration.BuilderImpl> headerSections) {
            this.headerSections = HeaderFooterSectionConfigurationListCopier.copyFromBuilder(headerSections);
        }

        @Override
        public final Builder headerSections(Collection<HeaderFooterSectionConfiguration> headerSections) {
            this.headerSections = HeaderFooterSectionConfigurationListCopier.copy(headerSections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerSections(HeaderFooterSectionConfiguration... headerSections) {
            headerSections(Arrays.asList(headerSections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerSections(Consumer<HeaderFooterSectionConfiguration.Builder>... headerSections) {
            headerSections(Stream.of(headerSections)
                    .map(c -> HeaderFooterSectionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BodySectionConfiguration.Builder> getBodySections() {
            List<BodySectionConfiguration.Builder> result = BodySectionConfigurationListCopier.copyToBuilder(this.bodySections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBodySections(Collection<BodySectionConfiguration.BuilderImpl> bodySections) {
            this.bodySections = BodySectionConfigurationListCopier.copyFromBuilder(bodySections);
        }

        @Override
        public final Builder bodySections(Collection<BodySectionConfiguration> bodySections) {
            this.bodySections = BodySectionConfigurationListCopier.copy(bodySections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodySections(BodySectionConfiguration... bodySections) {
            bodySections(Arrays.asList(bodySections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodySections(Consumer<BodySectionConfiguration.Builder>... bodySections) {
            bodySections(Stream.of(bodySections).map(c -> BodySectionConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HeaderFooterSectionConfiguration.Builder> getFooterSections() {
            List<HeaderFooterSectionConfiguration.Builder> result = HeaderFooterSectionConfigurationListCopier
                    .copyToBuilder(this.footerSections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFooterSections(Collection<HeaderFooterSectionConfiguration.BuilderImpl> footerSections) {
            this.footerSections = HeaderFooterSectionConfigurationListCopier.copyFromBuilder(footerSections);
        }

        @Override
        public final Builder footerSections(Collection<HeaderFooterSectionConfiguration> footerSections) {
            this.footerSections = HeaderFooterSectionConfigurationListCopier.copy(footerSections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerSections(HeaderFooterSectionConfiguration... footerSections) {
            footerSections(Arrays.asList(footerSections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerSections(Consumer<HeaderFooterSectionConfiguration.Builder>... footerSections) {
            footerSections(Stream.of(footerSections)
                    .map(c -> HeaderFooterSectionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SectionBasedLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return canvasSizeOptions != null ? canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(SectionBasedLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(SectionBasedLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        @Override
        public SectionBasedLayoutConfiguration build() {
            return new SectionBasedLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
