/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a dataset that contains permissions for row-level security (RLS). The permissions dataset maps
 * fields to users or groups. For more information, see <a href=
 * "https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html"
 * >Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User Guide</i>.
 * </p>
 * <p>
 * The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported
 * for new RLS datasets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowLevelPermissionDataSet implements SdkPojo, Serializable,
        ToCopyableBuilder<RowLevelPermissionDataSet.Builder, RowLevelPermissionDataSet> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(RowLevelPermissionDataSet::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RowLevelPermissionDataSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PERMISSION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionPolicy").getter(getter(RowLevelPermissionDataSet::permissionPolicyAsString))
            .setter(setter(Builder::permissionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionPolicy").build()).build();

    private static final SdkField<String> FORMAT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FormatVersion").getter(getter(RowLevelPermissionDataSet::formatVersionAsString))
            .setter(setter(Builder::formatVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RowLevelPermissionDataSet::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, ARN_FIELD,
            PERMISSION_POLICY_FIELD, FORMAT_VERSION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String arn;

    private final String permissionPolicy;

    private final String formatVersion;

    private final String status;

    private RowLevelPermissionDataSet(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.arn = builder.arn;
        this.permissionPolicy = builder.permissionPolicy;
        this.formatVersion = builder.formatVersion;
        this.status = builder.status;
    }

    /**
     * <p>
     * The namespace associated with the dataset that contains permissions for RLS.
     * </p>
     * 
     * @return The namespace associated with the dataset that contains permissions for RLS.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is included
     * for backward compatibility only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionPolicy}
     * will return {@link RowLevelPermissionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionPolicyAsString}.
     * </p>
     * 
     * @return The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is
     *         included for backward compatibility only.
     * @see RowLevelPermissionPolicy
     */
    public final RowLevelPermissionPolicy permissionPolicy() {
        return RowLevelPermissionPolicy.fromValue(permissionPolicy);
    }

    /**
     * <p>
     * The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is included
     * for backward compatibility only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionPolicy}
     * will return {@link RowLevelPermissionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionPolicyAsString}.
     * </p>
     * 
     * @return The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is
     *         included for backward compatibility only.
     * @see RowLevelPermissionPolicy
     */
    public final String permissionPolicyAsString() {
        return permissionPolicy;
    }

    /**
     * <p>
     * The user or group rules associated with the dataset that contains permissions for RLS.
     * </p>
     * <p>
     * By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
     * <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
     * <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are
     * required, and <code>Namespace</code> must not exist.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatVersion}
     * will return {@link RowLevelPermissionFormatVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #formatVersionAsString}.
     * </p>
     * 
     * @return The user or group rules associated with the dataset that contains permissions for RLS.</p>
     *         <p>
     *         By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
     *         <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
     *         <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are
     *         required, and <code>Namespace</code> must not exist.
     * @see RowLevelPermissionFormatVersion
     */
    public final RowLevelPermissionFormatVersion formatVersion() {
        return RowLevelPermissionFormatVersion.fromValue(formatVersion);
    }

    /**
     * <p>
     * The user or group rules associated with the dataset that contains permissions for RLS.
     * </p>
     * <p>
     * By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
     * <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
     * <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are
     * required, and <code>Namespace</code> must not exist.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatVersion}
     * will return {@link RowLevelPermissionFormatVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #formatVersionAsString}.
     * </p>
     * 
     * @return The user or group rules associated with the dataset that contains permissions for RLS.</p>
     *         <p>
     *         By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
     *         <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
     *         <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are
     *         required, and <code>Namespace</code> must not exist.
     * @see RowLevelPermissionFormatVersion
     */
    public final String formatVersionAsString() {
        return formatVersion;
    }

    /**
     * <p>
     * The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If
     * disabled, the status is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>.
     *         If disabled, the status is <code>DISABLED</code>.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If
     * disabled, the status is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>.
     *         If disabled, the status is <code>DISABLED</code>.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionDataSet)) {
            return false;
        }
        RowLevelPermissionDataSet other = (RowLevelPermissionDataSet) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(arn(), other.arn())
                && Objects.equals(permissionPolicyAsString(), other.permissionPolicyAsString())
                && Objects.equals(formatVersionAsString(), other.formatVersionAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowLevelPermissionDataSet").add("Namespace", namespace()).add("Arn", arn())
                .add("PermissionPolicy", permissionPolicyAsString()).add("FormatVersion", formatVersionAsString())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PermissionPolicy":
            return Optional.ofNullable(clazz.cast(permissionPolicyAsString()));
        case "FormatVersion":
            return Optional.ofNullable(clazz.cast(formatVersionAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("PermissionPolicy", PERMISSION_POLICY_FIELD);
        map.put("FormatVersion", FORMAT_VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionDataSet, T> g) {
        return obj -> g.apply((RowLevelPermissionDataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowLevelPermissionDataSet> {
        /**
         * <p>
         * The namespace associated with the dataset that contains permissions for RLS.
         * </p>
         * 
         * @param namespace
         *        The namespace associated with the dataset that contains permissions for RLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is
         * included for backward compatibility only.
         * </p>
         * 
         * @param permissionPolicy
         *        The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is
         *        included for backward compatibility only.
         * @see RowLevelPermissionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionPolicy
         */
        Builder permissionPolicy(String permissionPolicy);

        /**
         * <p>
         * The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is
         * included for backward compatibility only.
         * </p>
         * 
         * @param permissionPolicy
         *        The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is
         *        included for backward compatibility only.
         * @see RowLevelPermissionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionPolicy
         */
        Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy);

        /**
         * <p>
         * The user or group rules associated with the dataset that contains permissions for RLS.
         * </p>
         * <p>
         * By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
         * <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
         * <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are
         * required, and <code>Namespace</code> must not exist.
         * </p>
         * 
         * @param formatVersion
         *        The user or group rules associated with the dataset that contains permissions for RLS.</p>
         *        <p>
         *        By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
         *        <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
         *        <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code>
         *        are required, and <code>Namespace</code> must not exist.
         * @see RowLevelPermissionFormatVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionFormatVersion
         */
        Builder formatVersion(String formatVersion);

        /**
         * <p>
         * The user or group rules associated with the dataset that contains permissions for RLS.
         * </p>
         * <p>
         * By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
         * <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
         * <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are
         * required, and <code>Namespace</code> must not exist.
         * </p>
         * 
         * @param formatVersion
         *        The user or group rules associated with the dataset that contains permissions for RLS.</p>
         *        <p>
         *        By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is
         *        <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When
         *        <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code>
         *        are required, and <code>Namespace</code> must not exist.
         * @see RowLevelPermissionFormatVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionFormatVersion
         */
        Builder formatVersion(RowLevelPermissionFormatVersion formatVersion);

        /**
         * <p>
         * The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If
         * disabled, the status is <code>DISABLED</code>.
         * </p>
         * 
         * @param status
         *        The status of the row-level security permission dataset. If enabled, the status is
         *        <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If
         * disabled, the status is <code>DISABLED</code>.
         * </p>
         * 
         * @param status
         *        The status of the row-level security permission dataset. If enabled, the status is
         *        <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String arn;

        private String permissionPolicy;

        private String formatVersion;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionDataSet model) {
            namespace(model.namespace);
            arn(model.arn);
            permissionPolicy(model.permissionPolicy);
            formatVersion(model.formatVersion);
            status(model.status);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPermissionPolicy() {
            return permissionPolicy;
        }

        public final void setPermissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
        }

        @Override
        public final Builder permissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
            return this;
        }

        @Override
        public final Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy) {
            this.permissionPolicy(permissionPolicy == null ? null : permissionPolicy.toString());
            return this;
        }

        public final String getFormatVersion() {
            return formatVersion;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        @Override
        public final Builder formatVersion(RowLevelPermissionFormatVersion formatVersion) {
            this.formatVersion(formatVersion == null ? null : formatVersion.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RowLevelPermissionDataSet build() {
            return new RowLevelPermissionDataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
