/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label configuration of a reference line.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLineLabelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceLineLabelConfiguration.Builder, ReferenceLineLabelConfiguration> {
    private static final SdkField<ReferenceLineValueLabelConfiguration> VALUE_LABEL_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineValueLabelConfiguration> builder(MarshallingType.SDK_POJO).memberName("ValueLabelConfiguration")
            .getter(getter(ReferenceLineLabelConfiguration::valueLabelConfiguration))
            .setter(setter(Builder::valueLabelConfiguration)).constructor(ReferenceLineValueLabelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelConfiguration").build())
            .build();

    private static final SdkField<ReferenceLineCustomLabelConfiguration> CUSTOM_LABEL_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineCustomLabelConfiguration> builder(MarshallingType.SDK_POJO).memberName("CustomLabelConfiguration")
            .getter(getter(ReferenceLineLabelConfiguration::customLabelConfiguration))
            .setter(setter(Builder::customLabelConfiguration)).constructor(ReferenceLineCustomLabelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabelConfiguration").build())
            .build();

    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("FontConfiguration")
            .getter(getter(ReferenceLineLabelConfiguration::fontConfiguration)).setter(setter(Builder::fontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()).build();

    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontColor").getter(getter(ReferenceLineLabelConfiguration::fontColor))
            .setter(setter(Builder::fontColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontColor").build()).build();

    private static final SdkField<String> HORIZONTAL_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HorizontalPosition").getter(getter(ReferenceLineLabelConfiguration::horizontalPositionAsString))
            .setter(setter(Builder::horizontalPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalPosition").build())
            .build();

    private static final SdkField<String> VERTICAL_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerticalPosition").getter(getter(ReferenceLineLabelConfiguration::verticalPositionAsString))
            .setter(setter(Builder::verticalPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VALUE_LABEL_CONFIGURATION_FIELD, CUSTOM_LABEL_CONFIGURATION_FIELD, FONT_CONFIGURATION_FIELD, FONT_COLOR_FIELD,
            HORIZONTAL_POSITION_FIELD, VERTICAL_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReferenceLineValueLabelConfiguration valueLabelConfiguration;

    private final ReferenceLineCustomLabelConfiguration customLabelConfiguration;

    private final FontConfiguration fontConfiguration;

    private final String fontColor;

    private final String horizontalPosition;

    private final String verticalPosition;

    private ReferenceLineLabelConfiguration(BuilderImpl builder) {
        this.valueLabelConfiguration = builder.valueLabelConfiguration;
        this.customLabelConfiguration = builder.customLabelConfiguration;
        this.fontConfiguration = builder.fontConfiguration;
        this.fontColor = builder.fontColor;
        this.horizontalPosition = builder.horizontalPosition;
        this.verticalPosition = builder.verticalPosition;
    }

    /**
     * <p>
     * The value label configuration of the label in a reference line.
     * </p>
     * 
     * @return The value label configuration of the label in a reference line.
     */
    public final ReferenceLineValueLabelConfiguration valueLabelConfiguration() {
        return valueLabelConfiguration;
    }

    /**
     * <p>
     * The custom label configuration of the label in a reference line.
     * </p>
     * 
     * @return The custom label configuration of the label in a reference line.
     */
    public final ReferenceLineCustomLabelConfiguration customLabelConfiguration() {
        return customLabelConfiguration;
    }

    /**
     * <p>
     * The font configuration of the label in a reference line.
     * </p>
     * 
     * @return The font configuration of the label in a reference line.
     */
    public final FontConfiguration fontConfiguration() {
        return fontConfiguration;
    }

    /**
     * <p>
     * The font color configuration of the label in a reference line.
     * </p>
     * 
     * @return The font color configuration of the label in a reference line.
     */
    public final String fontColor() {
        return fontColor;
    }

    /**
     * <p>
     * The horizontal position configuration of the label in a reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LEFT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CENTER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RIGHT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #horizontalPosition} will return {@link ReferenceLineLabelHorizontalPosition#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #horizontalPositionAsString}.
     * </p>
     * 
     * @return The horizontal position configuration of the label in a reference line. Choose one of the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LEFT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CENTER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RIGHT</code>
     *         </p>
     *         </li>
     * @see ReferenceLineLabelHorizontalPosition
     */
    public final ReferenceLineLabelHorizontalPosition horizontalPosition() {
        return ReferenceLineLabelHorizontalPosition.fromValue(horizontalPosition);
    }

    /**
     * <p>
     * The horizontal position configuration of the label in a reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LEFT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CENTER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RIGHT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #horizontalPosition} will return {@link ReferenceLineLabelHorizontalPosition#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #horizontalPositionAsString}.
     * </p>
     * 
     * @return The horizontal position configuration of the label in a reference line. Choose one of the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LEFT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CENTER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RIGHT</code>
     *         </p>
     *         </li>
     * @see ReferenceLineLabelHorizontalPosition
     */
    public final String horizontalPositionAsString() {
        return horizontalPosition;
    }

    /**
     * <p>
     * The vertical position configuration of the label in a reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ABOVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BELOW</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verticalPosition}
     * will return {@link ReferenceLineLabelVerticalPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #verticalPositionAsString}.
     * </p>
     * 
     * @return The vertical position configuration of the label in a reference line. Choose one of the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ABOVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BELOW</code>
     *         </p>
     *         </li>
     * @see ReferenceLineLabelVerticalPosition
     */
    public final ReferenceLineLabelVerticalPosition verticalPosition() {
        return ReferenceLineLabelVerticalPosition.fromValue(verticalPosition);
    }

    /**
     * <p>
     * The vertical position configuration of the label in a reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ABOVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BELOW</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verticalPosition}
     * will return {@link ReferenceLineLabelVerticalPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #verticalPositionAsString}.
     * </p>
     * 
     * @return The vertical position configuration of the label in a reference line. Choose one of the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ABOVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BELOW</code>
     *         </p>
     *         </li>
     * @see ReferenceLineLabelVerticalPosition
     */
    public final String verticalPositionAsString() {
        return verticalPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueLabelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customLabelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(fontColor());
        hashCode = 31 * hashCode + Objects.hashCode(horizontalPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verticalPositionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineLabelConfiguration)) {
            return false;
        }
        ReferenceLineLabelConfiguration other = (ReferenceLineLabelConfiguration) obj;
        return Objects.equals(valueLabelConfiguration(), other.valueLabelConfiguration())
                && Objects.equals(customLabelConfiguration(), other.customLabelConfiguration())
                && Objects.equals(fontConfiguration(), other.fontConfiguration())
                && Objects.equals(fontColor(), other.fontColor())
                && Objects.equals(horizontalPositionAsString(), other.horizontalPositionAsString())
                && Objects.equals(verticalPositionAsString(), other.verticalPositionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLineLabelConfiguration").add("ValueLabelConfiguration", valueLabelConfiguration())
                .add("CustomLabelConfiguration", customLabelConfiguration()).add("FontConfiguration", fontConfiguration())
                .add("FontColor", fontColor()).add("HorizontalPosition", horizontalPositionAsString())
                .add("VerticalPosition", verticalPositionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueLabelConfiguration":
            return Optional.ofNullable(clazz.cast(valueLabelConfiguration()));
        case "CustomLabelConfiguration":
            return Optional.ofNullable(clazz.cast(customLabelConfiguration()));
        case "FontConfiguration":
            return Optional.ofNullable(clazz.cast(fontConfiguration()));
        case "FontColor":
            return Optional.ofNullable(clazz.cast(fontColor()));
        case "HorizontalPosition":
            return Optional.ofNullable(clazz.cast(horizontalPositionAsString()));
        case "VerticalPosition":
            return Optional.ofNullable(clazz.cast(verticalPositionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValueLabelConfiguration", VALUE_LABEL_CONFIGURATION_FIELD);
        map.put("CustomLabelConfiguration", CUSTOM_LABEL_CONFIGURATION_FIELD);
        map.put("FontConfiguration", FONT_CONFIGURATION_FIELD);
        map.put("FontColor", FONT_COLOR_FIELD);
        map.put("HorizontalPosition", HORIZONTAL_POSITION_FIELD);
        map.put("VerticalPosition", VERTICAL_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineLabelConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineLabelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLineLabelConfiguration> {
        /**
         * <p>
         * The value label configuration of the label in a reference line.
         * </p>
         * 
         * @param valueLabelConfiguration
         *        The value label configuration of the label in a reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueLabelConfiguration(ReferenceLineValueLabelConfiguration valueLabelConfiguration);

        /**
         * <p>
         * The value label configuration of the label in a reference line.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReferenceLineValueLabelConfiguration.Builder} avoiding the need to create one manually via
         * {@link ReferenceLineValueLabelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineValueLabelConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #valueLabelConfiguration(ReferenceLineValueLabelConfiguration)}.
         * 
         * @param valueLabelConfiguration
         *        a consumer that will call methods on {@link ReferenceLineValueLabelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueLabelConfiguration(ReferenceLineValueLabelConfiguration)
         */
        default Builder valueLabelConfiguration(Consumer<ReferenceLineValueLabelConfiguration.Builder> valueLabelConfiguration) {
            return valueLabelConfiguration(ReferenceLineValueLabelConfiguration.builder().applyMutation(valueLabelConfiguration)
                    .build());
        }

        /**
         * <p>
         * The custom label configuration of the label in a reference line.
         * </p>
         * 
         * @param customLabelConfiguration
         *        The custom label configuration of the label in a reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabelConfiguration(ReferenceLineCustomLabelConfiguration customLabelConfiguration);

        /**
         * <p>
         * The custom label configuration of the label in a reference line.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReferenceLineCustomLabelConfiguration.Builder} avoiding the need to create one manually via
         * {@link ReferenceLineCustomLabelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineCustomLabelConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customLabelConfiguration(ReferenceLineCustomLabelConfiguration)}.
         * 
         * @param customLabelConfiguration
         *        a consumer that will call methods on {@link ReferenceLineCustomLabelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLabelConfiguration(ReferenceLineCustomLabelConfiguration)
         */
        default Builder customLabelConfiguration(Consumer<ReferenceLineCustomLabelConfiguration.Builder> customLabelConfiguration) {
            return customLabelConfiguration(ReferenceLineCustomLabelConfiguration.builder()
                    .applyMutation(customLabelConfiguration).build());
        }

        /**
         * <p>
         * The font configuration of the label in a reference line.
         * </p>
         * 
         * @param fontConfiguration
         *        The font configuration of the label in a reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontConfiguration(FontConfiguration fontConfiguration);

        /**
         * <p>
         * The font configuration of the label in a reference line.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #fontConfiguration(FontConfiguration)}.
         * 
         * @param fontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontConfiguration(FontConfiguration)
         */
        default Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return fontConfiguration(FontConfiguration.builder().applyMutation(fontConfiguration).build());
        }

        /**
         * <p>
         * The font color configuration of the label in a reference line.
         * </p>
         * 
         * @param fontColor
         *        The font color configuration of the label in a reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontColor(String fontColor);

        /**
         * <p>
         * The horizontal position configuration of the label in a reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LEFT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CENTER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RIGHT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param horizontalPosition
         *        The horizontal position configuration of the label in a reference line. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LEFT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CENTER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RIGHT</code>
         *        </p>
         *        </li>
         * @see ReferenceLineLabelHorizontalPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceLineLabelHorizontalPosition
         */
        Builder horizontalPosition(String horizontalPosition);

        /**
         * <p>
         * The horizontal position configuration of the label in a reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LEFT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CENTER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RIGHT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param horizontalPosition
         *        The horizontal position configuration of the label in a reference line. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LEFT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CENTER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RIGHT</code>
         *        </p>
         *        </li>
         * @see ReferenceLineLabelHorizontalPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceLineLabelHorizontalPosition
         */
        Builder horizontalPosition(ReferenceLineLabelHorizontalPosition horizontalPosition);

        /**
         * <p>
         * The vertical position configuration of the label in a reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ABOVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BELOW</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param verticalPosition
         *        The vertical position configuration of the label in a reference line. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ABOVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BELOW</code>
         *        </p>
         *        </li>
         * @see ReferenceLineLabelVerticalPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceLineLabelVerticalPosition
         */
        Builder verticalPosition(String verticalPosition);

        /**
         * <p>
         * The vertical position configuration of the label in a reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ABOVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BELOW</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param verticalPosition
         *        The vertical position configuration of the label in a reference line. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ABOVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BELOW</code>
         *        </p>
         *        </li>
         * @see ReferenceLineLabelVerticalPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceLineLabelVerticalPosition
         */
        Builder verticalPosition(ReferenceLineLabelVerticalPosition verticalPosition);
    }

    static final class BuilderImpl implements Builder {
        private ReferenceLineValueLabelConfiguration valueLabelConfiguration;

        private ReferenceLineCustomLabelConfiguration customLabelConfiguration;

        private FontConfiguration fontConfiguration;

        private String fontColor;

        private String horizontalPosition;

        private String verticalPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineLabelConfiguration model) {
            valueLabelConfiguration(model.valueLabelConfiguration);
            customLabelConfiguration(model.customLabelConfiguration);
            fontConfiguration(model.fontConfiguration);
            fontColor(model.fontColor);
            horizontalPosition(model.horizontalPosition);
            verticalPosition(model.verticalPosition);
        }

        public final ReferenceLineValueLabelConfiguration.Builder getValueLabelConfiguration() {
            return valueLabelConfiguration != null ? valueLabelConfiguration.toBuilder() : null;
        }

        public final void setValueLabelConfiguration(ReferenceLineValueLabelConfiguration.BuilderImpl valueLabelConfiguration) {
            this.valueLabelConfiguration = valueLabelConfiguration != null ? valueLabelConfiguration.build() : null;
        }

        @Override
        public final Builder valueLabelConfiguration(ReferenceLineValueLabelConfiguration valueLabelConfiguration) {
            this.valueLabelConfiguration = valueLabelConfiguration;
            return this;
        }

        public final ReferenceLineCustomLabelConfiguration.Builder getCustomLabelConfiguration() {
            return customLabelConfiguration != null ? customLabelConfiguration.toBuilder() : null;
        }

        public final void setCustomLabelConfiguration(ReferenceLineCustomLabelConfiguration.BuilderImpl customLabelConfiguration) {
            this.customLabelConfiguration = customLabelConfiguration != null ? customLabelConfiguration.build() : null;
        }

        @Override
        public final Builder customLabelConfiguration(ReferenceLineCustomLabelConfiguration customLabelConfiguration) {
            this.customLabelConfiguration = customLabelConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return fontConfiguration != null ? fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getFontColor() {
            return fontColor;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        public final String getHorizontalPosition() {
            return horizontalPosition;
        }

        public final void setHorizontalPosition(String horizontalPosition) {
            this.horizontalPosition = horizontalPosition;
        }

        @Override
        public final Builder horizontalPosition(String horizontalPosition) {
            this.horizontalPosition = horizontalPosition;
            return this;
        }

        @Override
        public final Builder horizontalPosition(ReferenceLineLabelHorizontalPosition horizontalPosition) {
            this.horizontalPosition(horizontalPosition == null ? null : horizontalPosition.toString());
            return this;
        }

        public final String getVerticalPosition() {
            return verticalPosition;
        }

        public final void setVerticalPosition(String verticalPosition) {
            this.verticalPosition = verticalPosition;
        }

        @Override
        public final Builder verticalPosition(String verticalPosition) {
            this.verticalPosition = verticalPosition;
            return this;
        }

        @Override
        public final Builder verticalPosition(ReferenceLineLabelVerticalPosition verticalPosition) {
            this.verticalPosition(verticalPosition == null ? null : verticalPosition.toString());
            return this;
        }

        @Override
        public ReferenceLineLabelConfiguration build() {
            return new ReferenceLineLabelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
