/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dynamic configuration of the reference line data configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLineDynamicDataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceLineDynamicDataConfiguration.Builder, ReferenceLineDynamicDataConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(ReferenceLineDynamicDataConfiguration::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<AggregationFunction> MEASURE_AGGREGATION_FUNCTION_FIELD = SdkField
            .<AggregationFunction> builder(MarshallingType.SDK_POJO)
            .memberName("MeasureAggregationFunction")
            .getter(getter(ReferenceLineDynamicDataConfiguration::measureAggregationFunction))
            .setter(setter(Builder::measureAggregationFunction))
            .constructor(AggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureAggregationFunction").build())
            .build();

    private static final SdkField<NumericalAggregationFunction> CALCULATION_FIELD = SdkField
            .<NumericalAggregationFunction> builder(MarshallingType.SDK_POJO).memberName("Calculation")
            .getter(getter(ReferenceLineDynamicDataConfiguration::calculation)).setter(setter(Builder::calculation))
            .constructor(NumericalAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Calculation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD,
            MEASURE_AGGREGATION_FUNCTION_FIELD, CALCULATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final AggregationFunction measureAggregationFunction;

    private final NumericalAggregationFunction calculation;

    private ReferenceLineDynamicDataConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.measureAggregationFunction = builder.measureAggregationFunction;
        this.calculation = builder.calculation;
    }

    /**
     * <p>
     * The column that the dynamic data targets.
     * </p>
     * 
     * @return The column that the dynamic data targets.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The aggregation function that is used in the dynamic data.
     * </p>
     * 
     * @return The aggregation function that is used in the dynamic data.
     */
    public final AggregationFunction measureAggregationFunction() {
        return measureAggregationFunction;
    }

    /**
     * <p>
     * The calculation that is used in the dynamic data.
     * </p>
     * 
     * @return The calculation that is used in the dynamic data.
     */
    public final NumericalAggregationFunction calculation() {
        return calculation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(measureAggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(calculation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineDynamicDataConfiguration)) {
            return false;
        }
        ReferenceLineDynamicDataConfiguration other = (ReferenceLineDynamicDataConfiguration) obj;
        return Objects.equals(column(), other.column())
                && Objects.equals(measureAggregationFunction(), other.measureAggregationFunction())
                && Objects.equals(calculation(), other.calculation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLineDynamicDataConfiguration").add("Column", column())
                .add("MeasureAggregationFunction", measureAggregationFunction()).add("Calculation", calculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "MeasureAggregationFunction":
            return Optional.ofNullable(clazz.cast(measureAggregationFunction()));
        case "Calculation":
            return Optional.ofNullable(clazz.cast(calculation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Column", COLUMN_FIELD);
        map.put("MeasureAggregationFunction", MEASURE_AGGREGATION_FUNCTION_FIELD);
        map.put("Calculation", CALCULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineDynamicDataConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineDynamicDataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLineDynamicDataConfiguration> {
        /**
         * <p>
         * The column that the dynamic data targets.
         * </p>
         * 
         * @param column
         *        The column that the dynamic data targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the dynamic data targets.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The aggregation function that is used in the dynamic data.
         * </p>
         * 
         * @param measureAggregationFunction
         *        The aggregation function that is used in the dynamic data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureAggregationFunction(AggregationFunction measureAggregationFunction);

        /**
         * <p>
         * The aggregation function that is used in the dynamic data.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationFunction.Builder} avoiding the
         * need to create one manually via {@link AggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #measureAggregationFunction(AggregationFunction)}.
         * 
         * @param measureAggregationFunction
         *        a consumer that will call methods on {@link AggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #measureAggregationFunction(AggregationFunction)
         */
        default Builder measureAggregationFunction(Consumer<AggregationFunction.Builder> measureAggregationFunction) {
            return measureAggregationFunction(AggregationFunction.builder().applyMutation(measureAggregationFunction).build());
        }

        /**
         * <p>
         * The calculation that is used in the dynamic data.
         * </p>
         * 
         * @param calculation
         *        The calculation that is used in the dynamic data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculation(NumericalAggregationFunction calculation);

        /**
         * <p>
         * The calculation that is used in the dynamic data.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericalAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link NumericalAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericalAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #calculation(NumericalAggregationFunction)}.
         * 
         * @param calculation
         *        a consumer that will call methods on {@link NumericalAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculation(NumericalAggregationFunction)
         */
        default Builder calculation(Consumer<NumericalAggregationFunction.Builder> calculation) {
            return calculation(NumericalAggregationFunction.builder().applyMutation(calculation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private AggregationFunction measureAggregationFunction;

        private NumericalAggregationFunction calculation;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineDynamicDataConfiguration model) {
            column(model.column);
            measureAggregationFunction(model.measureAggregationFunction);
            calculation(model.calculation);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final AggregationFunction.Builder getMeasureAggregationFunction() {
            return measureAggregationFunction != null ? measureAggregationFunction.toBuilder() : null;
        }

        public final void setMeasureAggregationFunction(AggregationFunction.BuilderImpl measureAggregationFunction) {
            this.measureAggregationFunction = measureAggregationFunction != null ? measureAggregationFunction.build() : null;
        }

        @Override
        public final Builder measureAggregationFunction(AggregationFunction measureAggregationFunction) {
            this.measureAggregationFunction = measureAggregationFunction;
            return this;
        }

        public final NumericalAggregationFunction.Builder getCalculation() {
            return calculation != null ? calculation.toBuilder() : null;
        }

        public final void setCalculation(NumericalAggregationFunction.BuilderImpl calculation) {
            this.calculation = calculation != null ? calculation.build() : null;
        }

        @Override
        public final Builder calculation(NumericalAggregationFunction calculation) {
            this.calculation = calculation;
            return this;
        }

        @Override
        public ReferenceLineDynamicDataConfiguration build() {
            return new ReferenceLineDynamicDataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
