/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of field wells for a plugin visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginVisualFieldWell implements SdkPojo, Serializable,
        ToCopyableBuilder<PluginVisualFieldWell.Builder, PluginVisualFieldWell> {
    private static final SdkField<String> AXIS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AxisName").getter(getter(PluginVisualFieldWell::axisNameAsString)).setter(setter(Builder::axisName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisName").build()).build();

    private static final SdkField<List<DimensionField>> DIMENSIONS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(PluginVisualFieldWell::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> MEASURES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Measures")
            .getter(getter(PluginVisualFieldWell::measures))
            .setter(setter(Builder::measures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Measures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnaggregatedField>> UNAGGREGATED_FIELD = SdkField
            .<List<UnaggregatedField>> builder(MarshallingType.LIST)
            .memberName("Unaggregated")
            .getter(getter(PluginVisualFieldWell::unaggregated))
            .setter(setter(Builder::unaggregated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unaggregated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnaggregatedField> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnaggregatedField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXIS_NAME_FIELD,
            DIMENSIONS_FIELD, MEASURES_FIELD, UNAGGREGATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String axisName;

    private final List<DimensionField> dimensions;

    private final List<MeasureField> measures;

    private final List<UnaggregatedField> unaggregated;

    private PluginVisualFieldWell(BuilderImpl builder) {
        this.axisName = builder.axisName;
        this.dimensions = builder.dimensions;
        this.measures = builder.measures;
        this.unaggregated = builder.unaggregated;
    }

    /**
     * <p>
     * The semantic axis name for the field well.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #axisName} will
     * return {@link PluginVisualAxisName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #axisNameAsString}.
     * </p>
     * 
     * @return The semantic axis name for the field well.
     * @see PluginVisualAxisName
     */
    public final PluginVisualAxisName axisName() {
        return PluginVisualAxisName.fromValue(axisName);
    }

    /**
     * <p>
     * The semantic axis name for the field well.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #axisName} will
     * return {@link PluginVisualAxisName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #axisNameAsString}.
     * </p>
     * 
     * @return The semantic axis name for the field well.
     * @see PluginVisualAxisName
     */
    public final String axisNameAsString() {
        return axisName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dimensions for the field well.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return A list of dimensions for the field well.
     */
    public final List<DimensionField> dimensions() {
        return dimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Measures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMeasures() {
        return measures != null && !(measures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of measures that exist in the field well.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMeasures} method.
     * </p>
     * 
     * @return A list of measures that exist in the field well.
     */
    public final List<MeasureField> measures() {
        return measures;
    }

    /**
     * For responses, this returns true if the service returned a value for the Unaggregated property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnaggregated() {
        return unaggregated != null && !(unaggregated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unaggregated fields that exist in the field well.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnaggregated} method.
     * </p>
     * 
     * @return A list of unaggregated fields that exist in the field well.
     */
    public final List<UnaggregatedField> unaggregated() {
        return unaggregated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(axisNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMeasures() ? measures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnaggregated() ? unaggregated() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualFieldWell)) {
            return false;
        }
        PluginVisualFieldWell other = (PluginVisualFieldWell) obj;
        return Objects.equals(axisNameAsString(), other.axisNameAsString()) && hasDimensions() == other.hasDimensions()
                && Objects.equals(dimensions(), other.dimensions()) && hasMeasures() == other.hasMeasures()
                && Objects.equals(measures(), other.measures()) && hasUnaggregated() == other.hasUnaggregated()
                && Objects.equals(unaggregated(), other.unaggregated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginVisualFieldWell").add("AxisName", axisNameAsString())
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("Measures", hasMeasures() ? measures() : null)
                .add("Unaggregated", hasUnaggregated() ? unaggregated() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AxisName":
            return Optional.ofNullable(clazz.cast(axisNameAsString()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Measures":
            return Optional.ofNullable(clazz.cast(measures()));
        case "Unaggregated":
            return Optional.ofNullable(clazz.cast(unaggregated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AxisName", AXIS_NAME_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Measures", MEASURES_FIELD);
        map.put("Unaggregated", UNAGGREGATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualFieldWell, T> g) {
        return obj -> g.apply((PluginVisualFieldWell) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginVisualFieldWell> {
        /**
         * <p>
         * The semantic axis name for the field well.
         * </p>
         * 
         * @param axisName
         *        The semantic axis name for the field well.
         * @see PluginVisualAxisName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginVisualAxisName
         */
        Builder axisName(String axisName);

        /**
         * <p>
         * The semantic axis name for the field well.
         * </p>
         * 
         * @param axisName
         *        The semantic axis name for the field well.
         * @see PluginVisualAxisName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginVisualAxisName
         */
        Builder axisName(PluginVisualAxisName axisName);

        /**
         * <p>
         * A list of dimensions for the field well.
         * </p>
         * 
         * @param dimensions
         *        A list of dimensions for the field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<DimensionField> dimensions);

        /**
         * <p>
         * A list of dimensions for the field well.
         * </p>
         * 
         * @param dimensions
         *        A list of dimensions for the field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionField... dimensions);

        /**
         * <p>
         * A list of dimensions for the field well.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #dimensions(List<DimensionField>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<DimensionField>)
         */
        Builder dimensions(Consumer<DimensionField.Builder>... dimensions);

        /**
         * <p>
         * A list of measures that exist in the field well.
         * </p>
         * 
         * @param measures
         *        A list of measures that exist in the field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measures(Collection<MeasureField> measures);

        /**
         * <p>
         * A list of measures that exist in the field well.
         * </p>
         * 
         * @param measures
         *        A list of measures that exist in the field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measures(MeasureField... measures);

        /**
         * <p>
         * A list of measures that exist in the field well.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #measures(List<MeasureField>)}.
         * 
         * @param measures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #measures(java.util.Collection<MeasureField>)
         */
        Builder measures(Consumer<MeasureField.Builder>... measures);

        /**
         * <p>
         * A list of unaggregated fields that exist in the field well.
         * </p>
         * 
         * @param unaggregated
         *        A list of unaggregated fields that exist in the field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unaggregated(Collection<UnaggregatedField> unaggregated);

        /**
         * <p>
         * A list of unaggregated fields that exist in the field well.
         * </p>
         * 
         * @param unaggregated
         *        A list of unaggregated fields that exist in the field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unaggregated(UnaggregatedField... unaggregated);

        /**
         * <p>
         * A list of unaggregated fields that exist in the field well.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.UnaggregatedField.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.UnaggregatedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.UnaggregatedField.Builder#build()} is called
         * immediately and its result is passed to {@link #unaggregated(List<UnaggregatedField>)}.
         * 
         * @param unaggregated
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.UnaggregatedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unaggregated(java.util.Collection<UnaggregatedField>)
         */
        Builder unaggregated(Consumer<UnaggregatedField.Builder>... unaggregated);
    }

    static final class BuilderImpl implements Builder {
        private String axisName;

        private List<DimensionField> dimensions = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> measures = DefaultSdkAutoConstructList.getInstance();

        private List<UnaggregatedField> unaggregated = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualFieldWell model) {
            axisName(model.axisName);
            dimensions(model.dimensions);
            measures(model.measures);
            unaggregated(model.unaggregated);
        }

        public final String getAxisName() {
            return axisName;
        }

        public final void setAxisName(String axisName) {
            this.axisName = axisName;
        }

        @Override
        public final Builder axisName(String axisName) {
            this.axisName = axisName;
            return this;
        }

        @Override
        public final Builder axisName(PluginVisualAxisName axisName) {
            this.axisName(axisName == null ? null : axisName.toString());
            return this;
        }

        public final List<DimensionField.Builder> getDimensions() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<DimensionField.BuilderImpl> dimensions) {
            this.dimensions = DimensionFieldListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<DimensionField> dimensions) {
            this.dimensions = DimensionFieldListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(DimensionField... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<DimensionField.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> DimensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getMeasures() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.measures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMeasures(Collection<MeasureField.BuilderImpl> measures) {
            this.measures = MeasureFieldListCopier.copyFromBuilder(measures);
        }

        @Override
        public final Builder measures(Collection<MeasureField> measures) {
            this.measures = MeasureFieldListCopier.copy(measures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder measures(MeasureField... measures) {
            measures(Arrays.asList(measures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder measures(Consumer<MeasureField.Builder>... measures) {
            measures(Stream.of(measures).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnaggregatedField.Builder> getUnaggregated() {
            List<UnaggregatedField.Builder> result = UnaggregatedFieldListCopier.copyToBuilder(this.unaggregated);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnaggregated(Collection<UnaggregatedField.BuilderImpl> unaggregated) {
            this.unaggregated = UnaggregatedFieldListCopier.copyFromBuilder(unaggregated);
        }

        @Override
        public final Builder unaggregated(Collection<UnaggregatedField> unaggregated) {
            this.unaggregated = UnaggregatedFieldListCopier.copy(unaggregated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unaggregated(UnaggregatedField... unaggregated) {
            unaggregated(Arrays.asList(unaggregated));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unaggregated(Consumer<UnaggregatedField.Builder>... unaggregated) {
            unaggregated(Stream.of(unaggregated).map(c -> UnaggregatedField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PluginVisualFieldWell build() {
            return new PluginVisualFieldWell(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
