/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The paginated report options for a pivot table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTablePaginatedReportOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTablePaginatedReportOptions.Builder, PivotTablePaginatedReportOptions> {
    private static final SdkField<String> VERTICAL_OVERFLOW_VISIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerticalOverflowVisibility")
            .getter(getter(PivotTablePaginatedReportOptions::verticalOverflowVisibilityAsString))
            .setter(setter(Builder::verticalOverflowVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalOverflowVisibility").build())
            .build();

    private static final SdkField<String> OVERFLOW_COLUMN_HEADER_VISIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OverflowColumnHeaderVisibility")
            .getter(getter(PivotTablePaginatedReportOptions::overflowColumnHeaderVisibilityAsString))
            .setter(setter(Builder::overflowColumnHeaderVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverflowColumnHeaderVisibility")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERTICAL_OVERFLOW_VISIBILITY_FIELD, OVERFLOW_COLUMN_HEADER_VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verticalOverflowVisibility;

    private final String overflowColumnHeaderVisibility;

    private PivotTablePaginatedReportOptions(BuilderImpl builder) {
        this.verticalOverflowVisibility = builder.verticalOverflowVisibility;
        this.overflowColumnHeaderVisibility = builder.overflowColumnHeaderVisibility;
    }

    /**
     * <p>
     * The visibility of the printing table overflow across pages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verticalOverflowVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verticalOverflowVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the printing table overflow across pages.
     * @see Visibility
     */
    public final Visibility verticalOverflowVisibility() {
        return Visibility.fromValue(verticalOverflowVisibility);
    }

    /**
     * <p>
     * The visibility of the printing table overflow across pages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verticalOverflowVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verticalOverflowVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the printing table overflow across pages.
     * @see Visibility
     */
    public final String verticalOverflowVisibilityAsString() {
        return verticalOverflowVisibility;
    }

    /**
     * <p>
     * The visibility of the repeating header rows on each page.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overflowColumnHeaderVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #overflowColumnHeaderVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the repeating header rows on each page.
     * @see Visibility
     */
    public final Visibility overflowColumnHeaderVisibility() {
        return Visibility.fromValue(overflowColumnHeaderVisibility);
    }

    /**
     * <p>
     * The visibility of the repeating header rows on each page.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overflowColumnHeaderVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #overflowColumnHeaderVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the repeating header rows on each page.
     * @see Visibility
     */
    public final String overflowColumnHeaderVisibilityAsString() {
        return overflowColumnHeaderVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verticalOverflowVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(overflowColumnHeaderVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTablePaginatedReportOptions)) {
            return false;
        }
        PivotTablePaginatedReportOptions other = (PivotTablePaginatedReportOptions) obj;
        return Objects.equals(verticalOverflowVisibilityAsString(), other.verticalOverflowVisibilityAsString())
                && Objects.equals(overflowColumnHeaderVisibilityAsString(), other.overflowColumnHeaderVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTablePaginatedReportOptions")
                .add("VerticalOverflowVisibility", verticalOverflowVisibilityAsString())
                .add("OverflowColumnHeaderVisibility", overflowColumnHeaderVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerticalOverflowVisibility":
            return Optional.ofNullable(clazz.cast(verticalOverflowVisibilityAsString()));
        case "OverflowColumnHeaderVisibility":
            return Optional.ofNullable(clazz.cast(overflowColumnHeaderVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerticalOverflowVisibility", VERTICAL_OVERFLOW_VISIBILITY_FIELD);
        map.put("OverflowColumnHeaderVisibility", OVERFLOW_COLUMN_HEADER_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTablePaginatedReportOptions, T> g) {
        return obj -> g.apply((PivotTablePaginatedReportOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTablePaginatedReportOptions> {
        /**
         * <p>
         * The visibility of the printing table overflow across pages.
         * </p>
         * 
         * @param verticalOverflowVisibility
         *        The visibility of the printing table overflow across pages.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder verticalOverflowVisibility(String verticalOverflowVisibility);

        /**
         * <p>
         * The visibility of the printing table overflow across pages.
         * </p>
         * 
         * @param verticalOverflowVisibility
         *        The visibility of the printing table overflow across pages.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder verticalOverflowVisibility(Visibility verticalOverflowVisibility);

        /**
         * <p>
         * The visibility of the repeating header rows on each page.
         * </p>
         * 
         * @param overflowColumnHeaderVisibility
         *        The visibility of the repeating header rows on each page.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder overflowColumnHeaderVisibility(String overflowColumnHeaderVisibility);

        /**
         * <p>
         * The visibility of the repeating header rows on each page.
         * </p>
         * 
         * @param overflowColumnHeaderVisibility
         *        The visibility of the repeating header rows on each page.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder overflowColumnHeaderVisibility(Visibility overflowColumnHeaderVisibility);
    }

    static final class BuilderImpl implements Builder {
        private String verticalOverflowVisibility;

        private String overflowColumnHeaderVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTablePaginatedReportOptions model) {
            verticalOverflowVisibility(model.verticalOverflowVisibility);
            overflowColumnHeaderVisibility(model.overflowColumnHeaderVisibility);
        }

        public final String getVerticalOverflowVisibility() {
            return verticalOverflowVisibility;
        }

        public final void setVerticalOverflowVisibility(String verticalOverflowVisibility) {
            this.verticalOverflowVisibility = verticalOverflowVisibility;
        }

        @Override
        public final Builder verticalOverflowVisibility(String verticalOverflowVisibility) {
            this.verticalOverflowVisibility = verticalOverflowVisibility;
            return this;
        }

        @Override
        public final Builder verticalOverflowVisibility(Visibility verticalOverflowVisibility) {
            this.verticalOverflowVisibility(verticalOverflowVisibility == null ? null : verticalOverflowVisibility.toString());
            return this;
        }

        public final String getOverflowColumnHeaderVisibility() {
            return overflowColumnHeaderVisibility;
        }

        public final void setOverflowColumnHeaderVisibility(String overflowColumnHeaderVisibility) {
            this.overflowColumnHeaderVisibility = overflowColumnHeaderVisibility;
        }

        @Override
        public final Builder overflowColumnHeaderVisibility(String overflowColumnHeaderVisibility) {
            this.overflowColumnHeaderVisibility = overflowColumnHeaderVisibility;
            return this;
        }

        @Override
        public final Builder overflowColumnHeaderVisibility(Visibility overflowColumnHeaderVisibility) {
            this.overflowColumnHeaderVisibility(overflowColumnHeaderVisibility == null ? null : overflowColumnHeaderVisibility
                    .toString());
            return this;
        }

        @Override
        public PivotTablePaginatedReportOptions build() {
            return new PivotTablePaginatedReportOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
