/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information needed to create a data source connection that uses OAuth client credentials.
 * This option is available for data source connections that are made with Snowflake and Starburst.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuthParameters implements SdkPojo, Serializable, ToCopyableBuilder<OAuthParameters.Builder, OAuthParameters> {
    private static final SdkField<String> TOKEN_PROVIDER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenProviderUrl").getter(getter(OAuthParameters::tokenProviderUrl))
            .setter(setter(Builder::tokenProviderUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProviderUrl").build()).build();

    private static final SdkField<String> O_AUTH_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OAuthScope").getter(getter(OAuthParameters::oAuthScope)).setter(setter(Builder::oAuthScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthScope").build()).build();

    private static final SdkField<VpcConnectionProperties> IDENTITY_PROVIDER_VPC_CONNECTION_PROPERTIES_FIELD = SdkField
            .<VpcConnectionProperties> builder(MarshallingType.SDK_POJO)
            .memberName("IdentityProviderVpcConnectionProperties")
            .getter(getter(OAuthParameters::identityProviderVpcConnectionProperties))
            .setter(setter(Builder::identityProviderVpcConnectionProperties))
            .constructor(VpcConnectionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("IdentityProviderVpcConnectionProperties").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_RESOURCE_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderResourceUri")
            .getter(getter(OAuthParameters::identityProviderResourceUri))
            .setter(setter(Builder::identityProviderResourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderResourceUri")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_PROVIDER_URL_FIELD,
            O_AUTH_SCOPE_FIELD, IDENTITY_PROVIDER_VPC_CONNECTION_PROPERTIES_FIELD, IDENTITY_PROVIDER_RESOURCE_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tokenProviderUrl;

    private final String oAuthScope;

    private final VpcConnectionProperties identityProviderVpcConnectionProperties;

    private final String identityProviderResourceUri;

    private OAuthParameters(BuilderImpl builder) {
        this.tokenProviderUrl = builder.tokenProviderUrl;
        this.oAuthScope = builder.oAuthScope;
        this.identityProviderVpcConnectionProperties = builder.identityProviderVpcConnectionProperties;
        this.identityProviderResourceUri = builder.identityProviderResourceUri;
    }

    /**
     * <p>
     * The token endpoint URL of the identity provider.
     * </p>
     * 
     * @return The token endpoint URL of the identity provider.
     */
    public final String tokenProviderUrl() {
        return tokenProviderUrl;
    }

    /**
     * <p>
     * The OAuth scope.
     * </p>
     * 
     * @return The OAuth scope.
     */
    public final String oAuthScope() {
        return oAuthScope;
    }

    /**
     * Returns the value of the IdentityProviderVpcConnectionProperties property for this object.
     * 
     * @return The value of the IdentityProviderVpcConnectionProperties property for this object.
     */
    public final VpcConnectionProperties identityProviderVpcConnectionProperties() {
        return identityProviderVpcConnectionProperties;
    }

    /**
     * <p>
     * The resource uri of the identity provider.
     * </p>
     * 
     * @return The resource uri of the identity provider.
     */
    public final String identityProviderResourceUri() {
        return identityProviderResourceUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tokenProviderUrl());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthScope());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderVpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderResourceUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthParameters)) {
            return false;
        }
        OAuthParameters other = (OAuthParameters) obj;
        return Objects.equals(tokenProviderUrl(), other.tokenProviderUrl()) && Objects.equals(oAuthScope(), other.oAuthScope())
                && Objects.equals(identityProviderVpcConnectionProperties(), other.identityProviderVpcConnectionProperties())
                && Objects.equals(identityProviderResourceUri(), other.identityProviderResourceUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuthParameters").add("TokenProviderUrl", tokenProviderUrl()).add("OAuthScope", oAuthScope())
                .add("IdentityProviderVpcConnectionProperties", identityProviderVpcConnectionProperties())
                .add("IdentityProviderResourceUri", identityProviderResourceUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TokenProviderUrl":
            return Optional.ofNullable(clazz.cast(tokenProviderUrl()));
        case "OAuthScope":
            return Optional.ofNullable(clazz.cast(oAuthScope()));
        case "IdentityProviderVpcConnectionProperties":
            return Optional.ofNullable(clazz.cast(identityProviderVpcConnectionProperties()));
        case "IdentityProviderResourceUri":
            return Optional.ofNullable(clazz.cast(identityProviderResourceUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TokenProviderUrl", TOKEN_PROVIDER_URL_FIELD);
        map.put("OAuthScope", O_AUTH_SCOPE_FIELD);
        map.put("IdentityProviderVpcConnectionProperties", IDENTITY_PROVIDER_VPC_CONNECTION_PROPERTIES_FIELD);
        map.put("IdentityProviderResourceUri", IDENTITY_PROVIDER_RESOURCE_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthParameters, T> g) {
        return obj -> g.apply((OAuthParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuthParameters> {
        /**
         * <p>
         * The token endpoint URL of the identity provider.
         * </p>
         * 
         * @param tokenProviderUrl
         *        The token endpoint URL of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProviderUrl(String tokenProviderUrl);

        /**
         * <p>
         * The OAuth scope.
         * </p>
         * 
         * @param oAuthScope
         *        The OAuth scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScope(String oAuthScope);

        /**
         * Sets the value of the IdentityProviderVpcConnectionProperties property for this object.
         *
         * @param identityProviderVpcConnectionProperties
         *        The new value for the IdentityProviderVpcConnectionProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderVpcConnectionProperties(VpcConnectionProperties identityProviderVpcConnectionProperties);

        /**
         * Sets the value of the IdentityProviderVpcConnectionProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConnectionProperties.Builder} avoiding
         * the need to create one manually via {@link VpcConnectionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #identityProviderVpcConnectionProperties(VpcConnectionProperties)}.
         * 
         * @param identityProviderVpcConnectionProperties
         *        a consumer that will call methods on {@link VpcConnectionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderVpcConnectionProperties(VpcConnectionProperties)
         */
        default Builder identityProviderVpcConnectionProperties(
                Consumer<VpcConnectionProperties.Builder> identityProviderVpcConnectionProperties) {
            return identityProviderVpcConnectionProperties(VpcConnectionProperties.builder()
                    .applyMutation(identityProviderVpcConnectionProperties).build());
        }

        /**
         * <p>
         * The resource uri of the identity provider.
         * </p>
         * 
         * @param identityProviderResourceUri
         *        The resource uri of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderResourceUri(String identityProviderResourceUri);
    }

    static final class BuilderImpl implements Builder {
        private String tokenProviderUrl;

        private String oAuthScope;

        private VpcConnectionProperties identityProviderVpcConnectionProperties;

        private String identityProviderResourceUri;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthParameters model) {
            tokenProviderUrl(model.tokenProviderUrl);
            oAuthScope(model.oAuthScope);
            identityProviderVpcConnectionProperties(model.identityProviderVpcConnectionProperties);
            identityProviderResourceUri(model.identityProviderResourceUri);
        }

        public final String getTokenProviderUrl() {
            return tokenProviderUrl;
        }

        public final void setTokenProviderUrl(String tokenProviderUrl) {
            this.tokenProviderUrl = tokenProviderUrl;
        }

        @Override
        public final Builder tokenProviderUrl(String tokenProviderUrl) {
            this.tokenProviderUrl = tokenProviderUrl;
            return this;
        }

        public final String getOAuthScope() {
            return oAuthScope;
        }

        public final void setOAuthScope(String oAuthScope) {
            this.oAuthScope = oAuthScope;
        }

        @Override
        public final Builder oAuthScope(String oAuthScope) {
            this.oAuthScope = oAuthScope;
            return this;
        }

        public final VpcConnectionProperties.Builder getIdentityProviderVpcConnectionProperties() {
            return identityProviderVpcConnectionProperties != null ? identityProviderVpcConnectionProperties.toBuilder() : null;
        }

        public final void setIdentityProviderVpcConnectionProperties(
                VpcConnectionProperties.BuilderImpl identityProviderVpcConnectionProperties) {
            this.identityProviderVpcConnectionProperties = identityProviderVpcConnectionProperties != null ? identityProviderVpcConnectionProperties
                    .build() : null;
        }

        @Override
        public final Builder identityProviderVpcConnectionProperties(
                VpcConnectionProperties identityProviderVpcConnectionProperties) {
            this.identityProviderVpcConnectionProperties = identityProviderVpcConnectionProperties;
            return this;
        }

        public final String getIdentityProviderResourceUri() {
            return identityProviderResourceUri;
        }

        public final void setIdentityProviderResourceUri(String identityProviderResourceUri) {
            this.identityProviderResourceUri = identityProviderResourceUri;
        }

        @Override
        public final Builder identityProviderResourceUri(String identityProviderResourceUri) {
            this.identityProviderResourceUri = identityProviderResourceUri;
            return this;
        }

        @Override
        public OAuthParameters build() {
            return new OAuthParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
