/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The image set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSet implements SdkPojo, Serializable, ToCopyableBuilder<ImageSet.Builder, ImageSet> {
    private static final SdkField<Image> ORIGINAL_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .memberName("Original").getter(getter(ImageSet::original)).setter(setter(Builder::original))
            .constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Original").build()).build();

    private static final SdkField<Image> HEIGHT64_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .memberName("Height64").getter(getter(ImageSet::height64)).setter(setter(Builder::height64))
            .constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height64").build()).build();

    private static final SdkField<Image> HEIGHT32_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .memberName("Height32").getter(getter(ImageSet::height32)).setter(setter(Builder::height32))
            .constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height32").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_FIELD,
            HEIGHT64_FIELD, HEIGHT32_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Image original;

    private final Image height64;

    private final Image height32;

    private ImageSet(BuilderImpl builder) {
        this.original = builder.original;
        this.height64 = builder.height64;
        this.height32 = builder.height32;
    }

    /**
     * <p>
     * The original image.
     * </p>
     * 
     * @return The original image.
     */
    public final Image original() {
        return original;
    }

    /**
     * <p>
     * The image with the height set to 64 pixels.
     * </p>
     * 
     * @return The image with the height set to 64 pixels.
     */
    public final Image height64() {
        return height64;
    }

    /**
     * <p>
     * The image with the height set to 32 pixels.
     * </p>
     * 
     * @return The image with the height set to 32 pixels.
     */
    public final Image height32() {
        return height32;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(original());
        hashCode = 31 * hashCode + Objects.hashCode(height64());
        hashCode = 31 * hashCode + Objects.hashCode(height32());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSet)) {
            return false;
        }
        ImageSet other = (ImageSet) obj;
        return Objects.equals(original(), other.original()) && Objects.equals(height64(), other.height64())
                && Objects.equals(height32(), other.height32());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSet").add("Original", original()).add("Height64", height64()).add("Height32", height32())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Original":
            return Optional.ofNullable(clazz.cast(original()));
        case "Height64":
            return Optional.ofNullable(clazz.cast(height64()));
        case "Height32":
            return Optional.ofNullable(clazz.cast(height32()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Original", ORIGINAL_FIELD);
        map.put("Height64", HEIGHT64_FIELD);
        map.put("Height32", HEIGHT32_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSet, T> g) {
        return obj -> g.apply((ImageSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSet> {
        /**
         * <p>
         * The original image.
         * </p>
         * 
         * @param original
         *        The original image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder original(Image original);

        /**
         * <p>
         * The original image.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #original(Image)}.
         * 
         * @param original
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #original(Image)
         */
        default Builder original(Consumer<Image.Builder> original) {
            return original(Image.builder().applyMutation(original).build());
        }

        /**
         * <p>
         * The image with the height set to 64 pixels.
         * </p>
         * 
         * @param height64
         *        The image with the height set to 64 pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height64(Image height64);

        /**
         * <p>
         * The image with the height set to 64 pixels.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #height64(Image)}.
         * 
         * @param height64
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #height64(Image)
         */
        default Builder height64(Consumer<Image.Builder> height64) {
            return height64(Image.builder().applyMutation(height64).build());
        }

        /**
         * <p>
         * The image with the height set to 32 pixels.
         * </p>
         * 
         * @param height32
         *        The image with the height set to 32 pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height32(Image height32);

        /**
         * <p>
         * The image with the height set to 32 pixels.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #height32(Image)}.
         * 
         * @param height32
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #height32(Image)
         */
        default Builder height32(Consumer<Image.Builder> height32) {
            return height32(Image.builder().applyMutation(height32).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Image original;

        private Image height64;

        private Image height32;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSet model) {
            original(model.original);
            height64(model.height64);
            height32(model.height32);
        }

        public final Image.Builder getOriginal() {
            return original != null ? original.toBuilder() : null;
        }

        public final void setOriginal(Image.BuilderImpl original) {
            this.original = original != null ? original.build() : null;
        }

        @Override
        public final Builder original(Image original) {
            this.original = original;
            return this;
        }

        public final Image.Builder getHeight64() {
            return height64 != null ? height64.toBuilder() : null;
        }

        public final void setHeight64(Image.BuilderImpl height64) {
            this.height64 = height64 != null ? height64.build() : null;
        }

        @Override
        public final Builder height64(Image height64) {
            this.height64 = height64;
            return this;
        }

        public final Image.Builder getHeight32() {
            return height32 != null ? height32.toBuilder() : null;
        }

        public final void setHeight32(Image.BuilderImpl height32) {
            this.height32 = height32 != null ? height32.build() : null;
        }

        @Override
        public final Builder height32(Image height32) {
            this.height32 = height32;
            return this;
        }

        @Override
        public ImageSet build() {
            return new ImageSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
