/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition properties for a geospatial layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLayerDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLayerDefinition.Builder, GeospatialLayerDefinition> {
    private static final SdkField<GeospatialPointLayer> POINT_LAYER_FIELD = SdkField
            .<GeospatialPointLayer> builder(MarshallingType.SDK_POJO).memberName("PointLayer")
            .getter(getter(GeospatialLayerDefinition::pointLayer)).setter(setter(Builder::pointLayer))
            .constructor(GeospatialPointLayer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointLayer").build()).build();

    private static final SdkField<GeospatialLineLayer> LINE_LAYER_FIELD = SdkField
            .<GeospatialLineLayer> builder(MarshallingType.SDK_POJO).memberName("LineLayer")
            .getter(getter(GeospatialLayerDefinition::lineLayer)).setter(setter(Builder::lineLayer))
            .constructor(GeospatialLineLayer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineLayer").build()).build();

    private static final SdkField<GeospatialPolygonLayer> POLYGON_LAYER_FIELD = SdkField
            .<GeospatialPolygonLayer> builder(MarshallingType.SDK_POJO).memberName("PolygonLayer")
            .getter(getter(GeospatialLayerDefinition::polygonLayer)).setter(setter(Builder::polygonLayer))
            .constructor(GeospatialPolygonLayer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolygonLayer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POINT_LAYER_FIELD,
            LINE_LAYER_FIELD, POLYGON_LAYER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialPointLayer pointLayer;

    private final GeospatialLineLayer lineLayer;

    private final GeospatialPolygonLayer polygonLayer;

    private GeospatialLayerDefinition(BuilderImpl builder) {
        this.pointLayer = builder.pointLayer;
        this.lineLayer = builder.lineLayer;
        this.polygonLayer = builder.polygonLayer;
    }

    /**
     * <p>
     * The definition for a point layer.
     * </p>
     * 
     * @return The definition for a point layer.
     */
    public final GeospatialPointLayer pointLayer() {
        return pointLayer;
    }

    /**
     * <p>
     * The definition for a line layer.
     * </p>
     * 
     * @return The definition for a line layer.
     */
    public final GeospatialLineLayer lineLayer() {
        return lineLayer;
    }

    /**
     * <p>
     * The definition for a polygon layer.
     * </p>
     * 
     * @return The definition for a polygon layer.
     */
    public final GeospatialPolygonLayer polygonLayer() {
        return polygonLayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pointLayer());
        hashCode = 31 * hashCode + Objects.hashCode(lineLayer());
        hashCode = 31 * hashCode + Objects.hashCode(polygonLayer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerDefinition)) {
            return false;
        }
        GeospatialLayerDefinition other = (GeospatialLayerDefinition) obj;
        return Objects.equals(pointLayer(), other.pointLayer()) && Objects.equals(lineLayer(), other.lineLayer())
                && Objects.equals(polygonLayer(), other.polygonLayer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLayerDefinition").add("PointLayer", pointLayer()).add("LineLayer", lineLayer())
                .add("PolygonLayer", polygonLayer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PointLayer":
            return Optional.ofNullable(clazz.cast(pointLayer()));
        case "LineLayer":
            return Optional.ofNullable(clazz.cast(lineLayer()));
        case "PolygonLayer":
            return Optional.ofNullable(clazz.cast(polygonLayer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PointLayer", POINT_LAYER_FIELD);
        map.put("LineLayer", LINE_LAYER_FIELD);
        map.put("PolygonLayer", POLYGON_LAYER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerDefinition, T> g) {
        return obj -> g.apply((GeospatialLayerDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLayerDefinition> {
        /**
         * <p>
         * The definition for a point layer.
         * </p>
         * 
         * @param pointLayer
         *        The definition for a point layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointLayer(GeospatialPointLayer pointLayer);

        /**
         * <p>
         * The definition for a point layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialPointLayer.Builder} avoiding
         * the need to create one manually via {@link GeospatialPointLayer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialPointLayer.Builder#build()} is called immediately and
         * its result is passed to {@link #pointLayer(GeospatialPointLayer)}.
         * 
         * @param pointLayer
         *        a consumer that will call methods on {@link GeospatialPointLayer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointLayer(GeospatialPointLayer)
         */
        default Builder pointLayer(Consumer<GeospatialPointLayer.Builder> pointLayer) {
            return pointLayer(GeospatialPointLayer.builder().applyMutation(pointLayer).build());
        }

        /**
         * <p>
         * The definition for a line layer.
         * </p>
         * 
         * @param lineLayer
         *        The definition for a line layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineLayer(GeospatialLineLayer lineLayer);

        /**
         * <p>
         * The definition for a line layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLineLayer.Builder} avoiding the
         * need to create one manually via {@link GeospatialLineLayer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLineLayer.Builder#build()} is called immediately and
         * its result is passed to {@link #lineLayer(GeospatialLineLayer)}.
         * 
         * @param lineLayer
         *        a consumer that will call methods on {@link GeospatialLineLayer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineLayer(GeospatialLineLayer)
         */
        default Builder lineLayer(Consumer<GeospatialLineLayer.Builder> lineLayer) {
            return lineLayer(GeospatialLineLayer.builder().applyMutation(lineLayer).build());
        }

        /**
         * <p>
         * The definition for a polygon layer.
         * </p>
         * 
         * @param polygonLayer
         *        The definition for a polygon layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygonLayer(GeospatialPolygonLayer polygonLayer);

        /**
         * <p>
         * The definition for a polygon layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialPolygonLayer.Builder} avoiding
         * the need to create one manually via {@link GeospatialPolygonLayer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialPolygonLayer.Builder#build()} is called immediately and
         * its result is passed to {@link #polygonLayer(GeospatialPolygonLayer)}.
         * 
         * @param polygonLayer
         *        a consumer that will call methods on {@link GeospatialPolygonLayer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #polygonLayer(GeospatialPolygonLayer)
         */
        default Builder polygonLayer(Consumer<GeospatialPolygonLayer.Builder> polygonLayer) {
            return polygonLayer(GeospatialPolygonLayer.builder().applyMutation(polygonLayer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialPointLayer pointLayer;

        private GeospatialLineLayer lineLayer;

        private GeospatialPolygonLayer polygonLayer;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerDefinition model) {
            pointLayer(model.pointLayer);
            lineLayer(model.lineLayer);
            polygonLayer(model.polygonLayer);
        }

        public final GeospatialPointLayer.Builder getPointLayer() {
            return pointLayer != null ? pointLayer.toBuilder() : null;
        }

        public final void setPointLayer(GeospatialPointLayer.BuilderImpl pointLayer) {
            this.pointLayer = pointLayer != null ? pointLayer.build() : null;
        }

        @Override
        public final Builder pointLayer(GeospatialPointLayer pointLayer) {
            this.pointLayer = pointLayer;
            return this;
        }

        public final GeospatialLineLayer.Builder getLineLayer() {
            return lineLayer != null ? lineLayer.toBuilder() : null;
        }

        public final void setLineLayer(GeospatialLineLayer.BuilderImpl lineLayer) {
            this.lineLayer = lineLayer != null ? lineLayer.build() : null;
        }

        @Override
        public final Builder lineLayer(GeospatialLineLayer lineLayer) {
            this.lineLayer = lineLayer;
            return this;
        }

        public final GeospatialPolygonLayer.Builder getPolygonLayer() {
            return polygonLayer != null ? polygonLayer.toBuilder() : null;
        }

        public final void setPolygonLayer(GeospatialPolygonLayer.BuilderImpl polygonLayer) {
            this.polygonLayer = polygonLayer != null ? polygonLayer.build() : null;
        }

        @Override
        public final Builder polygonLayer(GeospatialPolygonLayer polygonLayer) {
            this.polygonLayer = polygonLayer;
            return this;
        }

        @Override
        public GeospatialLayerDefinition build() {
            return new GeospatialLayerDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
