/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Geospatial column group that denotes a hierarchy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoSpatialColumnGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoSpatialColumnGroup.Builder, GeoSpatialColumnGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GeoSpatialColumnGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(GeoSpatialColumnGroup::countryCodeAsString))
            .setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<List<String>> COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(GeoSpatialColumnGroup::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            COUNTRY_CODE_FIELD, COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String countryCode;

    private final List<String> columns;

    private GeoSpatialColumnGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.countryCode = builder.countryCode;
        this.columns = builder.columns;
    }

    /**
     * <p>
     * A display name for the hierarchy.
     * </p>
     * 
     * @return A display name for the hierarchy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link GeoSpatialCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Country code.
     * @see GeoSpatialCountryCode
     */
    public final GeoSpatialCountryCode countryCode() {
        return GeoSpatialCountryCode.fromValue(countryCode);
    }

    /**
     * <p>
     * Country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link GeoSpatialCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Country code.
     * @see GeoSpatialCountryCode
     */
    public final String countryCodeAsString() {
        return countryCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Columns in this hierarchy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return Columns in this hierarchy.
     */
    public final List<String> columns() {
        return columns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoSpatialColumnGroup)) {
            return false;
        }
        GeoSpatialColumnGroup other = (GeoSpatialColumnGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(countryCodeAsString(), other.countryCodeAsString())
                && hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoSpatialColumnGroup").add("Name", name()).add("CountryCode", countryCodeAsString())
                .add("Columns", hasColumns() ? columns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCodeAsString()));
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("Columns", COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeoSpatialColumnGroup, T> g) {
        return obj -> g.apply((GeoSpatialColumnGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoSpatialColumnGroup> {
        /**
         * <p>
         * A display name for the hierarchy.
         * </p>
         * 
         * @param name
         *        A display name for the hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Country code.
         * </p>
         * 
         * @param countryCode
         *        Country code.
         * @see GeoSpatialCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoSpatialCountryCode
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Country code.
         * </p>
         * 
         * @param countryCode
         *        Country code.
         * @see GeoSpatialCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoSpatialCountryCode
         */
        Builder countryCode(GeoSpatialCountryCode countryCode);

        /**
         * <p>
         * Columns in this hierarchy.
         * </p>
         * 
         * @param columns
         *        Columns in this hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<String> columns);

        /**
         * <p>
         * Columns in this hierarchy.
         * </p>
         * 
         * @param columns
         *        Columns in this hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(String... columns);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String countryCode;

        private List<String> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoSpatialColumnGroup model) {
            name(model.name);
            countryCode(model.countryCode);
            columns(model.columns);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(GeoSpatialCountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final Collection<String> getColumns() {
            if (columns instanceof SdkAutoConstructList) {
                return null;
            }
            return columns;
        }

        public final void setColumns(Collection<String> columns) {
            this.columns = ColumnListCopier.copy(columns);
        }

        @Override
        public final Builder columns(Collection<String> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(String... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        public GeoSpatialColumnGroup build() {
            return new GeoSpatialColumnGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
