/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for the <code>FilterAggMetrics</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterAggMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterAggMetrics.Builder, FilterAggMetrics> {
    private static final SdkField<Identifier> METRIC_OPERAND_FIELD = SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
            .memberName("MetricOperand").getter(getter(FilterAggMetrics::metricOperand)).setter(setter(Builder::metricOperand))
            .constructor(Identifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricOperand").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(FilterAggMetrics::functionAsString)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortDirection").getter(getter(FilterAggMetrics::sortDirectionAsString))
            .setter(setter(Builder::sortDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_OPERAND_FIELD,
            FUNCTION_FIELD, SORT_DIRECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Identifier metricOperand;

    private final String function;

    private final String sortDirection;

    private FilterAggMetrics(BuilderImpl builder) {
        this.metricOperand = builder.metricOperand;
        this.function = builder.function;
        this.sortDirection = builder.sortDirection;
    }

    /**
     * <p>
     * The metric operand of the <code>FilterAggMetrics</code>.
     * </p>
     * 
     * @return The metric operand of the <code>FilterAggMetrics</code>.
     */
    public final Identifier metricOperand() {
        return metricOperand;
    }

    /**
     * <p>
     * The function for the <code>FilterAggMetrics</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #function} will
     * return {@link AggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #functionAsString}.
     * </p>
     * 
     * @return The function for the <code>FilterAggMetrics</code>.
     * @see AggType
     */
    public final AggType function() {
        return AggType.fromValue(function);
    }

    /**
     * <p>
     * The function for the <code>FilterAggMetrics</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #function} will
     * return {@link AggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #functionAsString}.
     * </p>
     * 
     * @return The function for the <code>FilterAggMetrics</code>.
     * @see AggType
     */
    public final String functionAsString() {
        return function;
    }

    /**
     * <p>
     * The sort direction for <code>FilterAggMetrics</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link TopicSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction for <code>FilterAggMetrics</code>.
     * @see TopicSortDirection
     */
    public final TopicSortDirection sortDirection() {
        return TopicSortDirection.fromValue(sortDirection);
    }

    /**
     * <p>
     * The sort direction for <code>FilterAggMetrics</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link TopicSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction for <code>FilterAggMetrics</code>.
     * @see TopicSortDirection
     */
    public final String sortDirectionAsString() {
        return sortDirection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricOperand());
        hashCode = 31 * hashCode + Objects.hashCode(functionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortDirectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterAggMetrics)) {
            return false;
        }
        FilterAggMetrics other = (FilterAggMetrics) obj;
        return Objects.equals(metricOperand(), other.metricOperand())
                && Objects.equals(functionAsString(), other.functionAsString())
                && Objects.equals(sortDirectionAsString(), other.sortDirectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterAggMetrics").add("MetricOperand", metricOperand()).add("Function", functionAsString())
                .add("SortDirection", sortDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricOperand":
            return Optional.ofNullable(clazz.cast(metricOperand()));
        case "Function":
            return Optional.ofNullable(clazz.cast(functionAsString()));
        case "SortDirection":
            return Optional.ofNullable(clazz.cast(sortDirectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricOperand", METRIC_OPERAND_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("SortDirection", SORT_DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterAggMetrics, T> g) {
        return obj -> g.apply((FilterAggMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterAggMetrics> {
        /**
         * <p>
         * The metric operand of the <code>FilterAggMetrics</code>.
         * </p>
         * 
         * @param metricOperand
         *        The metric operand of the <code>FilterAggMetrics</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricOperand(Identifier metricOperand);

        /**
         * <p>
         * The metric operand of the <code>FilterAggMetrics</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identifier.Builder} avoiding the need to
         * create one manually via {@link Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identifier.Builder#build()} is called immediately and its result
         * is passed to {@link #metricOperand(Identifier)}.
         * 
         * @param metricOperand
         *        a consumer that will call methods on {@link Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricOperand(Identifier)
         */
        default Builder metricOperand(Consumer<Identifier.Builder> metricOperand) {
            return metricOperand(Identifier.builder().applyMutation(metricOperand).build());
        }

        /**
         * <p>
         * The function for the <code>FilterAggMetrics</code>.
         * </p>
         * 
         * @param function
         *        The function for the <code>FilterAggMetrics</code>.
         * @see AggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggType
         */
        Builder function(String function);

        /**
         * <p>
         * The function for the <code>FilterAggMetrics</code>.
         * </p>
         * 
         * @param function
         *        The function for the <code>FilterAggMetrics</code>.
         * @see AggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggType
         */
        Builder function(AggType function);

        /**
         * <p>
         * The sort direction for <code>FilterAggMetrics</code>.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction for <code>FilterAggMetrics</code>.
         * @see TopicSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicSortDirection
         */
        Builder sortDirection(String sortDirection);

        /**
         * <p>
         * The sort direction for <code>FilterAggMetrics</code>.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction for <code>FilterAggMetrics</code>.
         * @see TopicSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicSortDirection
         */
        Builder sortDirection(TopicSortDirection sortDirection);
    }

    static final class BuilderImpl implements Builder {
        private Identifier metricOperand;

        private String function;

        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterAggMetrics model) {
            metricOperand(model.metricOperand);
            function(model.function);
            sortDirection(model.sortDirection);
        }

        public final Identifier.Builder getMetricOperand() {
            return metricOperand != null ? metricOperand.toBuilder() : null;
        }

        public final void setMetricOperand(Identifier.BuilderImpl metricOperand) {
            this.metricOperand = metricOperand != null ? metricOperand.build() : null;
        }

        @Override
        public final Builder metricOperand(Identifier metricOperand) {
            this.metricOperand = metricOperand;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public final Builder function(AggType function) {
            this.function(function == null ? null : function.toString());
            return this;
        }

        public final String getSortDirection() {
            return sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(TopicSortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        @Override
        public FilterAggMetrics build() {
            return new FilterAggMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
