/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options of a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimePickerControlDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimePickerControlDisplayOptions.Builder, DateTimePickerControlDisplayOptions> {
    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TitleOptions").getter(getter(DateTimePickerControlDisplayOptions::titleOptions))
            .setter(setter(Builder::titleOptions)).constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()).build();

    private static final SdkField<String> DATE_TIME_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateTimeFormat").getter(getter(DateTimePickerControlDisplayOptions::dateTimeFormat))
            .setter(setter(Builder::dateTimeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeFormat").build()).build();

    private static final SdkField<SheetControlInfoIconLabelOptions> INFO_ICON_LABEL_OPTIONS_FIELD = SdkField
            .<SheetControlInfoIconLabelOptions> builder(MarshallingType.SDK_POJO).memberName("InfoIconLabelOptions")
            .getter(getter(DateTimePickerControlDisplayOptions::infoIconLabelOptions))
            .setter(setter(Builder::infoIconLabelOptions)).constructor(SheetControlInfoIconLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoIconLabelOptions").build())
            .build();

    private static final SdkField<String> HELPER_TEXT_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HelperTextVisibility").getter(getter(DateTimePickerControlDisplayOptions::helperTextVisibilityAsString))
            .setter(setter(Builder::helperTextVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelperTextVisibility").build())
            .build();

    private static final SdkField<String> DATE_ICON_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateIconVisibility").getter(getter(DateTimePickerControlDisplayOptions::dateIconVisibilityAsString))
            .setter(setter(Builder::dateIconVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateIconVisibility").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_OPTIONS_FIELD,
            DATE_TIME_FORMAT_FIELD, INFO_ICON_LABEL_OPTIONS_FIELD, HELPER_TEXT_VISIBILITY_FIELD, DATE_ICON_VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LabelOptions titleOptions;

    private final String dateTimeFormat;

    private final SheetControlInfoIconLabelOptions infoIconLabelOptions;

    private final String helperTextVisibility;

    private final String dateIconVisibility;

    private DateTimePickerControlDisplayOptions(BuilderImpl builder) {
        this.titleOptions = builder.titleOptions;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.infoIconLabelOptions = builder.infoIconLabelOptions;
        this.helperTextVisibility = builder.helperTextVisibility;
        this.dateIconVisibility = builder.dateIconVisibility;
    }

    /**
     * <p>
     * The options to configure the title visibility, name, and font size.
     * </p>
     * 
     * @return The options to configure the title visibility, name, and font size.
     */
    public final LabelOptions titleOptions() {
        return titleOptions;
    }

    /**
     * <p>
     * Customize how dates are formatted in controls.
     * </p>
     * 
     * @return Customize how dates are formatted in controls.
     */
    public final String dateTimeFormat() {
        return dateTimeFormat;
    }

    /**
     * <p>
     * The configuration of info icon label options.
     * </p>
     * 
     * @return The configuration of info icon label options.
     */
    public final SheetControlInfoIconLabelOptions infoIconLabelOptions() {
        return infoIconLabelOptions;
    }

    /**
     * <p>
     * The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #helperTextVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #helperTextVisibilityAsString}.
     * </p>
     * 
     * @return The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * @see Visibility
     */
    public final Visibility helperTextVisibility() {
        return Visibility.fromValue(helperTextVisibility);
    }

    /**
     * <p>
     * The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #helperTextVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #helperTextVisibilityAsString}.
     * </p>
     * 
     * @return The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * @see Visibility
     */
    public final String helperTextVisibilityAsString() {
        return helperTextVisibility;
    }

    /**
     * <p>
     * The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dateIconVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #dateIconVisibilityAsString}.
     * </p>
     * 
     * @return The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * @see Visibility
     */
    public final Visibility dateIconVisibility() {
        return Visibility.fromValue(dateIconVisibility);
    }

    /**
     * <p>
     * The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dateIconVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #dateIconVisibilityAsString}.
     * </p>
     * 
     * @return The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
     * @see Visibility
     */
    public final String dateIconVisibilityAsString() {
        return dateIconVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(infoIconLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(helperTextVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateIconVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimePickerControlDisplayOptions)) {
            return false;
        }
        DateTimePickerControlDisplayOptions other = (DateTimePickerControlDisplayOptions) obj;
        return Objects.equals(titleOptions(), other.titleOptions()) && Objects.equals(dateTimeFormat(), other.dateTimeFormat())
                && Objects.equals(infoIconLabelOptions(), other.infoIconLabelOptions())
                && Objects.equals(helperTextVisibilityAsString(), other.helperTextVisibilityAsString())
                && Objects.equals(dateIconVisibilityAsString(), other.dateIconVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimePickerControlDisplayOptions").add("TitleOptions", titleOptions())
                .add("DateTimeFormat", dateTimeFormat()).add("InfoIconLabelOptions", infoIconLabelOptions())
                .add("HelperTextVisibility", helperTextVisibilityAsString())
                .add("DateIconVisibility", dateIconVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TitleOptions":
            return Optional.ofNullable(clazz.cast(titleOptions()));
        case "DateTimeFormat":
            return Optional.ofNullable(clazz.cast(dateTimeFormat()));
        case "InfoIconLabelOptions":
            return Optional.ofNullable(clazz.cast(infoIconLabelOptions()));
        case "HelperTextVisibility":
            return Optional.ofNullable(clazz.cast(helperTextVisibilityAsString()));
        case "DateIconVisibility":
            return Optional.ofNullable(clazz.cast(dateIconVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TitleOptions", TITLE_OPTIONS_FIELD);
        map.put("DateTimeFormat", DATE_TIME_FORMAT_FIELD);
        map.put("InfoIconLabelOptions", INFO_ICON_LABEL_OPTIONS_FIELD);
        map.put("HelperTextVisibility", HELPER_TEXT_VISIBILITY_FIELD);
        map.put("DateIconVisibility", DATE_ICON_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateTimePickerControlDisplayOptions, T> g) {
        return obj -> g.apply((DateTimePickerControlDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimePickerControlDisplayOptions> {
        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * 
         * @param titleOptions
         *        The options to configure the title visibility, name, and font size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOptions(LabelOptions titleOptions);

        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #titleOptions(LabelOptions)}.
         * 
         * @param titleOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleOptions(LabelOptions)
         */
        default Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return titleOptions(LabelOptions.builder().applyMutation(titleOptions).build());
        }

        /**
         * <p>
         * Customize how dates are formatted in controls.
         * </p>
         * 
         * @param dateTimeFormat
         *        Customize how dates are formatted in controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeFormat(String dateTimeFormat);

        /**
         * <p>
         * The configuration of info icon label options.
         * </p>
         * 
         * @param infoIconLabelOptions
         *        The configuration of info icon label options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions);

        /**
         * <p>
         * The configuration of info icon label options.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetControlInfoIconLabelOptions.Builder}
         * avoiding the need to create one manually via {@link SheetControlInfoIconLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetControlInfoIconLabelOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #infoIconLabelOptions(SheetControlInfoIconLabelOptions)}.
         * 
         * @param infoIconLabelOptions
         *        a consumer that will call methods on {@link SheetControlInfoIconLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infoIconLabelOptions(SheetControlInfoIconLabelOptions)
         */
        default Builder infoIconLabelOptions(Consumer<SheetControlInfoIconLabelOptions.Builder> infoIconLabelOptions) {
            return infoIconLabelOptions(SheetControlInfoIconLabelOptions.builder().applyMutation(infoIconLabelOptions).build());
        }

        /**
         * <p>
         * The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * </p>
         * 
         * @param helperTextVisibility
         *        The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder helperTextVisibility(String helperTextVisibility);

        /**
         * <p>
         * The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * </p>
         * 
         * @param helperTextVisibility
         *        The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder helperTextVisibility(Visibility helperTextVisibility);

        /**
         * <p>
         * The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * </p>
         * 
         * @param dateIconVisibility
         *        The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder dateIconVisibility(String dateIconVisibility);

        /**
         * <p>
         * The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * </p>
         * 
         * @param dateIconVisibility
         *        The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder dateIconVisibility(Visibility dateIconVisibility);
    }

    static final class BuilderImpl implements Builder {
        private LabelOptions titleOptions;

        private String dateTimeFormat;

        private SheetControlInfoIconLabelOptions infoIconLabelOptions;

        private String helperTextVisibility;

        private String dateIconVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimePickerControlDisplayOptions model) {
            titleOptions(model.titleOptions);
            dateTimeFormat(model.dateTimeFormat);
            infoIconLabelOptions(model.infoIconLabelOptions);
            helperTextVisibility(model.helperTextVisibility);
            dateIconVisibility(model.dateIconVisibility);
        }

        public final LabelOptions.Builder getTitleOptions() {
            return titleOptions != null ? titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final String getDateTimeFormat() {
            return dateTimeFormat;
        }

        public final void setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        @Override
        public final Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public final SheetControlInfoIconLabelOptions.Builder getInfoIconLabelOptions() {
            return infoIconLabelOptions != null ? infoIconLabelOptions.toBuilder() : null;
        }

        public final void setInfoIconLabelOptions(SheetControlInfoIconLabelOptions.BuilderImpl infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions != null ? infoIconLabelOptions.build() : null;
        }

        @Override
        public final Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions;
            return this;
        }

        public final String getHelperTextVisibility() {
            return helperTextVisibility;
        }

        public final void setHelperTextVisibility(String helperTextVisibility) {
            this.helperTextVisibility = helperTextVisibility;
        }

        @Override
        public final Builder helperTextVisibility(String helperTextVisibility) {
            this.helperTextVisibility = helperTextVisibility;
            return this;
        }

        @Override
        public final Builder helperTextVisibility(Visibility helperTextVisibility) {
            this.helperTextVisibility(helperTextVisibility == null ? null : helperTextVisibility.toString());
            return this;
        }

        public final String getDateIconVisibility() {
            return dateIconVisibility;
        }

        public final void setDateIconVisibility(String dateIconVisibility) {
            this.dateIconVisibility = dateIconVisibility;
        }

        @Override
        public final Builder dateIconVisibility(String dateIconVisibility) {
            this.dateIconVisibility = dateIconVisibility;
            return this;
        }

        @Override
        public final Builder dateIconVisibility(Visibility dateIconVisibility) {
            this.dateIconVisibility(dateIconVisibility == null ? null : dateIconVisibility.toString());
            return this;
        }

        @Override
        public DateTimePickerControlDisplayOptions build() {
            return new DateTimePickerControlDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
