/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The navigation operation that navigates between different sheets in the same analysis.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionNavigationOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionNavigationOperation.Builder, CustomActionNavigationOperation> {
    private static final SdkField<LocalNavigationConfiguration> LOCAL_NAVIGATION_CONFIGURATION_FIELD = SdkField
            .<LocalNavigationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LocalNavigationConfiguration")
            .getter(getter(CustomActionNavigationOperation::localNavigationConfiguration))
            .setter(setter(Builder::localNavigationConfiguration))
            .constructor(LocalNavigationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalNavigationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_NAVIGATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LocalNavigationConfiguration localNavigationConfiguration;

    private CustomActionNavigationOperation(BuilderImpl builder) {
        this.localNavigationConfiguration = builder.localNavigationConfiguration;
    }

    /**
     * <p>
     * The configuration that chooses the navigation target.
     * </p>
     * 
     * @return The configuration that chooses the navigation target.
     */
    public final LocalNavigationConfiguration localNavigationConfiguration() {
        return localNavigationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localNavigationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionNavigationOperation)) {
            return false;
        }
        CustomActionNavigationOperation other = (CustomActionNavigationOperation) obj;
        return Objects.equals(localNavigationConfiguration(), other.localNavigationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionNavigationOperation")
                .add("LocalNavigationConfiguration", localNavigationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalNavigationConfiguration":
            return Optional.ofNullable(clazz.cast(localNavigationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalNavigationConfiguration", LOCAL_NAVIGATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionNavigationOperation, T> g) {
        return obj -> g.apply((CustomActionNavigationOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionNavigationOperation> {
        /**
         * <p>
         * The configuration that chooses the navigation target.
         * </p>
         * 
         * @param localNavigationConfiguration
         *        The configuration that chooses the navigation target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localNavigationConfiguration(LocalNavigationConfiguration localNavigationConfiguration);

        /**
         * <p>
         * The configuration that chooses the navigation target.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalNavigationConfiguration.Builder}
         * avoiding the need to create one manually via {@link LocalNavigationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalNavigationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #localNavigationConfiguration(LocalNavigationConfiguration)}.
         * 
         * @param localNavigationConfiguration
         *        a consumer that will call methods on {@link LocalNavigationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localNavigationConfiguration(LocalNavigationConfiguration)
         */
        default Builder localNavigationConfiguration(Consumer<LocalNavigationConfiguration.Builder> localNavigationConfiguration) {
            return localNavigationConfiguration(LocalNavigationConfiguration.builder()
                    .applyMutation(localNavigationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LocalNavigationConfiguration localNavigationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionNavigationOperation model) {
            localNavigationConfiguration(model.localNavigationConfiguration);
        }

        public final LocalNavigationConfiguration.Builder getLocalNavigationConfiguration() {
            return localNavigationConfiguration != null ? localNavigationConfiguration.toBuilder() : null;
        }

        public final void setLocalNavigationConfiguration(LocalNavigationConfiguration.BuilderImpl localNavigationConfiguration) {
            this.localNavigationConfiguration = localNavigationConfiguration != null ? localNavigationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder localNavigationConfiguration(LocalNavigationConfiguration localNavigationConfiguration) {
            this.localNavigationConfiguration = localNavigationConfiguration;
            return this;
        }

        @Override
        public CustomActionNavigationOperation build() {
            return new CustomActionNavigationOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
