/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccountSubscriptionResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateAccountSubscriptionResponse.Builder, CreateAccountSubscriptionResponse> {
    private static final SdkField<SignupResponse> SIGNUP_RESPONSE_FIELD = SdkField
            .<SignupResponse> builder(MarshallingType.SDK_POJO).memberName("SignupResponse")
            .getter(getter(CreateAccountSubscriptionResponse::signupResponse)).setter(setter(Builder::signupResponse))
            .constructor(SignupResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignupResponse").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateAccountSubscriptionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateAccountSubscriptionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNUP_RESPONSE_FIELD,
            STATUS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SignupResponse signupResponse;

    private final Integer status;

    private final String requestId;

    private CreateAccountSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.signupResponse = builder.signupResponse;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * A <code>SignupResponse</code> object that returns information about a newly created Amazon QuickSight account.
     * </p>
     * 
     * @return A <code>SignupResponse</code> object that returns information about a newly created Amazon QuickSight
     *         account.
     */
    public final SignupResponse signupResponse() {
        return signupResponse;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signupResponse());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountSubscriptionResponse)) {
            return false;
        }
        CreateAccountSubscriptionResponse other = (CreateAccountSubscriptionResponse) obj;
        return Objects.equals(signupResponse(), other.signupResponse()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccountSubscriptionResponse").add("SignupResponse", signupResponse())
                .add("Status", status()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SignupResponse":
            return Optional.ofNullable(clazz.cast(signupResponse()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SignupResponse", SIGNUP_RESPONSE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateAccountSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccountSubscriptionResponse> {
        /**
         * <p>
         * A <code>SignupResponse</code> object that returns information about a newly created Amazon QuickSight
         * account.
         * </p>
         * 
         * @param signupResponse
         *        A <code>SignupResponse</code> object that returns information about a newly created Amazon QuickSight
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signupResponse(SignupResponse signupResponse);

        /**
         * <p>
         * A <code>SignupResponse</code> object that returns information about a newly created Amazon QuickSight
         * account.
         * </p>
         * This is a convenience method that creates an instance of the {@link SignupResponse.Builder} avoiding the need
         * to create one manually via {@link SignupResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignupResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #signupResponse(SignupResponse)}.
         * 
         * @param signupResponse
         *        a consumer that will call methods on {@link SignupResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signupResponse(SignupResponse)
         */
        default Builder signupResponse(Consumer<SignupResponse.Builder> signupResponse) {
            return signupResponse(SignupResponse.builder().applyMutation(signupResponse).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private SignupResponse signupResponse;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountSubscriptionResponse model) {
            super(model);
            signupResponse(model.signupResponse);
            status(model.status);
            requestId(model.requestId);
        }

        public final SignupResponse.Builder getSignupResponse() {
            return signupResponse != null ? signupResponse.toBuilder() : null;
        }

        public final void setSignupResponse(SignupResponse.BuilderImpl signupResponse) {
            this.signupResponse = signupResponse != null ? signupResponse.build() : null;
        }

        @Override
        public final Builder signupResponse(SignupResponse signupResponse) {
            this.signupResponse = signupResponse;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public CreateAccountSubscriptionResponse build() {
            return new CreateAccountSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
