/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting configuration for gradient color.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingGradientColor implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingGradientColor.Builder, ConditionalFormattingGradientColor> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(ConditionalFormattingGradientColor::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<GradientColor> COLOR_FIELD = SdkField.<GradientColor> builder(MarshallingType.SDK_POJO)
            .memberName("Color").getter(getter(ConditionalFormattingGradientColor::color)).setter(setter(Builder::color))
            .constructor(GradientColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXPRESSION_FIELD, COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final GradientColor color;

    private ConditionalFormattingGradientColor(BuilderImpl builder) {
        this.expression = builder.expression;
        this.color = builder.color;
    }

    /**
     * <p>
     * The expression that determines the formatting configuration for gradient color.
     * </p>
     * 
     * @return The expression that determines the formatting configuration for gradient color.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * Determines the color.
     * </p>
     * 
     * @return Determines the color.
     */
    public final GradientColor color() {
        return color;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingGradientColor)) {
            return false;
        }
        ConditionalFormattingGradientColor other = (ConditionalFormattingGradientColor) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(color(), other.color());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingGradientColor")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***").add("Color", color()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Color", COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingGradientColor, T> g) {
        return obj -> g.apply((ConditionalFormattingGradientColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingGradientColor> {
        /**
         * <p>
         * The expression that determines the formatting configuration for gradient color.
         * </p>
         * 
         * @param expression
         *        The expression that determines the formatting configuration for gradient color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Determines the color.
         * </p>
         * 
         * @param color
         *        Determines the color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(GradientColor color);

        /**
         * <p>
         * Determines the color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GradientColor.Builder} avoiding the need
         * to create one manually via {@link GradientColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GradientColor.Builder#build()} is called immediately and its
         * result is passed to {@link #color(GradientColor)}.
         * 
         * @param color
         *        a consumer that will call methods on {@link GradientColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #color(GradientColor)
         */
        default Builder color(Consumer<GradientColor.Builder> color) {
            return color(GradientColor.builder().applyMutation(color).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private GradientColor color;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingGradientColor model) {
            expression(model.expression);
            color(model.color);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final GradientColor.Builder getColor() {
            return color != null ? color.toBuilder() : null;
        }

        public final void setColor(GradientColor.BuilderImpl color) {
            this.color = color != null ? color.build() : null;
        }

        @Override
        public final Builder color(GradientColor color) {
            this.color = color;
            return this;
        }

        @Override
        public ConditionalFormattingGradientColor build() {
            return new ConditionalFormattingGradientColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
