/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom icon options for an icon set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingCustomIconOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingCustomIconOptions.Builder, ConditionalFormattingCustomIconOptions> {
    private static final SdkField<String> ICON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Icon")
            .getter(getter(ConditionalFormattingCustomIconOptions::iconAsString)).setter(setter(Builder::icon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icon").build()).build();

    private static final SdkField<String> UNICODE_ICON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnicodeIcon").getter(getter(ConditionalFormattingCustomIconOptions::unicodeIcon))
            .setter(setter(Builder::unicodeIcon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnicodeIcon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ICON_FIELD, UNICODE_ICON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String icon;

    private final String unicodeIcon;

    private ConditionalFormattingCustomIconOptions(BuilderImpl builder) {
        this.icon = builder.icon;
        this.unicodeIcon = builder.unicodeIcon;
    }

    /**
     * <p>
     * Determines the type of icon.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #icon} will return
     * {@link Icon#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iconAsString}.
     * </p>
     * 
     * @return Determines the type of icon.
     * @see Icon
     */
    public final Icon icon() {
        return Icon.fromValue(icon);
    }

    /**
     * <p>
     * Determines the type of icon.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #icon} will return
     * {@link Icon#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iconAsString}.
     * </p>
     * 
     * @return Determines the type of icon.
     * @see Icon
     */
    public final String iconAsString() {
        return icon;
    }

    /**
     * <p>
     * Determines the Unicode icon type.
     * </p>
     * 
     * @return Determines the Unicode icon type.
     */
    public final String unicodeIcon() {
        return unicodeIcon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iconAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unicodeIcon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingCustomIconOptions)) {
            return false;
        }
        ConditionalFormattingCustomIconOptions other = (ConditionalFormattingCustomIconOptions) obj;
        return Objects.equals(iconAsString(), other.iconAsString()) && Objects.equals(unicodeIcon(), other.unicodeIcon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingCustomIconOptions").add("Icon", iconAsString())
                .add("UnicodeIcon", unicodeIcon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Icon":
            return Optional.ofNullable(clazz.cast(iconAsString()));
        case "UnicodeIcon":
            return Optional.ofNullable(clazz.cast(unicodeIcon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Icon", ICON_FIELD);
        map.put("UnicodeIcon", UNICODE_ICON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingCustomIconOptions, T> g) {
        return obj -> g.apply((ConditionalFormattingCustomIconOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingCustomIconOptions> {
        /**
         * <p>
         * Determines the type of icon.
         * </p>
         * 
         * @param icon
         *        Determines the type of icon.
         * @see Icon
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Icon
         */
        Builder icon(String icon);

        /**
         * <p>
         * Determines the type of icon.
         * </p>
         * 
         * @param icon
         *        Determines the type of icon.
         * @see Icon
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Icon
         */
        Builder icon(Icon icon);

        /**
         * <p>
         * Determines the Unicode icon type.
         * </p>
         * 
         * @param unicodeIcon
         *        Determines the Unicode icon type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unicodeIcon(String unicodeIcon);
    }

    static final class BuilderImpl implements Builder {
        private String icon;

        private String unicodeIcon;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingCustomIconOptions model) {
            icon(model.icon);
            unicodeIcon(model.unicodeIcon);
        }

        public final String getIcon() {
            return icon;
        }

        public final void setIcon(String icon) {
            this.icon = icon;
        }

        @Override
        public final Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public final Builder icon(Icon icon) {
            this.icon(icon == null ? null : icon.toString());
            return this;
        }

        public final String getUnicodeIcon() {
            return unicodeIcon;
        }

        public final void setUnicodeIcon(String unicodeIcon) {
            this.unicodeIcon = unicodeIcon;
        }

        @Override
        public final Builder unicodeIcon(String unicodeIcon) {
            this.unicodeIcon = unicodeIcon;
            return this;
        }

        @Override
        public ConditionalFormattingCustomIconOptions build() {
            return new ConditionalFormattingCustomIconOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
