/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The formatting configuration for the color.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingColor implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingColor.Builder, ConditionalFormattingColor> {
    private static final SdkField<ConditionalFormattingSolidColor> SOLID_FIELD = SdkField
            .<ConditionalFormattingSolidColor> builder(MarshallingType.SDK_POJO).memberName("Solid")
            .getter(getter(ConditionalFormattingColor::solid)).setter(setter(Builder::solid))
            .constructor(ConditionalFormattingSolidColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solid").build()).build();

    private static final SdkField<ConditionalFormattingGradientColor> GRADIENT_FIELD = SdkField
            .<ConditionalFormattingGradientColor> builder(MarshallingType.SDK_POJO).memberName("Gradient")
            .getter(getter(ConditionalFormattingColor::gradient)).setter(setter(Builder::gradient))
            .constructor(ConditionalFormattingGradientColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gradient").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLID_FIELD, GRADIENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConditionalFormattingSolidColor solid;

    private final ConditionalFormattingGradientColor gradient;

    private ConditionalFormattingColor(BuilderImpl builder) {
        this.solid = builder.solid;
        this.gradient = builder.gradient;
    }

    /**
     * <p>
     * Formatting configuration for solid color.
     * </p>
     * 
     * @return Formatting configuration for solid color.
     */
    public final ConditionalFormattingSolidColor solid() {
        return solid;
    }

    /**
     * <p>
     * Formatting configuration for gradient color.
     * </p>
     * 
     * @return Formatting configuration for gradient color.
     */
    public final ConditionalFormattingGradientColor gradient() {
        return gradient;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solid());
        hashCode = 31 * hashCode + Objects.hashCode(gradient());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingColor)) {
            return false;
        }
        ConditionalFormattingColor other = (ConditionalFormattingColor) obj;
        return Objects.equals(solid(), other.solid()) && Objects.equals(gradient(), other.gradient());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingColor").add("Solid", solid()).add("Gradient", gradient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Solid":
            return Optional.ofNullable(clazz.cast(solid()));
        case "Gradient":
            return Optional.ofNullable(clazz.cast(gradient()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Solid", SOLID_FIELD);
        map.put("Gradient", GRADIENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingColor, T> g) {
        return obj -> g.apply((ConditionalFormattingColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingColor> {
        /**
         * <p>
         * Formatting configuration for solid color.
         * </p>
         * 
         * @param solid
         *        Formatting configuration for solid color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solid(ConditionalFormattingSolidColor solid);

        /**
         * <p>
         * Formatting configuration for solid color.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingSolidColor.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingSolidColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingSolidColor.Builder#build()} is called
         * immediately and its result is passed to {@link #solid(ConditionalFormattingSolidColor)}.
         * 
         * @param solid
         *        a consumer that will call methods on {@link ConditionalFormattingSolidColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solid(ConditionalFormattingSolidColor)
         */
        default Builder solid(Consumer<ConditionalFormattingSolidColor.Builder> solid) {
            return solid(ConditionalFormattingSolidColor.builder().applyMutation(solid).build());
        }

        /**
         * <p>
         * Formatting configuration for gradient color.
         * </p>
         * 
         * @param gradient
         *        Formatting configuration for gradient color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gradient(ConditionalFormattingGradientColor gradient);

        /**
         * <p>
         * Formatting configuration for gradient color.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConditionalFormattingGradientColor.Builder} avoiding the need to create one manually via
         * {@link ConditionalFormattingGradientColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingGradientColor.Builder#build()} is called
         * immediately and its result is passed to {@link #gradient(ConditionalFormattingGradientColor)}.
         * 
         * @param gradient
         *        a consumer that will call methods on {@link ConditionalFormattingGradientColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gradient(ConditionalFormattingGradientColor)
         */
        default Builder gradient(Consumer<ConditionalFormattingGradientColor.Builder> gradient) {
            return gradient(ConditionalFormattingGradientColor.builder().applyMutation(gradient).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionalFormattingSolidColor solid;

        private ConditionalFormattingGradientColor gradient;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingColor model) {
            solid(model.solid);
            gradient(model.gradient);
        }

        public final ConditionalFormattingSolidColor.Builder getSolid() {
            return solid != null ? solid.toBuilder() : null;
        }

        public final void setSolid(ConditionalFormattingSolidColor.BuilderImpl solid) {
            this.solid = solid != null ? solid.build() : null;
        }

        @Override
        public final Builder solid(ConditionalFormattingSolidColor solid) {
            this.solid = solid;
            return this;
        }

        public final ConditionalFormattingGradientColor.Builder getGradient() {
            return gradient != null ? gradient.toBuilder() : null;
        }

        public final void setGradient(ConditionalFormattingGradientColor.BuilderImpl gradient) {
            this.gradient = gradient != null ? gradient.build() : null;
        }

        @Override
        public final Builder gradient(ConditionalFormattingGradientColor gradient) {
            this.gradient = gradient;
            return this;
        }

        @Override
        public ConditionalFormattingColor build() {
            return new ConditionalFormattingColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
