/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that determines the hierarchy of the fields for a visual element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnHierarchy implements SdkPojo, Serializable, ToCopyableBuilder<ColumnHierarchy.Builder, ColumnHierarchy> {
    private static final SdkField<ExplicitHierarchy> EXPLICIT_HIERARCHY_FIELD = SdkField
            .<ExplicitHierarchy> builder(MarshallingType.SDK_POJO).memberName("ExplicitHierarchy")
            .getter(getter(ColumnHierarchy::explicitHierarchy)).setter(setter(Builder::explicitHierarchy))
            .constructor(ExplicitHierarchy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitHierarchy").build()).build();

    private static final SdkField<DateTimeHierarchy> DATE_TIME_HIERARCHY_FIELD = SdkField
            .<DateTimeHierarchy> builder(MarshallingType.SDK_POJO).memberName("DateTimeHierarchy")
            .getter(getter(ColumnHierarchy::dateTimeHierarchy)).setter(setter(Builder::dateTimeHierarchy))
            .constructor(DateTimeHierarchy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeHierarchy").build()).build();

    private static final SdkField<PredefinedHierarchy> PREDEFINED_HIERARCHY_FIELD = SdkField
            .<PredefinedHierarchy> builder(MarshallingType.SDK_POJO).memberName("PredefinedHierarchy")
            .getter(getter(ColumnHierarchy::predefinedHierarchy)).setter(setter(Builder::predefinedHierarchy))
            .constructor(PredefinedHierarchy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedHierarchy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLICIT_HIERARCHY_FIELD,
            DATE_TIME_HIERARCHY_FIELD, PREDEFINED_HIERARCHY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExplicitHierarchy explicitHierarchy;

    private final DateTimeHierarchy dateTimeHierarchy;

    private final PredefinedHierarchy predefinedHierarchy;

    private ColumnHierarchy(BuilderImpl builder) {
        this.explicitHierarchy = builder.explicitHierarchy;
        this.dateTimeHierarchy = builder.dateTimeHierarchy;
        this.predefinedHierarchy = builder.predefinedHierarchy;
    }

    /**
     * <p>
     * The option that determines the hierarchy of the fields that are built within a visual's field wells. These fields
     * can't be duplicated to other visuals.
     * </p>
     * 
     * @return The option that determines the hierarchy of the fields that are built within a visual's field wells.
     *         These fields can't be duplicated to other visuals.
     */
    public final ExplicitHierarchy explicitHierarchy() {
        return explicitHierarchy;
    }

    /**
     * <p>
     * The option that determines the hierarchy of any <code>DateTime</code> fields.
     * </p>
     * 
     * @return The option that determines the hierarchy of any <code>DateTime</code> fields.
     */
    public final DateTimeHierarchy dateTimeHierarchy() {
        return dateTimeHierarchy;
    }

    /**
     * <p>
     * The option that determines the hierarchy of the fields that are defined during data preparation. These fields are
     * available to use in any analysis that uses the data source.
     * </p>
     * 
     * @return The option that determines the hierarchy of the fields that are defined during data preparation. These
     *         fields are available to use in any analysis that uses the data source.
     */
    public final PredefinedHierarchy predefinedHierarchy() {
        return predefinedHierarchy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(explicitHierarchy());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeHierarchy());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedHierarchy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnHierarchy)) {
            return false;
        }
        ColumnHierarchy other = (ColumnHierarchy) obj;
        return Objects.equals(explicitHierarchy(), other.explicitHierarchy())
                && Objects.equals(dateTimeHierarchy(), other.dateTimeHierarchy())
                && Objects.equals(predefinedHierarchy(), other.predefinedHierarchy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnHierarchy").add("ExplicitHierarchy", explicitHierarchy())
                .add("DateTimeHierarchy", dateTimeHierarchy()).add("PredefinedHierarchy", predefinedHierarchy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplicitHierarchy":
            return Optional.ofNullable(clazz.cast(explicitHierarchy()));
        case "DateTimeHierarchy":
            return Optional.ofNullable(clazz.cast(dateTimeHierarchy()));
        case "PredefinedHierarchy":
            return Optional.ofNullable(clazz.cast(predefinedHierarchy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExplicitHierarchy", EXPLICIT_HIERARCHY_FIELD);
        map.put("DateTimeHierarchy", DATE_TIME_HIERARCHY_FIELD);
        map.put("PredefinedHierarchy", PREDEFINED_HIERARCHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnHierarchy, T> g) {
        return obj -> g.apply((ColumnHierarchy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnHierarchy> {
        /**
         * <p>
         * The option that determines the hierarchy of the fields that are built within a visual's field wells. These
         * fields can't be duplicated to other visuals.
         * </p>
         * 
         * @param explicitHierarchy
         *        The option that determines the hierarchy of the fields that are built within a visual's field wells.
         *        These fields can't be duplicated to other visuals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitHierarchy(ExplicitHierarchy explicitHierarchy);

        /**
         * <p>
         * The option that determines the hierarchy of the fields that are built within a visual's field wells. These
         * fields can't be duplicated to other visuals.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExplicitHierarchy.Builder} avoiding the
         * need to create one manually via {@link ExplicitHierarchy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExplicitHierarchy.Builder#build()} is called immediately and its
         * result is passed to {@link #explicitHierarchy(ExplicitHierarchy)}.
         * 
         * @param explicitHierarchy
         *        a consumer that will call methods on {@link ExplicitHierarchy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explicitHierarchy(ExplicitHierarchy)
         */
        default Builder explicitHierarchy(Consumer<ExplicitHierarchy.Builder> explicitHierarchy) {
            return explicitHierarchy(ExplicitHierarchy.builder().applyMutation(explicitHierarchy).build());
        }

        /**
         * <p>
         * The option that determines the hierarchy of any <code>DateTime</code> fields.
         * </p>
         * 
         * @param dateTimeHierarchy
         *        The option that determines the hierarchy of any <code>DateTime</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeHierarchy(DateTimeHierarchy dateTimeHierarchy);

        /**
         * <p>
         * The option that determines the hierarchy of any <code>DateTime</code> fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeHierarchy.Builder} avoiding the
         * need to create one manually via {@link DateTimeHierarchy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeHierarchy.Builder#build()} is called immediately and its
         * result is passed to {@link #dateTimeHierarchy(DateTimeHierarchy)}.
         * 
         * @param dateTimeHierarchy
         *        a consumer that will call methods on {@link DateTimeHierarchy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeHierarchy(DateTimeHierarchy)
         */
        default Builder dateTimeHierarchy(Consumer<DateTimeHierarchy.Builder> dateTimeHierarchy) {
            return dateTimeHierarchy(DateTimeHierarchy.builder().applyMutation(dateTimeHierarchy).build());
        }

        /**
         * <p>
         * The option that determines the hierarchy of the fields that are defined during data preparation. These fields
         * are available to use in any analysis that uses the data source.
         * </p>
         * 
         * @param predefinedHierarchy
         *        The option that determines the hierarchy of the fields that are defined during data preparation. These
         *        fields are available to use in any analysis that uses the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedHierarchy(PredefinedHierarchy predefinedHierarchy);

        /**
         * <p>
         * The option that determines the hierarchy of the fields that are defined during data preparation. These fields
         * are available to use in any analysis that uses the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredefinedHierarchy.Builder} avoiding the
         * need to create one manually via {@link PredefinedHierarchy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredefinedHierarchy.Builder#build()} is called immediately and
         * its result is passed to {@link #predefinedHierarchy(PredefinedHierarchy)}.
         * 
         * @param predefinedHierarchy
         *        a consumer that will call methods on {@link PredefinedHierarchy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedHierarchy(PredefinedHierarchy)
         */
        default Builder predefinedHierarchy(Consumer<PredefinedHierarchy.Builder> predefinedHierarchy) {
            return predefinedHierarchy(PredefinedHierarchy.builder().applyMutation(predefinedHierarchy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExplicitHierarchy explicitHierarchy;

        private DateTimeHierarchy dateTimeHierarchy;

        private PredefinedHierarchy predefinedHierarchy;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnHierarchy model) {
            explicitHierarchy(model.explicitHierarchy);
            dateTimeHierarchy(model.dateTimeHierarchy);
            predefinedHierarchy(model.predefinedHierarchy);
        }

        public final ExplicitHierarchy.Builder getExplicitHierarchy() {
            return explicitHierarchy != null ? explicitHierarchy.toBuilder() : null;
        }

        public final void setExplicitHierarchy(ExplicitHierarchy.BuilderImpl explicitHierarchy) {
            this.explicitHierarchy = explicitHierarchy != null ? explicitHierarchy.build() : null;
        }

        @Override
        public final Builder explicitHierarchy(ExplicitHierarchy explicitHierarchy) {
            this.explicitHierarchy = explicitHierarchy;
            return this;
        }

        public final DateTimeHierarchy.Builder getDateTimeHierarchy() {
            return dateTimeHierarchy != null ? dateTimeHierarchy.toBuilder() : null;
        }

        public final void setDateTimeHierarchy(DateTimeHierarchy.BuilderImpl dateTimeHierarchy) {
            this.dateTimeHierarchy = dateTimeHierarchy != null ? dateTimeHierarchy.build() : null;
        }

        @Override
        public final Builder dateTimeHierarchy(DateTimeHierarchy dateTimeHierarchy) {
            this.dateTimeHierarchy = dateTimeHierarchy;
            return this;
        }

        public final PredefinedHierarchy.Builder getPredefinedHierarchy() {
            return predefinedHierarchy != null ? predefinedHierarchy.toBuilder() : null;
        }

        public final void setPredefinedHierarchy(PredefinedHierarchy.BuilderImpl predefinedHierarchy) {
            this.predefinedHierarchy = predefinedHierarchy != null ? predefinedHierarchy.build() : null;
        }

        @Override
        public final Builder predefinedHierarchy(PredefinedHierarchy predefinedHierarchy) {
            this.predefinedHierarchy = predefinedHierarchy;
            return this;
        }

        @Override
        public ColumnHierarchy build() {
            return new ColumnHierarchy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
