/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The calculated field of an analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculatedField implements SdkPojo, Serializable, ToCopyableBuilder<CalculatedField.Builder, CalculatedField> {
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetIdentifier").getter(getter(CalculatedField::dataSetIdentifier))
            .setter(setter(Builder::dataSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CalculatedField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(CalculatedField::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDENTIFIER_FIELD,
            NAME_FIELD, EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetIdentifier;

    private final String name;

    private final String expression;

    private CalculatedField(BuilderImpl builder) {
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.name = builder.name;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * The data set that is used in this calculated field.
     * </p>
     * 
     * @return The data set that is used in this calculated field.
     */
    public final String dataSetIdentifier() {
        return dataSetIdentifier;
    }

    /**
     * <p>
     * The name of the calculated field.
     * </p>
     * 
     * @return The name of the calculated field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The expression of the calculated field.
     * </p>
     * 
     * @return The expression of the calculated field.
     */
    public final String expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedField)) {
            return false;
        }
        CalculatedField other = (CalculatedField) obj;
        return Objects.equals(dataSetIdentifier(), other.dataSetIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculatedField").add("DataSetIdentifier", dataSetIdentifier()).add("Name", name())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetIdentifier":
            return Optional.ofNullable(clazz.cast(dataSetIdentifier()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetIdentifier", DATA_SET_IDENTIFIER_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculatedField, T> g) {
        return obj -> g.apply((CalculatedField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculatedField> {
        /**
         * <p>
         * The data set that is used in this calculated field.
         * </p>
         * 
         * @param dataSetIdentifier
         *        The data set that is used in this calculated field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifier(String dataSetIdentifier);

        /**
         * <p>
         * The name of the calculated field.
         * </p>
         * 
         * @param name
         *        The name of the calculated field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The expression of the calculated field.
         * </p>
         * 
         * @param expression
         *        The expression of the calculated field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetIdentifier;

        private String name;

        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedField model) {
            dataSetIdentifier(model.dataSetIdentifier);
            name(model.name);
            expression(model.expression);
        }

        public final String getDataSetIdentifier() {
            return dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public CalculatedField build() {
            return new CalculatedField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
