/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of analysis level configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetOptions implements SdkPojo, Serializable, ToCopyableBuilder<AssetOptions.Builder, AssetOptions> {
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(AssetOptions::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> WEEK_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WeekStart").getter(getter(AssetOptions::weekStartAsString)).setter(setter(Builder::weekStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeekStart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEZONE_FIELD,
            WEEK_START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timezone;

    private final String weekStart;

    private AssetOptions(BuilderImpl builder) {
        this.timezone = builder.timezone;
        this.weekStart = builder.weekStart;
    }

    /**
     * <p>
     * Determines the timezone for the analysis.
     * </p>
     * 
     * @return Determines the timezone for the analysis.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Determines the week start day for an analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #weekStart} will
     * return {@link DayOfTheWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #weekStartAsString}.
     * </p>
     * 
     * @return Determines the week start day for an analysis.
     * @see DayOfTheWeek
     */
    public final DayOfTheWeek weekStart() {
        return DayOfTheWeek.fromValue(weekStart);
    }

    /**
     * <p>
     * Determines the week start day for an analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #weekStart} will
     * return {@link DayOfTheWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #weekStartAsString}.
     * </p>
     * 
     * @return Determines the week start day for an analysis.
     * @see DayOfTheWeek
     */
    public final String weekStartAsString() {
        return weekStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(weekStartAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetOptions)) {
            return false;
        }
        AssetOptions other = (AssetOptions) obj;
        return Objects.equals(timezone(), other.timezone()) && Objects.equals(weekStartAsString(), other.weekStartAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetOptions").add("Timezone", timezone()).add("WeekStart", weekStartAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "WeekStart":
            return Optional.ofNullable(clazz.cast(weekStartAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("WeekStart", WEEK_START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetOptions, T> g) {
        return obj -> g.apply((AssetOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetOptions> {
        /**
         * <p>
         * Determines the timezone for the analysis.
         * </p>
         * 
         * @param timezone
         *        Determines the timezone for the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Determines the week start day for an analysis.
         * </p>
         * 
         * @param weekStart
         *        Determines the week start day for an analysis.
         * @see DayOfTheWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfTheWeek
         */
        Builder weekStart(String weekStart);

        /**
         * <p>
         * Determines the week start day for an analysis.
         * </p>
         * 
         * @param weekStart
         *        Determines the week start day for an analysis.
         * @see DayOfTheWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfTheWeek
         */
        Builder weekStart(DayOfTheWeek weekStart);
    }

    static final class BuilderImpl implements Builder {
        private String timezone;

        private String weekStart;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetOptions model) {
            timezone(model.timezone);
            weekStart(model.weekStart);
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getWeekStart() {
            return weekStart;
        }

        public final void setWeekStart(String weekStart) {
            this.weekStart = weekStart;
        }

        @Override
        public final Builder weekStart(String weekStart) {
            this.weekStart = weekStart;
            return this;
        }

        @Override
        public final Builder weekStart(DayOfTheWeek weekStart) {
            this.weekStart(weekStart == null ? null : weekStart.toString());
            return this;
        }

        @Override
        public AssetOptions build() {
            return new AssetOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
