/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional parameter that overrides the validation strategy for all analyses and dashboards before the resource is
 * imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobOverrideValidationStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobOverrideValidationStrategy.Builder, AssetBundleImportJobOverrideValidationStrategy> {
    private static final SdkField<Boolean> STRICT_MODE_FOR_ALL_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("StrictModeForAllResources")
            .getter(getter(AssetBundleImportJobOverrideValidationStrategy::strictModeForAllResources))
            .setter(setter(Builder::strictModeForAllResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrictModeForAllResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STRICT_MODE_FOR_ALL_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean strictModeForAllResources;

    private AssetBundleImportJobOverrideValidationStrategy(BuilderImpl builder) {
        this.strictModeForAllResources = builder.strictModeForAllResources;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to import all analyses and dashboards under strict or lenient mode.
     * </p>
     * 
     * @return A Boolean value that indicates whether to import all analyses and dashboards under strict or lenient
     *         mode.
     */
    public final Boolean strictModeForAllResources() {
        return strictModeForAllResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(strictModeForAllResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobOverrideValidationStrategy)) {
            return false;
        }
        AssetBundleImportJobOverrideValidationStrategy other = (AssetBundleImportJobOverrideValidationStrategy) obj;
        return Objects.equals(strictModeForAllResources(), other.strictModeForAllResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobOverrideValidationStrategy")
                .add("StrictModeForAllResources", strictModeForAllResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StrictModeForAllResources":
            return Optional.ofNullable(clazz.cast(strictModeForAllResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StrictModeForAllResources", STRICT_MODE_FOR_ALL_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobOverrideValidationStrategy, T> g) {
        return obj -> g.apply((AssetBundleImportJobOverrideValidationStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobOverrideValidationStrategy> {
        /**
         * <p>
         * A Boolean value that indicates whether to import all analyses and dashboards under strict or lenient mode.
         * </p>
         * 
         * @param strictModeForAllResources
         *        A Boolean value that indicates whether to import all analyses and dashboards under strict or lenient
         *        mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strictModeForAllResources(Boolean strictModeForAllResources);
    }

    static final class BuilderImpl implements Builder {
        private Boolean strictModeForAllResources;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobOverrideValidationStrategy model) {
            strictModeForAllResources(model.strictModeForAllResources);
        }

        public final Boolean getStrictModeForAllResources() {
            return strictModeForAllResources;
        }

        public final void setStrictModeForAllResources(Boolean strictModeForAllResources) {
            this.strictModeForAllResources = strictModeForAllResources;
        }

        @Override
        public final Builder strictModeForAllResources(Boolean strictModeForAllResources) {
            this.strictModeForAllResources = strictModeForAllResources;
            return this;
        }

        @Override
        public AssetBundleImportJobOverrideValidationStrategy build() {
            return new AssetBundleImportJobOverrideValidationStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
