/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the file groups that are requested for the artifact generation in a
 * <code>StartDashboardSnapshotJob</code> API call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserSnapshotJobResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnonymousUserSnapshotJobResult.Builder, AnonymousUserSnapshotJobResult> {
    private static final SdkField<List<SnapshotJobResultFileGroup>> FILE_GROUPS_FIELD = SdkField
            .<List<SnapshotJobResultFileGroup>> builder(MarshallingType.LIST)
            .memberName("FileGroups")
            .getter(getter(AnonymousUserSnapshotJobResult::fileGroups))
            .setter(setter(Builder::fileGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotJobResultFileGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotJobResultFileGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SnapshotJobResultFileGroup> fileGroups;

    private AnonymousUserSnapshotJobResult(BuilderImpl builder) {
        this.fileGroups = builder.fileGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFileGroups() {
        return fileGroups != null && !(fileGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that are
     * requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these objects contain
     * the location where the snapshot artifacts are stored. If the job fails, the objects contain information about the
     * error that caused the job to fail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileGroups} method.
     * </p>
     * 
     * @return A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that are
     *         requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these objects
     *         contain the location where the snapshot artifacts are stored. If the job fails, the objects contain
     *         information about the error that caused the job to fail.
     */
    public final List<SnapshotJobResultFileGroup> fileGroups() {
        return fileGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFileGroups() ? fileGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserSnapshotJobResult)) {
            return false;
        }
        AnonymousUserSnapshotJobResult other = (AnonymousUserSnapshotJobResult) obj;
        return hasFileGroups() == other.hasFileGroups() && Objects.equals(fileGroups(), other.fileGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserSnapshotJobResult").add("FileGroups", hasFileGroups() ? fileGroups() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileGroups":
            return Optional.ofNullable(clazz.cast(fileGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileGroups", FILE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserSnapshotJobResult, T> g) {
        return obj -> g.apply((AnonymousUserSnapshotJobResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserSnapshotJobResult> {
        /**
         * <p>
         * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that are
         * requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these objects
         * contain the location where the snapshot artifacts are stored. If the job fails, the objects contain
         * information about the error that caused the job to fail.
         * </p>
         * 
         * @param fileGroups
         *        A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that
         *        are requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these
         *        objects contain the location where the snapshot artifacts are stored. If the job fails, the objects
         *        contain information about the error that caused the job to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileGroups(Collection<SnapshotJobResultFileGroup> fileGroups);

        /**
         * <p>
         * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that are
         * requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these objects
         * contain the location where the snapshot artifacts are stored. If the job fails, the objects contain
         * information about the error that caused the job to fail.
         * </p>
         * 
         * @param fileGroups
         *        A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that
         *        are requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these
         *        objects contain the location where the snapshot artifacts are stored. If the job fails, the objects
         *        contain information about the error that caused the job to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileGroups(SnapshotJobResultFileGroup... fileGroups);

        /**
         * <p>
         * A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that are
         * requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these objects
         * contain the location where the snapshot artifacts are stored. If the job fails, the objects contain
         * information about the error that caused the job to fail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultFileGroup.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultFileGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultFileGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #fileGroups(List<SnapshotJobResultFileGroup>)}.
         * 
         * @param fileGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultFileGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileGroups(java.util.Collection<SnapshotJobResultFileGroup>)
         */
        Builder fileGroups(Consumer<SnapshotJobResultFileGroup.Builder>... fileGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotJobResultFileGroup> fileGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserSnapshotJobResult model) {
            fileGroups(model.fileGroups);
        }

        public final List<SnapshotJobResultFileGroup.Builder> getFileGroups() {
            List<SnapshotJobResultFileGroup.Builder> result = SnapshotJobResultFileGroupListCopier.copyToBuilder(this.fileGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileGroups(Collection<SnapshotJobResultFileGroup.BuilderImpl> fileGroups) {
            this.fileGroups = SnapshotJobResultFileGroupListCopier.copyFromBuilder(fileGroups);
        }

        @Override
        public final Builder fileGroups(Collection<SnapshotJobResultFileGroup> fileGroups) {
            this.fileGroups = SnapshotJobResultFileGroupListCopier.copy(fileGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileGroups(SnapshotJobResultFileGroup... fileGroups) {
            fileGroups(Arrays.asList(fileGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileGroups(Consumer<SnapshotJobResultFileGroup.Builder>... fileGroups) {
            fileGroups(Stream.of(fileGroups).map(c -> SnapshotJobResultFileGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnonymousUserSnapshotJobResult build() {
            return new AnonymousUserSnapshotJobResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
