/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The experience that you are embedding. You can use this object to generate a url that embeds a visual into your
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserDashboardVisualEmbeddingConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AnonymousUserDashboardVisualEmbeddingConfiguration.Builder, AnonymousUserDashboardVisualEmbeddingConfiguration> {
    private static final SdkField<DashboardVisualId> INITIAL_DASHBOARD_VISUAL_ID_FIELD = SdkField
            .<DashboardVisualId> builder(MarshallingType.SDK_POJO).memberName("InitialDashboardVisualId")
            .getter(getter(AnonymousUserDashboardVisualEmbeddingConfiguration::initialDashboardVisualId))
            .setter(setter(Builder::initialDashboardVisualId)).constructor(DashboardVisualId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialDashboardVisualId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INITIAL_DASHBOARD_VISUAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DashboardVisualId initialDashboardVisualId;

    private AnonymousUserDashboardVisualEmbeddingConfiguration(BuilderImpl builder) {
        this.initialDashboardVisualId = builder.initialDashboardVisualId;
    }

    /**
     * <p>
     * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the URL
     * in response is accessed, Amazon QuickSight renders this visual.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     * <code>InvalidParameterValueException</code>.
     * </p>
     * 
     * @return The visual ID for the visual that you want the user to see. This ID is included in the output URL. When
     *         the URL in response is accessed, Amazon QuickSight renders this visual.</p>
     *         <p>
     *         The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     *         <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     *         <code>InvalidParameterValueException</code>.
     */
    public final DashboardVisualId initialDashboardVisualId() {
        return initialDashboardVisualId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialDashboardVisualId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserDashboardVisualEmbeddingConfiguration)) {
            return false;
        }
        AnonymousUserDashboardVisualEmbeddingConfiguration other = (AnonymousUserDashboardVisualEmbeddingConfiguration) obj;
        return Objects.equals(initialDashboardVisualId(), other.initialDashboardVisualId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserDashboardVisualEmbeddingConfiguration")
                .add("InitialDashboardVisualId", initialDashboardVisualId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialDashboardVisualId":
            return Optional.ofNullable(clazz.cast(initialDashboardVisualId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InitialDashboardVisualId", INITIAL_DASHBOARD_VISUAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserDashboardVisualEmbeddingConfiguration, T> g) {
        return obj -> g.apply((AnonymousUserDashboardVisualEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserDashboardVisualEmbeddingConfiguration> {
        /**
         * <p>
         * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the
         * URL in response is accessed, Amazon QuickSight renders this visual.
         * </p>
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
         * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
         * <code>InvalidParameterValueException</code>.
         * </p>
         * 
         * @param initialDashboardVisualId
         *        The visual ID for the visual that you want the user to see. This ID is included in the output URL.
         *        When the URL in response is accessed, Amazon QuickSight renders this visual.</p>
         *        <p>
         *        The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
         *        <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
         *        <code>InvalidParameterValueException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialDashboardVisualId(DashboardVisualId initialDashboardVisualId);

        /**
         * <p>
         * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the
         * URL in response is accessed, Amazon QuickSight renders this visual.
         * </p>
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
         * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
         * <code>InvalidParameterValueException</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardVisualId.Builder} avoiding the
         * need to create one manually via {@link DashboardVisualId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardVisualId.Builder#build()} is called immediately and its
         * result is passed to {@link #initialDashboardVisualId(DashboardVisualId)}.
         * 
         * @param initialDashboardVisualId
         *        a consumer that will call methods on {@link DashboardVisualId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialDashboardVisualId(DashboardVisualId)
         */
        default Builder initialDashboardVisualId(Consumer<DashboardVisualId.Builder> initialDashboardVisualId) {
            return initialDashboardVisualId(DashboardVisualId.builder().applyMutation(initialDashboardVisualId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DashboardVisualId initialDashboardVisualId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserDashboardVisualEmbeddingConfiguration model) {
            initialDashboardVisualId(model.initialDashboardVisualId);
        }

        public final DashboardVisualId.Builder getInitialDashboardVisualId() {
            return initialDashboardVisualId != null ? initialDashboardVisualId.toBuilder() : null;
        }

        public final void setInitialDashboardVisualId(DashboardVisualId.BuilderImpl initialDashboardVisualId) {
            this.initialDashboardVisualId = initialDashboardVisualId != null ? initialDashboardVisualId.build() : null;
        }

        @Override
        public final Builder initialDashboardVisualId(DashboardVisualId initialDashboardVisualId) {
            this.initialDashboardVisualId = initialDashboardVisualId;
            return this;
        }

        @Override
        public AnonymousUserDashboardVisualEmbeddingConfiguration build() {
            return new AnonymousUserDashboardVisualEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
