/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation function aggregates values from a dimension or measure.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationFunction.Builder, AggregationFunction> {
    private static final SdkField<NumericalAggregationFunction> NUMERICAL_AGGREGATION_FUNCTION_FIELD = SdkField
            .<NumericalAggregationFunction> builder(MarshallingType.SDK_POJO)
            .memberName("NumericalAggregationFunction")
            .getter(getter(AggregationFunction::numericalAggregationFunction))
            .setter(setter(Builder::numericalAggregationFunction))
            .constructor(NumericalAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericalAggregationFunction")
                    .build()).build();

    private static final SdkField<String> CATEGORICAL_AGGREGATION_FUNCTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CategoricalAggregationFunction")
            .getter(getter(AggregationFunction::categoricalAggregationFunctionAsString))
            .setter(setter(Builder::categoricalAggregationFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalAggregationFunction")
                    .build()).build();

    private static final SdkField<String> DATE_AGGREGATION_FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateAggregationFunction").getter(getter(AggregationFunction::dateAggregationFunctionAsString))
            .setter(setter(Builder::dateAggregationFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateAggregationFunction").build())
            .build();

    private static final SdkField<AttributeAggregationFunction> ATTRIBUTE_AGGREGATION_FUNCTION_FIELD = SdkField
            .<AttributeAggregationFunction> builder(MarshallingType.SDK_POJO)
            .memberName("AttributeAggregationFunction")
            .getter(getter(AggregationFunction::attributeAggregationFunction))
            .setter(setter(Builder::attributeAggregationFunction))
            .constructor(AttributeAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeAggregationFunction")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMERICAL_AGGREGATION_FUNCTION_FIELD, CATEGORICAL_AGGREGATION_FUNCTION_FIELD, DATE_AGGREGATION_FUNCTION_FIELD,
            ATTRIBUTE_AGGREGATION_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NumericalAggregationFunction numericalAggregationFunction;

    private final String categoricalAggregationFunction;

    private final String dateAggregationFunction;

    private final AttributeAggregationFunction attributeAggregationFunction;

    private AggregationFunction(BuilderImpl builder) {
        this.numericalAggregationFunction = builder.numericalAggregationFunction;
        this.categoricalAggregationFunction = builder.categoricalAggregationFunction;
        this.dateAggregationFunction = builder.dateAggregationFunction;
        this.attributeAggregationFunction = builder.attributeAggregationFunction;
    }

    /**
     * <p>
     * Aggregation for numerical values.
     * </p>
     * 
     * @return Aggregation for numerical values.
     */
    public final NumericalAggregationFunction numericalAggregationFunction() {
        return numericalAggregationFunction;
    }

    /**
     * <p>
     * Aggregation for categorical values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoricalAggregationFunction} will return {@link CategoricalAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #categoricalAggregationFunctionAsString}.
     * </p>
     * 
     * @return Aggregation for categorical values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     *         </p>
     *         </li>
     * @see CategoricalAggregationFunction
     */
    public final CategoricalAggregationFunction categoricalAggregationFunction() {
        return CategoricalAggregationFunction.fromValue(categoricalAggregationFunction);
    }

    /**
     * <p>
     * Aggregation for categorical values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoricalAggregationFunction} will return {@link CategoricalAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #categoricalAggregationFunctionAsString}.
     * </p>
     * 
     * @return Aggregation for categorical values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     *         </p>
     *         </li>
     * @see CategoricalAggregationFunction
     */
    public final String categoricalAggregationFunctionAsString() {
        return categoricalAggregationFunction;
    }

    /**
     * <p>
     * Aggregation for date values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIN</code>: Select the smallest date value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAX</code>: Select the largest date value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dateAggregationFunction} will return {@link DateAggregationFunction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dateAggregationFunctionAsString}.
     * </p>
     * 
     * @return Aggregation for date values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIN</code>: Select the smallest date value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAX</code>: Select the largest date value.
     *         </p>
     *         </li>
     * @see DateAggregationFunction
     */
    public final DateAggregationFunction dateAggregationFunction() {
        return DateAggregationFunction.fromValue(dateAggregationFunction);
    }

    /**
     * <p>
     * Aggregation for date values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIN</code>: Select the smallest date value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAX</code>: Select the largest date value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dateAggregationFunction} will return {@link DateAggregationFunction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dateAggregationFunctionAsString}.
     * </p>
     * 
     * @return Aggregation for date values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIN</code>: Select the smallest date value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAX</code>: Select the largest date value.
     *         </p>
     *         </li>
     * @see DateAggregationFunction
     */
    public final String dateAggregationFunctionAsString() {
        return dateAggregationFunction;
    }

    /**
     * <p>
     * Aggregation for attributes.
     * </p>
     * 
     * @return Aggregation for attributes.
     */
    public final AttributeAggregationFunction attributeAggregationFunction() {
        return attributeAggregationFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numericalAggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(categoricalAggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateAggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAggregationFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationFunction)) {
            return false;
        }
        AggregationFunction other = (AggregationFunction) obj;
        return Objects.equals(numericalAggregationFunction(), other.numericalAggregationFunction())
                && Objects.equals(categoricalAggregationFunctionAsString(), other.categoricalAggregationFunctionAsString())
                && Objects.equals(dateAggregationFunctionAsString(), other.dateAggregationFunctionAsString())
                && Objects.equals(attributeAggregationFunction(), other.attributeAggregationFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationFunction").add("NumericalAggregationFunction", numericalAggregationFunction())
                .add("CategoricalAggregationFunction", categoricalAggregationFunctionAsString())
                .add("DateAggregationFunction", dateAggregationFunctionAsString())
                .add("AttributeAggregationFunction", attributeAggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumericalAggregationFunction":
            return Optional.ofNullable(clazz.cast(numericalAggregationFunction()));
        case "CategoricalAggregationFunction":
            return Optional.ofNullable(clazz.cast(categoricalAggregationFunctionAsString()));
        case "DateAggregationFunction":
            return Optional.ofNullable(clazz.cast(dateAggregationFunctionAsString()));
        case "AttributeAggregationFunction":
            return Optional.ofNullable(clazz.cast(attributeAggregationFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumericalAggregationFunction", NUMERICAL_AGGREGATION_FUNCTION_FIELD);
        map.put("CategoricalAggregationFunction", CATEGORICAL_AGGREGATION_FUNCTION_FIELD);
        map.put("DateAggregationFunction", DATE_AGGREGATION_FUNCTION_FIELD);
        map.put("AttributeAggregationFunction", ATTRIBUTE_AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationFunction, T> g) {
        return obj -> g.apply((AggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationFunction> {
        /**
         * <p>
         * Aggregation for numerical values.
         * </p>
         * 
         * @param numericalAggregationFunction
         *        Aggregation for numerical values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericalAggregationFunction(NumericalAggregationFunction numericalAggregationFunction);

        /**
         * <p>
         * Aggregation for numerical values.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericalAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link NumericalAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericalAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #numericalAggregationFunction(NumericalAggregationFunction)}.
         * 
         * @param numericalAggregationFunction
         *        a consumer that will call methods on {@link NumericalAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericalAggregationFunction(NumericalAggregationFunction)
         */
        default Builder numericalAggregationFunction(Consumer<NumericalAggregationFunction.Builder> numericalAggregationFunction) {
            return numericalAggregationFunction(NumericalAggregationFunction.builder()
                    .applyMutation(numericalAggregationFunction).build());
        }

        /**
         * <p>
         * Aggregation for categorical values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param categoricalAggregationFunction
         *        Aggregation for categorical values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         *        </p>
         *        </li>
         * @see CategoricalAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoricalAggregationFunction
         */
        Builder categoricalAggregationFunction(String categoricalAggregationFunction);

        /**
         * <p>
         * Aggregation for categorical values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param categoricalAggregationFunction
         *        Aggregation for categorical values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         *        </p>
         *        </li>
         * @see CategoricalAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoricalAggregationFunction
         */
        Builder categoricalAggregationFunction(CategoricalAggregationFunction categoricalAggregationFunction);

        /**
         * <p>
         * Aggregation for date values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIN</code>: Select the smallest date value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAX</code>: Select the largest date value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dateAggregationFunction
         *        Aggregation for date values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIN</code>: Select the smallest date value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAX</code>: Select the largest date value.
         *        </p>
         *        </li>
         * @see DateAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DateAggregationFunction
         */
        Builder dateAggregationFunction(String dateAggregationFunction);

        /**
         * <p>
         * Aggregation for date values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIN</code>: Select the smallest date value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAX</code>: Select the largest date value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dateAggregationFunction
         *        Aggregation for date values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COUNT</code>: Aggregate by the total number of values, including duplicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIN</code>: Select the smallest date value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAX</code>: Select the largest date value.
         *        </p>
         *        </li>
         * @see DateAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DateAggregationFunction
         */
        Builder dateAggregationFunction(DateAggregationFunction dateAggregationFunction);

        /**
         * <p>
         * Aggregation for attributes.
         * </p>
         * 
         * @param attributeAggregationFunction
         *        Aggregation for attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeAggregationFunction(AttributeAggregationFunction attributeAggregationFunction);

        /**
         * <p>
         * Aggregation for attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link AttributeAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeAggregationFunction(AttributeAggregationFunction)}.
         * 
         * @param attributeAggregationFunction
         *        a consumer that will call methods on {@link AttributeAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeAggregationFunction(AttributeAggregationFunction)
         */
        default Builder attributeAggregationFunction(Consumer<AttributeAggregationFunction.Builder> attributeAggregationFunction) {
            return attributeAggregationFunction(AttributeAggregationFunction.builder()
                    .applyMutation(attributeAggregationFunction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumericalAggregationFunction numericalAggregationFunction;

        private String categoricalAggregationFunction;

        private String dateAggregationFunction;

        private AttributeAggregationFunction attributeAggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationFunction model) {
            numericalAggregationFunction(model.numericalAggregationFunction);
            categoricalAggregationFunction(model.categoricalAggregationFunction);
            dateAggregationFunction(model.dateAggregationFunction);
            attributeAggregationFunction(model.attributeAggregationFunction);
        }

        public final NumericalAggregationFunction.Builder getNumericalAggregationFunction() {
            return numericalAggregationFunction != null ? numericalAggregationFunction.toBuilder() : null;
        }

        public final void setNumericalAggregationFunction(NumericalAggregationFunction.BuilderImpl numericalAggregationFunction) {
            this.numericalAggregationFunction = numericalAggregationFunction != null ? numericalAggregationFunction.build()
                    : null;
        }

        @Override
        public final Builder numericalAggregationFunction(NumericalAggregationFunction numericalAggregationFunction) {
            this.numericalAggregationFunction = numericalAggregationFunction;
            return this;
        }

        public final String getCategoricalAggregationFunction() {
            return categoricalAggregationFunction;
        }

        public final void setCategoricalAggregationFunction(String categoricalAggregationFunction) {
            this.categoricalAggregationFunction = categoricalAggregationFunction;
        }

        @Override
        public final Builder categoricalAggregationFunction(String categoricalAggregationFunction) {
            this.categoricalAggregationFunction = categoricalAggregationFunction;
            return this;
        }

        @Override
        public final Builder categoricalAggregationFunction(CategoricalAggregationFunction categoricalAggregationFunction) {
            this.categoricalAggregationFunction(categoricalAggregationFunction == null ? null : categoricalAggregationFunction
                    .toString());
            return this;
        }

        public final String getDateAggregationFunction() {
            return dateAggregationFunction;
        }

        public final void setDateAggregationFunction(String dateAggregationFunction) {
            this.dateAggregationFunction = dateAggregationFunction;
        }

        @Override
        public final Builder dateAggregationFunction(String dateAggregationFunction) {
            this.dateAggregationFunction = dateAggregationFunction;
            return this;
        }

        @Override
        public final Builder dateAggregationFunction(DateAggregationFunction dateAggregationFunction) {
            this.dateAggregationFunction(dateAggregationFunction == null ? null : dateAggregationFunction.toString());
            return this;
        }

        public final AttributeAggregationFunction.Builder getAttributeAggregationFunction() {
            return attributeAggregationFunction != null ? attributeAggregationFunction.toBuilder() : null;
        }

        public final void setAttributeAggregationFunction(AttributeAggregationFunction.BuilderImpl attributeAggregationFunction) {
            this.attributeAggregationFunction = attributeAggregationFunction != null ? attributeAggregationFunction.build()
                    : null;
        }

        @Override
        public final Builder attributeAggregationFunction(AttributeAggregationFunction attributeAggregationFunction) {
            this.attributeAggregationFunction = attributeAggregationFunction;
            return this;
        }

        @Override
        public AggregationFunction build() {
            return new AggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
