/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UpdateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserName").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateUserRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(UpdateUserRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(UpdateUserRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(UpdateUserRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPermissionsName").getter(getter(UpdateUserRequest::customPermissionsName))
            .setter(setter(Builder::customPermissionsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build())
            .build();

    private static final SdkField<Boolean> UNAPPLY_CUSTOM_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UnapplyCustomPermissions").getter(getter(UpdateUserRequest::unapplyCustomPermissions))
            .setter(setter(Builder::unapplyCustomPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnapplyCustomPermissions").build())
            .build();

    private static final SdkField<String> EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginFederationProviderType")
            .getter(getter(UpdateUserRequest::externalLoginFederationProviderType))
            .setter(setter(Builder::externalLoginFederationProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ExternalLoginFederationProviderType").build()).build();

    private static final SdkField<String> CUSTOM_FEDERATION_PROVIDER_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomFederationProviderUrl")
            .getter(getter(UpdateUserRequest::customFederationProviderUrl))
            .setter(setter(Builder::customFederationProviderUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFederationProviderUrl")
                    .build()).build();

    private static final SdkField<String> EXTERNAL_LOGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginId").getter(getter(UpdateUserRequest::externalLoginId))
            .setter(setter(Builder::externalLoginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalLoginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, EMAIL_FIELD, ROLE_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD,
            UNAPPLY_CUSTOM_PERMISSIONS_FIELD, EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD,
            CUSTOM_FEDERATION_PROVIDER_URL_FIELD, EXTERNAL_LOGIN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userName;

    private final String awsAccountId;

    private final String namespace;

    private final String email;

    private final String role;

    private final String customPermissionsName;

    private final Boolean unapplyCustomPermissions;

    private final String externalLoginFederationProviderType;

    private final String customFederationProviderUrl;

    private final String externalLoginId;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.email = builder.email;
        this.role = builder.role;
        this.customPermissionsName = builder.customPermissionsName;
        this.unapplyCustomPermissions = builder.unapplyCustomPermissions;
        this.externalLoginFederationProviderType = builder.externalLoginFederationProviderType;
        this.customFederationProviderUrl = builder.customFederationProviderUrl;
        this.externalLoginId = builder.externalLoginId;
    }

    /**
     * <p>
     * The Amazon QuickSight user name that you want to update.
     * </p>
     * 
     * @return The Amazon QuickSight user name that you want to update.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web
     * Services account that contains your Amazon QuickSight account.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon
     *         Web Services account that contains your Amazon QuickSight account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace. Currently, you should set this to <code>default</code>.
     * </p>
     * 
     * @return The namespace. Currently, you should set this to <code>default</code>.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The email address of the user that you want to update.
     * </p>
     * 
     * @return The email address of the user that you want to update.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access
     * to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive summaries from
     * dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author
     * dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and
     * generate executive summaries from dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings.
     * Admin Pro users are billed at Author Pro pricing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with
     * permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role of the user. The role can be one of the following default security
     *         cohorts:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
     *         access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive
     *         summaries from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
     *         author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
     *         Q&amp;A, and generate executive summaries from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
     *         settings. Admin Pro users are billed at Author Pro pricing.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing
     *         with permissions.
     * @see UserRole
     */
    public final UserRole role() {
        return UserRole.fromValue(role);
    }

    /**
     * <p>
     * The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access
     * to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive summaries from
     * dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author
     * dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and
     * generate executive summaries from dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings.
     * Admin Pro users are billed at Author Pro pricing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with
     * permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role of the user. The role can be one of the following default security
     *         cohorts:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
     *         access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive
     *         summaries from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
     *         author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
     *         Q&amp;A, and generate executive summaries from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
     *         settings. Admin Pro users are billed at Author Pro pricing.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing
     *         with permissions.
     * @see UserRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.
     * Customized permissions allows you to control a user's access by restricting access the following operations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create and update data sources
     * </p>
     * </li>
     * <li>
     * <p>
     * Create and update datasets
     * </p>
     * </li>
     * <li>
     * <p>
     * Create and update email reports
     * </p>
     * </li>
     * <li>
     * <p>
     * Subscribe to email reports
     * </p>
     * </li>
     * </ul>
     * <p>
     * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the
     * profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the
     * <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user.
     * </p>
     * <p>
     * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions
     * typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon
     * QuickSight (admin, author, reader).
     * </p>
     * <p>
     * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
     * </p>
     * 
     * @return (Enterprise edition only) The name of the custom permissions profile that you want to assign to this
     *         user. Customized permissions allows you to control a user's access by restricting access the following
     *         operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Create and update data sources
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create and update datasets
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create and update email reports
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Subscribe to email reports
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         A set of custom permissions includes any combination of these restrictions. Currently, you need to create
     *         the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the
     *         <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight
     *         user.
     *         </p>
     *         <p>
     *         Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the
     *         permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts
     *         in Amazon QuickSight (admin, author, reader).
     *         </p>
     *         <p>
     *         This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
     */
    public final String customPermissionsName() {
        return customPermissionsName;
    }

    /**
     * <p>
     * A flag that you use to indicate that you want to remove all custom permissions from this user. Using this
     * parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter
     * defaults to NULL and it doesn't accept any other value.
     * </p>
     * 
     * @return A flag that you use to indicate that you want to remove all custom permissions from this user. Using this
     *         parameter resets the user to the state it was in before a custom permissions profile was applied. This
     *         parameter defaults to NULL and it doesn't accept any other value.
     */
    public final Boolean unapplyCustomPermissions() {
        return unapplyCustomPermissions;
    }

    /**
     * <p>
     * The type of supported external login provider that provides identity to let a user federate into Amazon
     * QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login
     * provider can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the
     * <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed
     * when the external provider is custom.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use
     * the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: This clears all the previously saved external login information for a user. Use the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code>
     * API operation to check the external login information.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of supported external login provider that provides identity to let a user federate into Amazon
     *         QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external
     *         login provider can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing
     *         the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is
     *         only needed when the external provider is custom.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code>
     *         type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: This clears all the previously saved external login information for a user. Use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code>
     *         API operation to check the external login information.
     *         </p>
     *         </li>
     */
    public final String externalLoginFederationProviderType() {
        return externalLoginFederationProviderType;
    }

    /**
     * <p>
     * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon
     * QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when
     * <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.
     * </p>
     * 
     * @return The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into
     *         Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only
     *         be used when <code>ExternalLoginFederationProviderType</code> parameter is set to
     *         <code>CUSTOM_OIDC</code>.
     */
    public final String customFederationProviderUrl() {
        return customFederationProviderUrl;
    }

    /**
     * <p>
     * The identity ID for a user in the external login provider.
     * </p>
     * 
     * @return The identity ID for a user in the external login provider.
     */
    public final String externalLoginId() {
        return externalLoginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissionsName());
        hashCode = 31 * hashCode + Objects.hashCode(unapplyCustomPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginFederationProviderType());
        hashCode = 31 * hashCode + Objects.hashCode(customFederationProviderUrl());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(email(), other.email())
                && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(customPermissionsName(), other.customPermissionsName())
                && Objects.equals(unapplyCustomPermissions(), other.unapplyCustomPermissions())
                && Objects.equals(externalLoginFederationProviderType(), other.externalLoginFederationProviderType())
                && Objects.equals(customFederationProviderUrl(), other.customFederationProviderUrl())
                && Objects.equals(externalLoginId(), other.externalLoginId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest").add("UserName", userName()).add("AwsAccountId", awsAccountId())
                .add("Namespace", namespace()).add("Email", email()).add("Role", roleAsString())
                .add("CustomPermissionsName", customPermissionsName())
                .add("UnapplyCustomPermissions", unapplyCustomPermissions())
                .add("ExternalLoginFederationProviderType", externalLoginFederationProviderType())
                .add("CustomFederationProviderUrl", customFederationProviderUrl()).add("ExternalLoginId", externalLoginId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "CustomPermissionsName":
            return Optional.ofNullable(clazz.cast(customPermissionsName()));
        case "UnapplyCustomPermissions":
            return Optional.ofNullable(clazz.cast(unapplyCustomPermissions()));
        case "ExternalLoginFederationProviderType":
            return Optional.ofNullable(clazz.cast(externalLoginFederationProviderType()));
        case "CustomFederationProviderUrl":
            return Optional.ofNullable(clazz.cast(customFederationProviderUrl()));
        case "ExternalLoginId":
            return Optional.ofNullable(clazz.cast(externalLoginId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("CustomPermissionsName", CUSTOM_PERMISSIONS_NAME_FIELD);
        map.put("UnapplyCustomPermissions", UNAPPLY_CUSTOM_PERMISSIONS_FIELD);
        map.put("ExternalLoginFederationProviderType", EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD);
        map.put("CustomFederationProviderUrl", CUSTOM_FEDERATION_PROVIDER_URL_FIELD);
        map.put("ExternalLoginId", EXTERNAL_LOGIN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The Amazon QuickSight user name that you want to update.
         * </p>
         * 
         * @param userName
         *        The Amazon QuickSight user name that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web
         * Services account that contains your Amazon QuickSight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
         *        Amazon Web Services account that contains your Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace. Currently, you should set this to <code>default</code>.
         * </p>
         * 
         * @param namespace
         *        The namespace. Currently, you should set this to <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The email address of the user that you want to update.
         * </p>
         * 
         * @param email
         *        The email address of the user that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
         * access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive
         * summaries from dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
         * author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
         * Q&amp;A, and generate executive summaries from dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
         * settings. Admin Pro users are billed at Author Pro pricing.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with
         * permissions.
         * </p>
         * 
         * @param role
         *        The Amazon QuickSight role of the user. The role can be one of the following default security
         *        cohorts:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros
         *        have access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate
         *        executive summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros
         *        can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics
         *        for Q&amp;A, and generate executive summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight
         *        administrative settings. Admin Pro users are billed at Author Pro pricing.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing
         *        with permissions.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(String role);

        /**
         * <p>
         * The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
         * access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive
         * summaries from dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
         * author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
         * Q&amp;A, and generate executive summaries from dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
         * settings. Admin Pro users are billed at Author Pro pricing.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with
         * permissions.
         * </p>
         * 
         * @param role
         *        The Amazon QuickSight role of the user. The role can be one of the following default security
         *        cohorts:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros
         *        have access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate
         *        executive summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros
         *        can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics
         *        for Q&amp;A, and generate executive summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight
         *        administrative settings. Admin Pro users are billed at Author Pro pricing.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing
         *        with permissions.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(UserRole role);

        /**
         * <p>
         * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.
         * Customized permissions allows you to control a user's access by restricting access the following operations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Create and update data sources
         * </p>
         * </li>
         * <li>
         * <p>
         * Create and update datasets
         * </p>
         * </li>
         * <li>
         * <p>
         * Create and update email reports
         * </p>
         * </li>
         * <li>
         * <p>
         * Subscribe to email reports
         * </p>
         * </li>
         * </ul>
         * <p>
         * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the
         * profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the
         * <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user.
         * </p>
         * <p>
         * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the
         * permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in
         * Amazon QuickSight (admin, author, reader).
         * </p>
         * <p>
         * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
         * </p>
         * 
         * @param customPermissionsName
         *        (Enterprise edition only) The name of the custom permissions profile that you want to assign to this
         *        user. Customized permissions allows you to control a user's access by restricting access the following
         *        operations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Create and update data sources
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create and update datasets
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create and update email reports
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Subscribe to email reports
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        A set of custom permissions includes any combination of these restrictions. Currently, you need to
         *        create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you
         *        use the <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon
         *        QuickSight user.
         *        </p>
         *        <p>
         *        Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the
         *        permissions typically granted by assigning Amazon QuickSight users to one of the default security
         *        cohorts in Amazon QuickSight (admin, author, reader).
         *        </p>
         *        <p>
         *        This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissionsName(String customPermissionsName);

        /**
         * <p>
         * A flag that you use to indicate that you want to remove all custom permissions from this user. Using this
         * parameter resets the user to the state it was in before a custom permissions profile was applied. This
         * parameter defaults to NULL and it doesn't accept any other value.
         * </p>
         * 
         * @param unapplyCustomPermissions
         *        A flag that you use to indicate that you want to remove all custom permissions from this user. Using
         *        this parameter resets the user to the state it was in before a custom permissions profile was applied.
         *        This parameter defaults to NULL and it doesn't accept any other value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unapplyCustomPermissions(Boolean unapplyCustomPermissions);

        /**
         * <p>
         * The type of supported external login provider that provides identity to let a user federate into Amazon
         * QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login
         * provider can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the
         * <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only
         * needed when the external provider is custom.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type,
         * use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: This clears all the previously saved external login information for a user. Use the
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code>
         * API operation to check the external login information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param externalLoginFederationProviderType
         *        The type of supported external login provider that provides identity to let a user federate into
         *        Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported
         *        external login provider can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When
         *        choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter
         *        which is only needed when the external provider is custom.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing
         *        <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide
         *        the custom OIDC provider URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: This clears all the previously saved external login information for a user. Use the
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code>
         *        API operation to check the external login information.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginFederationProviderType(String externalLoginFederationProviderType);

        /**
         * <p>
         * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into
         * Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be
         * used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.
         * </p>
         * 
         * @param customFederationProviderUrl
         *        The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate
         *        into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter
         *        should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to
         *        <code>CUSTOM_OIDC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFederationProviderUrl(String customFederationProviderUrl);

        /**
         * <p>
         * The identity ID for a user in the external login provider.
         * </p>
         * 
         * @param externalLoginId
         *        The identity ID for a user in the external login provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginId(String externalLoginId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String userName;

        private String awsAccountId;

        private String namespace;

        private String email;

        private String role;

        private String customPermissionsName;

        private Boolean unapplyCustomPermissions;

        private String externalLoginFederationProviderType;

        private String customFederationProviderUrl;

        private String externalLoginId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            userName(model.userName);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            email(model.email);
            role(model.role);
            customPermissionsName(model.customPermissionsName);
            unapplyCustomPermissions(model.unapplyCustomPermissions);
            externalLoginFederationProviderType(model.externalLoginFederationProviderType);
            customFederationProviderUrl(model.customFederationProviderUrl);
            externalLoginId(model.externalLoginId);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getCustomPermissionsName() {
            return customPermissionsName;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final Boolean getUnapplyCustomPermissions() {
            return unapplyCustomPermissions;
        }

        public final void setUnapplyCustomPermissions(Boolean unapplyCustomPermissions) {
            this.unapplyCustomPermissions = unapplyCustomPermissions;
        }

        @Override
        public final Builder unapplyCustomPermissions(Boolean unapplyCustomPermissions) {
            this.unapplyCustomPermissions = unapplyCustomPermissions;
            return this;
        }

        public final String getExternalLoginFederationProviderType() {
            return externalLoginFederationProviderType;
        }

        public final void setExternalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
        }

        @Override
        public final Builder externalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
            return this;
        }

        public final String getCustomFederationProviderUrl() {
            return customFederationProviderUrl;
        }

        public final void setCustomFederationProviderUrl(String customFederationProviderUrl) {
            this.customFederationProviderUrl = customFederationProviderUrl;
        }

        @Override
        public final Builder customFederationProviderUrl(String customFederationProviderUrl) {
            this.customFederationProviderUrl = customFederationProviderUrl;
            return this;
        }

        public final String getExternalLoginId() {
            return externalLoginId;
        }

        public final void setExternalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
        }

        @Override
        public final Builder externalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
