/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that removes tags associated with a column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UntagColumnOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<UntagColumnOperation.Builder, UntagColumnOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(UntagColumnOperation::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<List<String>> TAG_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagNames")
            .getter(getter(UntagColumnOperation::tagNamesAsStrings))
            .setter(setter(Builder::tagNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            TAG_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final List<String> tagNames;

    private UntagColumnOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.tagNames = builder.tagNames;
    }

    /**
     * <p>
     * The column that this operation acts on.
     * </p>
     * 
     * @return The column that this operation acts on.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The column tags to remove from this column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagNames} method.
     * </p>
     * 
     * @return The column tags to remove from this column.
     */
    public final List<ColumnTagName> tagNames() {
        return ColumnTagNamesCopier.copyStringToEnum(tagNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the TagNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagNames() {
        return tagNames != null && !(tagNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column tags to remove from this column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagNames} method.
     * </p>
     * 
     * @return The column tags to remove from this column.
     */
    public final List<String> tagNamesAsStrings() {
        return tagNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagNames() ? tagNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagColumnOperation)) {
            return false;
        }
        UntagColumnOperation other = (UntagColumnOperation) obj;
        return Objects.equals(columnName(), other.columnName()) && hasTagNames() == other.hasTagNames()
                && Objects.equals(tagNamesAsStrings(), other.tagNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UntagColumnOperation").add("ColumnName", columnName())
                .add("TagNames", hasTagNames() ? tagNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "TagNames":
            return Optional.ofNullable(clazz.cast(tagNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("TagNames", TAG_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UntagColumnOperation, T> g) {
        return obj -> g.apply((UntagColumnOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UntagColumnOperation> {
        /**
         * <p>
         * The column that this operation acts on.
         * </p>
         * 
         * @param columnName
         *        The column that this operation acts on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The column tags to remove from this column.
         * </p>
         * 
         * @param tagNames
         *        The column tags to remove from this column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagNamesWithStrings(Collection<String> tagNames);

        /**
         * <p>
         * The column tags to remove from this column.
         * </p>
         * 
         * @param tagNames
         *        The column tags to remove from this column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagNamesWithStrings(String... tagNames);

        /**
         * <p>
         * The column tags to remove from this column.
         * </p>
         * 
         * @param tagNames
         *        The column tags to remove from this column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagNames(Collection<ColumnTagName> tagNames);

        /**
         * <p>
         * The column tags to remove from this column.
         * </p>
         * 
         * @param tagNames
         *        The column tags to remove from this column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagNames(ColumnTagName... tagNames);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private List<String> tagNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagColumnOperation model) {
            columnName(model.columnName);
            tagNamesWithStrings(model.tagNames);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Collection<String> getTagNames() {
            if (tagNames instanceof SdkAutoConstructList) {
                return null;
            }
            return tagNames;
        }

        public final void setTagNames(Collection<String> tagNames) {
            this.tagNames = ColumnTagNamesCopier.copy(tagNames);
        }

        @Override
        public final Builder tagNamesWithStrings(Collection<String> tagNames) {
            this.tagNames = ColumnTagNamesCopier.copy(tagNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagNamesWithStrings(String... tagNames) {
            tagNamesWithStrings(Arrays.asList(tagNames));
            return this;
        }

        @Override
        public final Builder tagNames(Collection<ColumnTagName> tagNames) {
            this.tagNames = ColumnTagNamesCopier.copyEnumToString(tagNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagNames(ColumnTagName... tagNames) {
            tagNames(Arrays.asList(tagNames));
            return this;
        }

        @Override
        public UntagColumnOperation build() {
            return new UntagColumnOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
