/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregated field wells of a tree map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TreeMapAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<TreeMapAggregatedFieldWells.Builder, TreeMapAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> GROUPS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(TreeMapAggregatedFieldWells::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> SIZES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Sizes")
            .getter(getter(TreeMapAggregatedFieldWells::sizes))
            .setter(setter(Builder::sizes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sizes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> COLORS_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Colors")
            .getter(getter(TreeMapAggregatedFieldWells::colors))
            .setter(setter(Builder::colors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, SIZES_FIELD,
            COLORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> groups;

    private final List<MeasureField> sizes;

    private final List<MeasureField> colors;

    private TreeMapAggregatedFieldWells(BuilderImpl builder) {
        this.groups = builder.groups;
        this.sizes = builder.sizes;
        this.colors = builder.colors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group by field well of a tree map. Values are grouped based on group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The group by field well of a tree map. Values are grouped based on group by fields.
     */
    public final List<DimensionField> groups() {
        return groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sizes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSizes() {
        return sizes != null && !(sizes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The size field well of a tree map. Values are aggregated based on group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSizes} method.
     * </p>
     * 
     * @return The size field well of a tree map. Values are aggregated based on group by fields.
     */
    public final List<MeasureField> sizes() {
        return sizes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Colors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColors() {
        return colors != null && !(colors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The color field well of a tree map. Values are grouped by aggregations based on group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColors} method.
     * </p>
     * 
     * @return The color field well of a tree map. Values are grouped by aggregations based on group by fields.
     */
    public final List<MeasureField> colors() {
        return colors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSizes() ? sizes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColors() ? colors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreeMapAggregatedFieldWells)) {
            return false;
        }
        TreeMapAggregatedFieldWells other = (TreeMapAggregatedFieldWells) obj;
        return hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups()) && hasSizes() == other.hasSizes()
                && Objects.equals(sizes(), other.sizes()) && hasColors() == other.hasColors()
                && Objects.equals(colors(), other.colors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TreeMapAggregatedFieldWells").add("Groups", hasGroups() ? groups() : null)
                .add("Sizes", hasSizes() ? sizes() : null).add("Colors", hasColors() ? colors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Sizes":
            return Optional.ofNullable(clazz.cast(sizes()));
        case "Colors":
            return Optional.ofNullable(clazz.cast(colors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Groups", GROUPS_FIELD);
        map.put("Sizes", SIZES_FIELD);
        map.put("Colors", COLORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TreeMapAggregatedFieldWells, T> g) {
        return obj -> g.apply((TreeMapAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TreeMapAggregatedFieldWells> {
        /**
         * <p>
         * The group by field well of a tree map. Values are grouped based on group by fields.
         * </p>
         * 
         * @param groups
         *        The group by field well of a tree map. Values are grouped based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<DimensionField> groups);

        /**
         * <p>
         * The group by field well of a tree map. Values are grouped based on group by fields.
         * </p>
         * 
         * @param groups
         *        The group by field well of a tree map. Values are grouped based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(DimensionField... groups);

        /**
         * <p>
         * The group by field well of a tree map. Values are grouped based on group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #groups(List<DimensionField>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<DimensionField>)
         */
        Builder groups(Consumer<DimensionField.Builder>... groups);

        /**
         * <p>
         * The size field well of a tree map. Values are aggregated based on group by fields.
         * </p>
         * 
         * @param sizes
         *        The size field well of a tree map. Values are aggregated based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizes(Collection<MeasureField> sizes);

        /**
         * <p>
         * The size field well of a tree map. Values are aggregated based on group by fields.
         * </p>
         * 
         * @param sizes
         *        The size field well of a tree map. Values are aggregated based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizes(MeasureField... sizes);

        /**
         * <p>
         * The size field well of a tree map. Values are aggregated based on group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #sizes(List<MeasureField>)}.
         * 
         * @param sizes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizes(java.util.Collection<MeasureField>)
         */
        Builder sizes(Consumer<MeasureField.Builder>... sizes);

        /**
         * <p>
         * The color field well of a tree map. Values are grouped by aggregations based on group by fields.
         * </p>
         * 
         * @param colors
         *        The color field well of a tree map. Values are grouped by aggregations based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(Collection<MeasureField> colors);

        /**
         * <p>
         * The color field well of a tree map. Values are grouped by aggregations based on group by fields.
         * </p>
         * 
         * @param colors
         *        The color field well of a tree map. Values are grouped by aggregations based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(MeasureField... colors);

        /**
         * <p>
         * The color field well of a tree map. Values are grouped by aggregations based on group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #colors(List<MeasureField>)}.
         * 
         * @param colors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colors(java.util.Collection<MeasureField>)
         */
        Builder colors(Consumer<MeasureField.Builder>... colors);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> groups = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> sizes = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> colors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TreeMapAggregatedFieldWells model) {
            groups(model.groups);
            sizes(model.sizes);
            colors(model.colors);
        }

        public final List<DimensionField.Builder> getGroups() {
            List<DimensionField.Builder> result = TreeMapDimensionFieldListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<DimensionField.BuilderImpl> groups) {
            this.groups = TreeMapDimensionFieldListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<DimensionField> groups) {
            this.groups = TreeMapDimensionFieldListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(DimensionField... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<DimensionField.Builder>... groups) {
            groups(Stream.of(groups).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getSizes() {
            List<MeasureField.Builder> result = TreeMapMeasureFieldListCopier.copyToBuilder(this.sizes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSizes(Collection<MeasureField.BuilderImpl> sizes) {
            this.sizes = TreeMapMeasureFieldListCopier.copyFromBuilder(sizes);
        }

        @Override
        public final Builder sizes(Collection<MeasureField> sizes) {
            this.sizes = TreeMapMeasureFieldListCopier.copy(sizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(MeasureField... sizes) {
            sizes(Arrays.asList(sizes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(Consumer<MeasureField.Builder>... sizes) {
            sizes(Stream.of(sizes).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getColors() {
            List<MeasureField.Builder> result = TreeMapMeasureFieldListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<MeasureField.BuilderImpl> colors) {
            this.colors = TreeMapMeasureFieldListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<MeasureField> colors) {
            this.colors = TreeMapMeasureFieldListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(MeasureField... colors) {
            colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<MeasureField.Builder>... colors) {
            colors(Stream.of(colors).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TreeMapAggregatedFieldWells build() {
            return new TreeMapAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
