/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicIR</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicIR implements SdkPojo, Serializable, ToCopyableBuilder<TopicIR.Builder, TopicIR> {
    private static final SdkField<List<TopicIRMetric>> METRICS_FIELD = SdkField
            .<List<TopicIRMetric>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(TopicIR::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicIRMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicIRMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TopicIRGroupBy>> GROUP_BY_LIST_FIELD = SdkField
            .<List<TopicIRGroupBy>> builder(MarshallingType.LIST)
            .memberName("GroupByList")
            .getter(getter(TopicIR::groupByList))
            .setter(setter(Builder::groupByList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicIRGroupBy> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicIRGroupBy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<TopicIRFilterOption>>> FILTERS_FIELD = SdkField
            .<List<List<TopicIRFilterOption>>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(TopicIR::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<TopicIRFilterOption>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<TopicIRFilterOption> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(TopicIRFilterOption::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<TopicSortClause> SORT_FIELD = SdkField.<TopicSortClause> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(TopicIR::sort)).setter(setter(Builder::sort)).constructor(TopicSortClause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<TopicIRContributionAnalysis> CONTRIBUTION_ANALYSIS_FIELD = SdkField
            .<TopicIRContributionAnalysis> builder(MarshallingType.SDK_POJO).memberName("ContributionAnalysis")
            .getter(getter(TopicIR::contributionAnalysis)).setter(setter(Builder::contributionAnalysis))
            .constructor(TopicIRContributionAnalysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysis").build())
            .build();

    private static final SdkField<VisualOptions> VISUAL_FIELD = SdkField.<VisualOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Visual").getter(getter(TopicIR::visual)).setter(setter(Builder::visual))
            .constructor(VisualOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visual").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            GROUP_BY_LIST_FIELD, FILTERS_FIELD, SORT_FIELD, CONTRIBUTION_ANALYSIS_FIELD, VISUAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TopicIRMetric> metrics;

    private final List<TopicIRGroupBy> groupByList;

    private final List<List<TopicIRFilterOption>> filters;

    private final TopicSortClause sort;

    private final TopicIRContributionAnalysis contributionAnalysis;

    private final VisualOptions visual;

    private TopicIR(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.groupByList = builder.groupByList;
        this.filters = builder.filters;
        this.sort = builder.sort;
        this.contributionAnalysis = builder.contributionAnalysis;
        this.visual = builder.visual;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics for the <code>TopicIR</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics for the <code>TopicIR</code>.
     */
    public final List<TopicIRMetric> metrics() {
        return metrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByList() {
        return groupByList != null && !(groupByList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The GroupBy list for the <code>TopicIR</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByList} method.
     * </p>
     * 
     * @return The GroupBy list for the <code>TopicIR</code>.
     */
    public final List<TopicIRGroupBy> groupByList() {
        return groupByList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters for the <code>TopicIR</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters for the <code>TopicIR</code>.
     */
    public final List<List<TopicIRFilterOption>> filters() {
        return filters;
    }

    /**
     * <p>
     * The sort for the <code>TopicIR</code>.
     * </p>
     * 
     * @return The sort for the <code>TopicIR</code>.
     */
    public final TopicSortClause sort() {
        return sort;
    }

    /**
     * <p>
     * The contribution analysis for the <code>TopicIR</code>.
     * </p>
     * 
     * @return The contribution analysis for the <code>TopicIR</code>.
     */
    public final TopicIRContributionAnalysis contributionAnalysis() {
        return contributionAnalysis;
    }

    /**
     * <p>
     * The visual for the <code>TopicIR</code>.
     * </p>
     * 
     * @return The visual for the <code>TopicIR</code>.
     */
    public final VisualOptions visual() {
        return visual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByList() ? groupByList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(contributionAnalysis());
        hashCode = 31 * hashCode + Objects.hashCode(visual());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIR)) {
            return false;
        }
        TopicIR other = (TopicIR) obj;
        return hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && hasGroupByList() == other.hasGroupByList() && Objects.equals(groupByList(), other.groupByList())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(sort(), other.sort()) && Objects.equals(contributionAnalysis(), other.contributionAnalysis())
                && Objects.equals(visual(), other.visual());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicIR").add("Metrics", hasMetrics() ? metrics() : null)
                .add("GroupByList", hasGroupByList() ? groupByList() : null).add("Filters", hasFilters() ? filters() : null)
                .add("Sort", sort()).add("ContributionAnalysis", contributionAnalysis()).add("Visual", visual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "GroupByList":
            return Optional.ofNullable(clazz.cast(groupByList()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "ContributionAnalysis":
            return Optional.ofNullable(clazz.cast(contributionAnalysis()));
        case "Visual":
            return Optional.ofNullable(clazz.cast(visual()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metrics", METRICS_FIELD);
        map.put("GroupByList", GROUP_BY_LIST_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("ContributionAnalysis", CONTRIBUTION_ANALYSIS_FIELD);
        map.put("Visual", VISUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIR, T> g) {
        return obj -> g.apply((TopicIR) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicIR> {
        /**
         * <p>
         * The metrics for the <code>TopicIR</code>.
         * </p>
         * 
         * @param metrics
         *        The metrics for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<TopicIRMetric> metrics);

        /**
         * <p>
         * The metrics for the <code>TopicIR</code>.
         * </p>
         * 
         * @param metrics
         *        The metrics for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(TopicIRMetric... metrics);

        /**
         * <p>
         * The metrics for the <code>TopicIR</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicIRMetric.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TopicIRMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicIRMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #metrics(List<TopicIRMetric>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicIRMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<TopicIRMetric>)
         */
        Builder metrics(Consumer<TopicIRMetric.Builder>... metrics);

        /**
         * <p>
         * The GroupBy list for the <code>TopicIR</code>.
         * </p>
         * 
         * @param groupByList
         *        The GroupBy list for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByList(Collection<TopicIRGroupBy> groupByList);

        /**
         * <p>
         * The GroupBy list for the <code>TopicIR</code>.
         * </p>
         * 
         * @param groupByList
         *        The GroupBy list for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByList(TopicIRGroupBy... groupByList);

        /**
         * <p>
         * The GroupBy list for the <code>TopicIR</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicIRGroupBy.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TopicIRGroupBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicIRGroupBy.Builder#build()} is called immediately
         * and its result is passed to {@link #groupByList(List<TopicIRGroupBy>)}.
         * 
         * @param groupByList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicIRGroupBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupByList(java.util.Collection<TopicIRGroupBy>)
         */
        Builder groupByList(Consumer<TopicIRGroupBy.Builder>... groupByList);

        /**
         * <p>
         * The filters for the <code>TopicIR</code>.
         * </p>
         * 
         * @param filters
         *        The filters for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<? extends Collection<TopicIRFilterOption>> filters);

        /**
         * <p>
         * The filters for the <code>TopicIR</code>.
         * </p>
         * 
         * @param filters
         *        The filters for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<TopicIRFilterOption>... filters);

        /**
         * <p>
         * The sort for the <code>TopicIR</code>.
         * </p>
         * 
         * @param sort
         *        The sort for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(TopicSortClause sort);

        /**
         * <p>
         * The sort for the <code>TopicIR</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicSortClause.Builder} avoiding the
         * need to create one manually via {@link TopicSortClause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicSortClause.Builder#build()} is called immediately and its
         * result is passed to {@link #sort(TopicSortClause)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link TopicSortClause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(TopicSortClause)
         */
        default Builder sort(Consumer<TopicSortClause.Builder> sort) {
            return sort(TopicSortClause.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The contribution analysis for the <code>TopicIR</code>.
         * </p>
         * 
         * @param contributionAnalysis
         *        The contribution analysis for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysis(TopicIRContributionAnalysis contributionAnalysis);

        /**
         * <p>
         * The contribution analysis for the <code>TopicIR</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicIRContributionAnalysis.Builder}
         * avoiding the need to create one manually via {@link TopicIRContributionAnalysis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicIRContributionAnalysis.Builder#build()} is called
         * immediately and its result is passed to {@link #contributionAnalysis(TopicIRContributionAnalysis)}.
         * 
         * @param contributionAnalysis
         *        a consumer that will call methods on {@link TopicIRContributionAnalysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributionAnalysis(TopicIRContributionAnalysis)
         */
        default Builder contributionAnalysis(Consumer<TopicIRContributionAnalysis.Builder> contributionAnalysis) {
            return contributionAnalysis(TopicIRContributionAnalysis.builder().applyMutation(contributionAnalysis).build());
        }

        /**
         * <p>
         * The visual for the <code>TopicIR</code>.
         * </p>
         * 
         * @param visual
         *        The visual for the <code>TopicIR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visual(VisualOptions visual);

        /**
         * <p>
         * The visual for the <code>TopicIR</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualOptions.Builder} avoiding the need
         * to create one manually via {@link VisualOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #visual(VisualOptions)}.
         * 
         * @param visual
         *        a consumer that will call methods on {@link VisualOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visual(VisualOptions)
         */
        default Builder visual(Consumer<VisualOptions.Builder> visual) {
            return visual(VisualOptions.builder().applyMutation(visual).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<TopicIRMetric> metrics = DefaultSdkAutoConstructList.getInstance();

        private List<TopicIRGroupBy> groupByList = DefaultSdkAutoConstructList.getInstance();

        private List<List<TopicIRFilterOption>> filters = DefaultSdkAutoConstructList.getInstance();

        private TopicSortClause sort;

        private TopicIRContributionAnalysis contributionAnalysis;

        private VisualOptions visual;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIR model) {
            metrics(model.metrics);
            groupByList(model.groupByList);
            filters(model.filters);
            sort(model.sort);
            contributionAnalysis(model.contributionAnalysis);
            visual(model.visual);
        }

        public final List<TopicIRMetric.Builder> getMetrics() {
            List<TopicIRMetric.Builder> result = TopicIRMetricListCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<TopicIRMetric.BuilderImpl> metrics) {
            this.metrics = TopicIRMetricListCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<TopicIRMetric> metrics) {
            this.metrics = TopicIRMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(TopicIRMetric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<TopicIRMetric.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> TopicIRMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicIRGroupBy.Builder> getGroupByList() {
            List<TopicIRGroupBy.Builder> result = TopicIRGroupByListCopier.copyToBuilder(this.groupByList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByList(Collection<TopicIRGroupBy.BuilderImpl> groupByList) {
            this.groupByList = TopicIRGroupByListCopier.copyFromBuilder(groupByList);
        }

        @Override
        public final Builder groupByList(Collection<TopicIRGroupBy> groupByList) {
            this.groupByList = TopicIRGroupByListCopier.copy(groupByList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByList(TopicIRGroupBy... groupByList) {
            groupByList(Arrays.asList(groupByList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByList(Consumer<TopicIRGroupBy.Builder>... groupByList) {
            groupByList(Stream.of(groupByList).map(c -> TopicIRGroupBy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<List<TopicIRFilterOption.Builder>> getFilters() {
            List<List<TopicIRFilterOption.Builder>> result = TopicIRFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<? extends Collection<TopicIRFilterOption.BuilderImpl>> filters) {
            this.filters = TopicIRFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<? extends Collection<TopicIRFilterOption>> filters) {
            this.filters = TopicIRFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Collection<TopicIRFilterOption>... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final TopicSortClause.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(TopicSortClause.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(TopicSortClause sort) {
            this.sort = sort;
            return this;
        }

        public final TopicIRContributionAnalysis.Builder getContributionAnalysis() {
            return contributionAnalysis != null ? contributionAnalysis.toBuilder() : null;
        }

        public final void setContributionAnalysis(TopicIRContributionAnalysis.BuilderImpl contributionAnalysis) {
            this.contributionAnalysis = contributionAnalysis != null ? contributionAnalysis.build() : null;
        }

        @Override
        public final Builder contributionAnalysis(TopicIRContributionAnalysis contributionAnalysis) {
            this.contributionAnalysis = contributionAnalysis;
            return this;
        }

        public final VisualOptions.Builder getVisual() {
            return visual != null ? visual.toBuilder() : null;
        }

        public final void setVisual(VisualOptions.BuilderImpl visual) {
            this.visual = visual != null ? visual.build() : null;
        }

        @Override
        public final Builder visual(VisualOptions visual) {
            this.visual = visual;
            return this;
        }

        @Override
        public TopicIR build() {
            return new TopicIR(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
