/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SeriesItemListCopier {
    static List<SeriesItem> copy(Collection<? extends SeriesItem> seriesItemListParam) {
        List<SeriesItem> list;
        if (seriesItemListParam == null || seriesItemListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SeriesItem> modifiableList = new ArrayList<>(seriesItemListParam.size());
            seriesItemListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SeriesItem> copyFromBuilder(Collection<? extends SeriesItem.Builder> seriesItemListParam) {
        List<SeriesItem> list;
        if (seriesItemListParam == null || seriesItemListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SeriesItem> modifiableList = new ArrayList<>(seriesItemListParam.size());
            seriesItemListParam.forEach(entry -> {
                SeriesItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SeriesItem.Builder> copyToBuilder(Collection<? extends SeriesItem> seriesItemListParam) {
        List<SeriesItem.Builder> list;
        if (seriesItemListParam == null || seriesItemListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SeriesItem.Builder> modifiableList = new ArrayList<>(seriesItemListParam.size());
            seriesItemListParam.forEach(entry -> {
                SeriesItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
