/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The series item configuration of a line chart.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeriesItem implements SdkPojo, Serializable, ToCopyableBuilder<SeriesItem.Builder, SeriesItem> {
    private static final SdkField<FieldSeriesItem> FIELD_SERIES_ITEM_FIELD = SdkField
            .<FieldSeriesItem> builder(MarshallingType.SDK_POJO).memberName("FieldSeriesItem")
            .getter(getter(SeriesItem::fieldSeriesItem)).setter(setter(Builder::fieldSeriesItem))
            .constructor(FieldSeriesItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSeriesItem").build()).build();

    private static final SdkField<DataFieldSeriesItem> DATA_FIELD_SERIES_ITEM_FIELD = SdkField
            .<DataFieldSeriesItem> builder(MarshallingType.SDK_POJO).memberName("DataFieldSeriesItem")
            .getter(getter(SeriesItem::dataFieldSeriesItem)).setter(setter(Builder::dataFieldSeriesItem))
            .constructor(DataFieldSeriesItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFieldSeriesItem").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_SERIES_ITEM_FIELD,
            DATA_FIELD_SERIES_ITEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldSeriesItem fieldSeriesItem;

    private final DataFieldSeriesItem dataFieldSeriesItem;

    private SeriesItem(BuilderImpl builder) {
        this.fieldSeriesItem = builder.fieldSeriesItem;
        this.dataFieldSeriesItem = builder.dataFieldSeriesItem;
    }

    /**
     * <p>
     * The field series item configuration of a line chart.
     * </p>
     * 
     * @return The field series item configuration of a line chart.
     */
    public final FieldSeriesItem fieldSeriesItem() {
        return fieldSeriesItem;
    }

    /**
     * <p>
     * The data field series item configuration of a line chart.
     * </p>
     * 
     * @return The data field series item configuration of a line chart.
     */
    public final DataFieldSeriesItem dataFieldSeriesItem() {
        return dataFieldSeriesItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldSeriesItem());
        hashCode = 31 * hashCode + Objects.hashCode(dataFieldSeriesItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeriesItem)) {
            return false;
        }
        SeriesItem other = (SeriesItem) obj;
        return Objects.equals(fieldSeriesItem(), other.fieldSeriesItem())
                && Objects.equals(dataFieldSeriesItem(), other.dataFieldSeriesItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SeriesItem").add("FieldSeriesItem", fieldSeriesItem())
                .add("DataFieldSeriesItem", dataFieldSeriesItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldSeriesItem":
            return Optional.ofNullable(clazz.cast(fieldSeriesItem()));
        case "DataFieldSeriesItem":
            return Optional.ofNullable(clazz.cast(dataFieldSeriesItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldSeriesItem", FIELD_SERIES_ITEM_FIELD);
        map.put("DataFieldSeriesItem", DATA_FIELD_SERIES_ITEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SeriesItem, T> g) {
        return obj -> g.apply((SeriesItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeriesItem> {
        /**
         * <p>
         * The field series item configuration of a line chart.
         * </p>
         * 
         * @param fieldSeriesItem
         *        The field series item configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSeriesItem(FieldSeriesItem fieldSeriesItem);

        /**
         * <p>
         * The field series item configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldSeriesItem.Builder} avoiding the
         * need to create one manually via {@link FieldSeriesItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldSeriesItem.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldSeriesItem(FieldSeriesItem)}.
         * 
         * @param fieldSeriesItem
         *        a consumer that will call methods on {@link FieldSeriesItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldSeriesItem(FieldSeriesItem)
         */
        default Builder fieldSeriesItem(Consumer<FieldSeriesItem.Builder> fieldSeriesItem) {
            return fieldSeriesItem(FieldSeriesItem.builder().applyMutation(fieldSeriesItem).build());
        }

        /**
         * <p>
         * The data field series item configuration of a line chart.
         * </p>
         * 
         * @param dataFieldSeriesItem
         *        The data field series item configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFieldSeriesItem(DataFieldSeriesItem dataFieldSeriesItem);

        /**
         * <p>
         * The data field series item configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataFieldSeriesItem.Builder} avoiding the
         * need to create one manually via {@link DataFieldSeriesItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataFieldSeriesItem.Builder#build()} is called immediately and
         * its result is passed to {@link #dataFieldSeriesItem(DataFieldSeriesItem)}.
         * 
         * @param dataFieldSeriesItem
         *        a consumer that will call methods on {@link DataFieldSeriesItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataFieldSeriesItem(DataFieldSeriesItem)
         */
        default Builder dataFieldSeriesItem(Consumer<DataFieldSeriesItem.Builder> dataFieldSeriesItem) {
            return dataFieldSeriesItem(DataFieldSeriesItem.builder().applyMutation(dataFieldSeriesItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldSeriesItem fieldSeriesItem;

        private DataFieldSeriesItem dataFieldSeriesItem;

        private BuilderImpl() {
        }

        private BuilderImpl(SeriesItem model) {
            fieldSeriesItem(model.fieldSeriesItem);
            dataFieldSeriesItem(model.dataFieldSeriesItem);
        }

        public final FieldSeriesItem.Builder getFieldSeriesItem() {
            return fieldSeriesItem != null ? fieldSeriesItem.toBuilder() : null;
        }

        public final void setFieldSeriesItem(FieldSeriesItem.BuilderImpl fieldSeriesItem) {
            this.fieldSeriesItem = fieldSeriesItem != null ? fieldSeriesItem.build() : null;
        }

        @Override
        public final Builder fieldSeriesItem(FieldSeriesItem fieldSeriesItem) {
            this.fieldSeriesItem = fieldSeriesItem;
            return this;
        }

        public final DataFieldSeriesItem.Builder getDataFieldSeriesItem() {
            return dataFieldSeriesItem != null ? dataFieldSeriesItem.toBuilder() : null;
        }

        public final void setDataFieldSeriesItem(DataFieldSeriesItem.BuilderImpl dataFieldSeriesItem) {
            this.dataFieldSeriesItem = dataFieldSeriesItem != null ? dataFieldSeriesItem.build() : null;
        }

        @Override
        public final Builder dataFieldSeriesItem(DataFieldSeriesItem dataFieldSeriesItem) {
            this.dataFieldSeriesItem = dataFieldSeriesItem;
            return this;
        }

        @Override
        public SeriesItem build() {
            return new SeriesItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
