/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data path options for the pivot table field options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableDataPathOption implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableDataPathOption.Builder, PivotTableDataPathOption> {
    private static final SdkField<List<DataPathValue>> DATA_PATH_LIST_FIELD = SdkField
            .<List<DataPathValue>> builder(MarshallingType.LIST)
            .memberName("DataPathList")
            .getter(getter(PivotTableDataPathOption::dataPathList))
            .setter(setter(Builder::dataPathList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPathList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataPathValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataPathValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Width")
            .getter(getter(PivotTableDataPathOption::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PATH_LIST_FIELD,
            WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DataPathValue> dataPathList;

    private final String width;

    private PivotTableDataPathOption(BuilderImpl builder) {
        this.dataPathList = builder.dataPathList;
        this.width = builder.width;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataPathList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataPathList() {
        return dataPathList != null && !(dataPathList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data path values for the data path options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataPathList} method.
     * </p>
     * 
     * @return The list of data path values for the data path options.
     */
    public final List<DataPathValue> dataPathList() {
        return dataPathList;
    }

    /**
     * <p>
     * The width of the data path option.
     * </p>
     * 
     * @return The width of the data path option.
     */
    public final String width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataPathList() ? dataPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableDataPathOption)) {
            return false;
        }
        PivotTableDataPathOption other = (PivotTableDataPathOption) obj;
        return hasDataPathList() == other.hasDataPathList() && Objects.equals(dataPathList(), other.dataPathList())
                && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableDataPathOption").add("DataPathList", hasDataPathList() ? dataPathList() : null)
                .add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataPathList":
            return Optional.ofNullable(clazz.cast(dataPathList()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataPathList", DATA_PATH_LIST_FIELD);
        map.put("Width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableDataPathOption, T> g) {
        return obj -> g.apply((PivotTableDataPathOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableDataPathOption> {
        /**
         * <p>
         * The list of data path values for the data path options.
         * </p>
         * 
         * @param dataPathList
         *        The list of data path values for the data path options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPathList(Collection<DataPathValue> dataPathList);

        /**
         * <p>
         * The list of data path values for the data path options.
         * </p>
         * 
         * @param dataPathList
         *        The list of data path values for the data path options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPathList(DataPathValue... dataPathList);

        /**
         * <p>
         * The list of data path values for the data path options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DataPathValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder#build()} is called immediately
         * and its result is passed to {@link #dataPathList(List<DataPathValue>)}.
         * 
         * @param dataPathList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPathList(java.util.Collection<DataPathValue>)
         */
        Builder dataPathList(Consumer<DataPathValue.Builder>... dataPathList);

        /**
         * <p>
         * The width of the data path option.
         * </p>
         * 
         * @param width
         *        The width of the data path option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(String width);
    }

    static final class BuilderImpl implements Builder {
        private List<DataPathValue> dataPathList = DefaultSdkAutoConstructList.getInstance();

        private String width;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableDataPathOption model) {
            dataPathList(model.dataPathList);
            width(model.width);
        }

        public final List<DataPathValue.Builder> getDataPathList() {
            List<DataPathValue.Builder> result = DataPathValueListCopier.copyToBuilder(this.dataPathList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPathList(Collection<DataPathValue.BuilderImpl> dataPathList) {
            this.dataPathList = DataPathValueListCopier.copyFromBuilder(dataPathList);
        }

        @Override
        public final Builder dataPathList(Collection<DataPathValue> dataPathList) {
            this.dataPathList = DataPathValueListCopier.copy(dataPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathList(DataPathValue... dataPathList) {
            dataPathList(Arrays.asList(dataPathList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathList(Consumer<DataPathValue.Builder>... dataPathList) {
            dataPathList(Stream.of(dataPathList).map(c -> DataPathValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getWidth() {
            return width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        @Override
        public PivotTableDataPathOption build() {
            return new PivotTableDataPathOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
