/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a text box that is used to enter a single entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterTextFieldControl implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterTextFieldControl.Builder, ParameterTextFieldControl> {
    private static final SdkField<String> PARAMETER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterControlId").getter(getter(ParameterTextFieldControl::parameterControlId))
            .setter(setter(Builder::parameterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControlId").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ParameterTextFieldControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParameterName").getter(getter(ParameterTextFieldControl::sourceParameterName))
            .setter(setter(Builder::sourceParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameterName").build())
            .build();

    private static final SdkField<TextFieldControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<TextFieldControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(ParameterTextFieldControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(TextFieldControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_PARAMETER_NAME_FIELD, DISPLAY_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterControlId;

    private final String title;

    private final String sourceParameterName;

    private final TextFieldControlDisplayOptions displayOptions;

    private ParameterTextFieldControl(BuilderImpl builder) {
        this.parameterControlId = builder.parameterControlId;
        this.title = builder.title;
        this.sourceParameterName = builder.sourceParameterName;
        this.displayOptions = builder.displayOptions;
    }

    /**
     * <p>
     * The ID of the <code>ParameterTextFieldControl</code>.
     * </p>
     * 
     * @return The ID of the <code>ParameterTextFieldControl</code>.
     */
    public final String parameterControlId() {
        return parameterControlId;
    }

    /**
     * <p>
     * The title of the <code>ParameterTextFieldControl</code>.
     * </p>
     * 
     * @return The title of the <code>ParameterTextFieldControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source parameter name of the <code>ParameterTextFieldControl</code>.
     * </p>
     * 
     * @return The source parameter name of the <code>ParameterTextFieldControl</code>.
     */
    public final String sourceParameterName() {
        return sourceParameterName;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final TextFieldControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterTextFieldControl)) {
            return false;
        }
        ParameterTextFieldControl other = (ParameterTextFieldControl) obj;
        return Objects.equals(parameterControlId(), other.parameterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceParameterName(), other.sourceParameterName())
                && Objects.equals(displayOptions(), other.displayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterTextFieldControl").add("ParameterControlId", parameterControlId())
                .add("Title", title()).add("SourceParameterName", sourceParameterName()).add("DisplayOptions", displayOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterControlId":
            return Optional.ofNullable(clazz.cast(parameterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceParameterName":
            return Optional.ofNullable(clazz.cast(sourceParameterName()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterControlId", PARAMETER_CONTROL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("SourceParameterName", SOURCE_PARAMETER_NAME_FIELD);
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterTextFieldControl, T> g) {
        return obj -> g.apply((ParameterTextFieldControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterTextFieldControl> {
        /**
         * <p>
         * The ID of the <code>ParameterTextFieldControl</code>.
         * </p>
         * 
         * @param parameterControlId
         *        The ID of the <code>ParameterTextFieldControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControlId(String parameterControlId);

        /**
         * <p>
         * The title of the <code>ParameterTextFieldControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>ParameterTextFieldControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source parameter name of the <code>ParameterTextFieldControl</code>.
         * </p>
         * 
         * @param sourceParameterName
         *        The source parameter name of the <code>ParameterTextFieldControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameterName(String sourceParameterName);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(TextFieldControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextFieldControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link TextFieldControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextFieldControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(TextFieldControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link TextFieldControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(TextFieldControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<TextFieldControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(TextFieldControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterControlId;

        private String title;

        private String sourceParameterName;

        private TextFieldControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterTextFieldControl model) {
            parameterControlId(model.parameterControlId);
            title(model.title);
            sourceParameterName(model.sourceParameterName);
            displayOptions(model.displayOptions);
        }

        public final String getParameterControlId() {
            return parameterControlId;
        }

        public final void setParameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
        }

        @Override
        public final Builder parameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceParameterName() {
            return sourceParameterName;
        }

        public final void setSourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
        }

        @Override
        public final Builder sourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
            return this;
        }

        public final TextFieldControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(TextFieldControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(TextFieldControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        @Override
        public ParameterTextFieldControl build() {
            return new ParameterTextFieldControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
