/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>NumericEqualityFilter</code> filters values that are equal to the specified value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericEqualityFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericEqualityFilter.Builder, NumericEqualityFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(NumericEqualityFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(NumericEqualityFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(NumericEqualityFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectAllOptions").getter(getter(NumericEqualityFilter::selectAllOptionsAsString))
            .setter(setter(Builder::selectAllOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()).build();

    private static final SdkField<String> MATCH_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchOperator").getter(getter(NumericEqualityFilter::matchOperatorAsString))
            .setter(setter(Builder::matchOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOperator").build()).build();

    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<AggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(NumericEqualityFilter::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(AggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(NumericEqualityFilter::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOption").getter(getter(NumericEqualityFilter::nullOptionAsString))
            .setter(setter(Builder::nullOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()).build();

    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField
            .<DefaultFilterControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultFilterControlConfiguration")
            .getter(getter(NumericEqualityFilter::defaultFilterControlConfiguration))
            .setter(setter(Builder::defaultFilterControlConfiguration))
            .constructor(DefaultFilterControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            VALUE_FIELD, SELECT_ALL_OPTIONS_FIELD, MATCH_OPERATOR_FIELD, AGGREGATION_FUNCTION_FIELD, PARAMETER_NAME_FIELD,
            NULL_OPTION_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final Double value;

    private final String selectAllOptions;

    private final String matchOperator;

    private final AggregationFunction aggregationFunction;

    private final String parameterName;

    private final String nullOption;

    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private NumericEqualityFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.value = builder.value;
        this.selectAllOptions = builder.selectAllOptions;
        this.matchOperator = builder.matchOperator;
        this.aggregationFunction = builder.aggregationFunction;
        this.parameterName = builder.parameterName;
        this.nullOption = builder.nullOption;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The input value.
     * </p>
     * 
     * @return The input value.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link NumericFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see NumericFilterSelectAllOptions
     */
    public final NumericFilterSelectAllOptions selectAllOptions() {
        return NumericFilterSelectAllOptions.fromValue(selectAllOptions);
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link NumericFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see NumericFilterSelectAllOptions
     */
    public final String selectAllOptionsAsString() {
        return selectAllOptions;
    }

    /**
     * <p>
     * The match operator that is used to determine if a filter should be applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOperator}
     * will return {@link NumericEqualityMatchOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #matchOperatorAsString}.
     * </p>
     * 
     * @return The match operator that is used to determine if a filter should be applied.
     * @see NumericEqualityMatchOperator
     */
    public final NumericEqualityMatchOperator matchOperator() {
        return NumericEqualityMatchOperator.fromValue(matchOperator);
    }

    /**
     * <p>
     * The match operator that is used to determine if a filter should be applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOperator}
     * will return {@link NumericEqualityMatchOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #matchOperatorAsString}.
     * </p>
     * 
     * @return The match operator that is used to determine if a filter should be applied.
     * @see NumericEqualityMatchOperator
     */
    public final String matchOperatorAsString() {
        return matchOperator;
    }

    /**
     * <p>
     * The aggregation function of the filter.
     * </p>
     * 
     * @return The aggregation function of the filter.
     */
    public final AggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * 
     * @return The parameter whose value should be used for the filter value.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(nullOption);
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final String nullOptionAsString() {
        return nullOption;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @return The default configurations for the associated controls. This applies only for filters that are scoped to
     *         multiple sheets.
     */
    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return defaultFilterControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(matchOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultFilterControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericEqualityFilter)) {
            return false;
        }
        NumericEqualityFilter other = (NumericEqualityFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(value(), other.value())
                && Objects.equals(selectAllOptionsAsString(), other.selectAllOptionsAsString())
                && Objects.equals(matchOperatorAsString(), other.matchOperatorAsString())
                && Objects.equals(aggregationFunction(), other.aggregationFunction())
                && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(nullOptionAsString(), other.nullOptionAsString())
                && Objects.equals(defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericEqualityFilter").add("FilterId", filterId()).add("Column", column())
                .add("Value", value()).add("SelectAllOptions", selectAllOptionsAsString())
                .add("MatchOperator", matchOperatorAsString()).add("AggregationFunction", aggregationFunction())
                .add("ParameterName", parameterName()).add("NullOption", nullOptionAsString())
                .add("DefaultFilterControlConfiguration", defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "SelectAllOptions":
            return Optional.ofNullable(clazz.cast(selectAllOptionsAsString()));
        case "MatchOperator":
            return Optional.ofNullable(clazz.cast(matchOperatorAsString()));
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "NullOption":
            return Optional.ofNullable(clazz.cast(nullOptionAsString()));
        case "DefaultFilterControlConfiguration":
            return Optional.ofNullable(clazz.cast(defaultFilterControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterId", FILTER_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("SelectAllOptions", SELECT_ALL_OPTIONS_FIELD);
        map.put("MatchOperator", MATCH_OPERATOR_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("NullOption", NULL_OPTION_FIELD);
        map.put("DefaultFilterControlConfiguration", DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumericEqualityFilter, T> g) {
        return obj -> g.apply((NumericEqualityFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericEqualityFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The input value.
         * </p>
         * 
         * @param value
         *        The input value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see NumericFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericFilterSelectAllOptions
         */
        Builder selectAllOptions(String selectAllOptions);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see NumericFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericFilterSelectAllOptions
         */
        Builder selectAllOptions(NumericFilterSelectAllOptions selectAllOptions);

        /**
         * <p>
         * The match operator that is used to determine if a filter should be applied.
         * </p>
         * 
         * @param matchOperator
         *        The match operator that is used to determine if a filter should be applied.
         * @see NumericEqualityMatchOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericEqualityMatchOperator
         */
        Builder matchOperator(String matchOperator);

        /**
         * <p>
         * The match operator that is used to determine if a filter should be applied.
         * </p>
         * 
         * @param matchOperator
         *        The match operator that is used to determine if a filter should be applied.
         * @see NumericEqualityMatchOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericEqualityMatchOperator
         */
        Builder matchOperator(NumericEqualityMatchOperator matchOperator);

        /**
         * <p>
         * The aggregation function of the filter.
         * </p>
         * 
         * @param aggregationFunction
         *        The aggregation function of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(AggregationFunction aggregationFunction);

        /**
         * <p>
         * The aggregation function of the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationFunction.Builder} avoiding the
         * need to create one manually via {@link AggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregationFunction(AggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link AggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(AggregationFunction)
         */
        default Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(AggregationFunction.builder().applyMutation(aggregationFunction).build());
        }

        /**
         * <p>
         * The parameter whose value should be used for the filter value.
         * </p>
         * 
         * @param parameterName
         *        The parameter whose value should be used for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(String nullOption);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(FilterNullOption nullOption);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * 
         * @param defaultFilterControlConfiguration
         *        The default configurations for the associated controls. This applies only for filters that are scoped
         *        to multiple sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFilterControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultFilterControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)}.
         * 
         * @param defaultFilterControlConfiguration
         *        a consumer that will call methods on {@link DefaultFilterControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)
         */
        default Builder defaultFilterControlConfiguration(
                Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return defaultFilterControlConfiguration(DefaultFilterControlConfiguration.builder()
                    .applyMutation(defaultFilterControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private Double value;

        private String selectAllOptions;

        private String matchOperator;

        private AggregationFunction aggregationFunction;

        private String parameterName;

        private String nullOption;

        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericEqualityFilter model) {
            filterId(model.filterId);
            column(model.column);
            value(model.value);
            selectAllOptions(model.selectAllOptions);
            matchOperator(model.matchOperator);
            aggregationFunction(model.aggregationFunction);
            parameterName(model.parameterName);
            nullOption(model.nullOption);
            defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getSelectAllOptions() {
            return selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(NumericFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final String getMatchOperator() {
            return matchOperator;
        }

        public final void setMatchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
        }

        @Override
        public final Builder matchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        @Override
        public final Builder matchOperator(NumericEqualityMatchOperator matchOperator) {
            this.matchOperator(matchOperator == null ? null : matchOperator.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNullOption() {
            return nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(
                DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        @Override
        public NumericEqualityFilter build() {
            return new NumericEqualityFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
