/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The lookback window setup of an incremental refresh configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LookbackWindow implements SdkPojo, Serializable, ToCopyableBuilder<LookbackWindow.Builder, LookbackWindow> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(LookbackWindow::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Size")
            .getter(getter(LookbackWindow::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> SIZE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizeUnit").getter(getter(LookbackWindow::sizeUnitAsString)).setter(setter(Builder::sizeUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, SIZE_FIELD,
            SIZE_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final Long size;

    private final String sizeUnit;

    private LookbackWindow(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.size = builder.size;
        this.sizeUnit = builder.sizeUnit;
    }

    /**
     * <p>
     * The name of the lookback window column.
     * </p>
     * 
     * @return The name of the lookback window column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The lookback window column size.
     * </p>
     * 
     * @return The lookback window column size.
     */
    public final Long size() {
        return size;
    }

    /**
     * <p>
     * The size unit that is used for the lookback window column. Valid values for this structure are <code>HOUR</code>,
     * <code>DAY</code>, and <code>WEEK</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sizeUnit} will
     * return {@link LookbackWindowSizeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sizeUnitAsString}.
     * </p>
     * 
     * @return The size unit that is used for the lookback window column. Valid values for this structure are
     *         <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.
     * @see LookbackWindowSizeUnit
     */
    public final LookbackWindowSizeUnit sizeUnit() {
        return LookbackWindowSizeUnit.fromValue(sizeUnit);
    }

    /**
     * <p>
     * The size unit that is used for the lookback window column. Valid values for this structure are <code>HOUR</code>,
     * <code>DAY</code>, and <code>WEEK</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sizeUnit} will
     * return {@link LookbackWindowSizeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sizeUnitAsString}.
     * </p>
     * 
     * @return The size unit that is used for the lookback window column. Valid values for this structure are
     *         <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.
     * @see LookbackWindowSizeUnit
     */
    public final String sizeUnitAsString() {
        return sizeUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(sizeUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookbackWindow)) {
            return false;
        }
        LookbackWindow other = (LookbackWindow) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(size(), other.size())
                && Objects.equals(sizeUnitAsString(), other.sizeUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LookbackWindow").add("ColumnName", columnName()).add("Size", size())
                .add("SizeUnit", sizeUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "SizeUnit":
            return Optional.ofNullable(clazz.cast(sizeUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("SizeUnit", SIZE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LookbackWindow, T> g) {
        return obj -> g.apply((LookbackWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LookbackWindow> {
        /**
         * <p>
         * The name of the lookback window column.
         * </p>
         * 
         * @param columnName
         *        The name of the lookback window column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The lookback window column size.
         * </p>
         * 
         * @param size
         *        The lookback window column size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The size unit that is used for the lookback window column. Valid values for this structure are
         * <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.
         * </p>
         * 
         * @param sizeUnit
         *        The size unit that is used for the lookback window column. Valid values for this structure are
         *        <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.
         * @see LookbackWindowSizeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackWindowSizeUnit
         */
        Builder sizeUnit(String sizeUnit);

        /**
         * <p>
         * The size unit that is used for the lookback window column. Valid values for this structure are
         * <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.
         * </p>
         * 
         * @param sizeUnit
         *        The size unit that is used for the lookback window column. Valid values for this structure are
         *        <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.
         * @see LookbackWindowSizeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackWindowSizeUnit
         */
        Builder sizeUnit(LookbackWindowSizeUnit sizeUnit);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private Long size;

        private String sizeUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(LookbackWindow model) {
            columnName(model.columnName);
            size(model.size);
            sizeUnit(model.sizeUnit);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final String getSizeUnit() {
            return sizeUnit;
        }

        public final void setSizeUnit(String sizeUnit) {
            this.sizeUnit = sizeUnit;
        }

        @Override
        public final Builder sizeUnit(String sizeUnit) {
            this.sizeUnit = sizeUnit;
            return this;
        }

        @Override
        public final Builder sizeUnit(LookbackWindowSizeUnit sizeUnit) {
            this.sizeUnit(sizeUnit == null ? null : sizeUnit.toString());
            return this;
        }

        @Override
        public LookbackWindow build() {
            return new LookbackWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
