/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logo configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Logo implements SdkPojo, Serializable, ToCopyableBuilder<Logo.Builder, Logo> {
    private static final SdkField<String> ALT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AltText").getter(getter(Logo::altText)).setter(setter(Builder::altText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AltText").build()).build();

    private static final SdkField<LogoSet> LOGO_SET_FIELD = SdkField.<LogoSet> builder(MarshallingType.SDK_POJO)
            .memberName("LogoSet").getter(getter(Logo::logoSet)).setter(setter(Builder::logoSet)).constructor(LogoSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALT_TEXT_FIELD, LOGO_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String altText;

    private final LogoSet logoSet;

    private Logo(BuilderImpl builder) {
        this.altText = builder.altText;
        this.logoSet = builder.logoSet;
    }

    /**
     * <p>
     * The alt text for the logo.
     * </p>
     * 
     * @return The alt text for the logo.
     */
    public final String altText() {
        return altText;
    }

    /**
     * <p>
     * A set of configured logos.
     * </p>
     * 
     * @return A set of configured logos.
     */
    public final LogoSet logoSet() {
        return logoSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(altText());
        hashCode = 31 * hashCode + Objects.hashCode(logoSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logo)) {
            return false;
        }
        Logo other = (Logo) obj;
        return Objects.equals(altText(), other.altText()) && Objects.equals(logoSet(), other.logoSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Logo").add("AltText", altText()).add("LogoSet", logoSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AltText":
            return Optional.ofNullable(clazz.cast(altText()));
        case "LogoSet":
            return Optional.ofNullable(clazz.cast(logoSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AltText", ALT_TEXT_FIELD);
        map.put("LogoSet", LOGO_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Logo, T> g) {
        return obj -> g.apply((Logo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Logo> {
        /**
         * <p>
         * The alt text for the logo.
         * </p>
         * 
         * @param altText
         *        The alt text for the logo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder altText(String altText);

        /**
         * <p>
         * A set of configured logos.
         * </p>
         * 
         * @param logoSet
         *        A set of configured logos.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoSet(LogoSet logoSet);

        /**
         * <p>
         * A set of configured logos.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogoSet.Builder} avoiding the need to
         * create one manually via {@link LogoSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogoSet.Builder#build()} is called immediately and its result is
         * passed to {@link #logoSet(LogoSet)}.
         * 
         * @param logoSet
         *        a consumer that will call methods on {@link LogoSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logoSet(LogoSet)
         */
        default Builder logoSet(Consumer<LogoSet.Builder> logoSet) {
            return logoSet(LogoSet.builder().applyMutation(logoSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String altText;

        private LogoSet logoSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Logo model) {
            altText(model.altText);
            logoSet(model.logoSet);
        }

        public final String getAltText() {
            return altText;
        }

        public final void setAltText(String altText) {
            this.altText = altText;
        }

        @Override
        public final Builder altText(String altText) {
            this.altText = altText;
            return this;
        }

        public final LogoSet.Builder getLogoSet() {
            return logoSet != null ? logoSet.toBuilder() : null;
        }

        public final void setLogoSet(LogoSet.BuilderImpl logoSet) {
            this.logoSet = logoSet != null ? logoSet.build() : null;
        }

        @Override
        public final Builder logoSet(LogoSet logoSet) {
            this.logoSet = logoSet;
            return this;
        }

        @Override
        public Logo build() {
            return new Logo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
