/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIFieldWells implements SdkPojo, Serializable, ToCopyableBuilder<KPIFieldWells.Builder, KPIFieldWells> {
    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(KPIFieldWells::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> TARGET_VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("TargetValues")
            .getter(getter(KPIFieldWells::targetValues))
            .setter(setter(Builder::targetValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> TREND_GROUPS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("TrendGroups")
            .getter(getter(KPIFieldWells::trendGroups))
            .setter(setter(Builder::trendGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD,
            TARGET_VALUES_FIELD, TREND_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MeasureField> values;

    private final List<MeasureField> targetValues;

    private final List<DimensionField> trendGroups;

    private KPIFieldWells(BuilderImpl builder) {
        this.values = builder.values;
        this.targetValues = builder.targetValues;
        this.trendGroups = builder.trendGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value field wells of a KPI visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The value field wells of a KPI visual.
     */
    public final List<MeasureField> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetValues() {
        return targetValues != null && !(targetValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target value field wells of a KPI visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetValues} method.
     * </p>
     * 
     * @return The target value field wells of a KPI visual.
     */
    public final List<MeasureField> targetValues() {
        return targetValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrendGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrendGroups() {
        return trendGroups != null && !(trendGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The trend group field wells of a KPI visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrendGroups} method.
     * </p>
     * 
     * @return The trend group field wells of a KPI visual.
     */
    public final List<DimensionField> trendGroups() {
        return trendGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetValues() ? targetValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTrendGroups() ? trendGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIFieldWells)) {
            return false;
        }
        KPIFieldWells other = (KPIFieldWells) obj;
        return hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && hasTargetValues() == other.hasTargetValues() && Objects.equals(targetValues(), other.targetValues())
                && hasTrendGroups() == other.hasTrendGroups() && Objects.equals(trendGroups(), other.trendGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIFieldWells").add("Values", hasValues() ? values() : null)
                .add("TargetValues", hasTargetValues() ? targetValues() : null)
                .add("TrendGroups", hasTrendGroups() ? trendGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "TargetValues":
            return Optional.ofNullable(clazz.cast(targetValues()));
        case "TrendGroups":
            return Optional.ofNullable(clazz.cast(trendGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Values", VALUES_FIELD);
        map.put("TargetValues", TARGET_VALUES_FIELD);
        map.put("TrendGroups", TREND_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIFieldWells, T> g) {
        return obj -> g.apply((KPIFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIFieldWells> {
        /**
         * <p>
         * The value field wells of a KPI visual.
         * </p>
         * 
         * @param values
         *        The value field wells of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<MeasureField> values);

        /**
         * <p>
         * The value field wells of a KPI visual.
         * </p>
         * 
         * @param values
         *        The value field wells of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(MeasureField... values);

        /**
         * <p>
         * The value field wells of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<MeasureField>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<MeasureField>)
         */
        Builder values(Consumer<MeasureField.Builder>... values);

        /**
         * <p>
         * The target value field wells of a KPI visual.
         * </p>
         * 
         * @param targetValues
         *        The target value field wells of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValues(Collection<MeasureField> targetValues);

        /**
         * <p>
         * The target value field wells of a KPI visual.
         * </p>
         * 
         * @param targetValues
         *        The target value field wells of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValues(MeasureField... targetValues);

        /**
         * <p>
         * The target value field wells of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #targetValues(List<MeasureField>)}.
         * 
         * @param targetValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetValues(java.util.Collection<MeasureField>)
         */
        Builder targetValues(Consumer<MeasureField.Builder>... targetValues);

        /**
         * <p>
         * The trend group field wells of a KPI visual.
         * </p>
         * 
         * @param trendGroups
         *        The trend group field wells of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendGroups(Collection<DimensionField> trendGroups);

        /**
         * <p>
         * The trend group field wells of a KPI visual.
         * </p>
         * 
         * @param trendGroups
         *        The trend group field wells of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendGroups(DimensionField... trendGroups);

        /**
         * <p>
         * The trend group field wells of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #trendGroups(List<DimensionField>)}.
         * 
         * @param trendGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendGroups(java.util.Collection<DimensionField>)
         */
        Builder trendGroups(Consumer<DimensionField.Builder>... trendGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> targetValues = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> trendGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KPIFieldWells model) {
            values(model.values);
            targetValues(model.targetValues);
            trendGroups(model.trendGroups);
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = MeasureFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = MeasureFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder>... values) {
            values(Stream.of(values).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getTargetValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.targetValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetValues(Collection<MeasureField.BuilderImpl> targetValues) {
            this.targetValues = MeasureFieldListCopier.copyFromBuilder(targetValues);
        }

        @Override
        public final Builder targetValues(Collection<MeasureField> targetValues) {
            this.targetValues = MeasureFieldListCopier.copy(targetValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetValues(MeasureField... targetValues) {
            targetValues(Arrays.asList(targetValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetValues(Consumer<MeasureField.Builder>... targetValues) {
            targetValues(Stream.of(targetValues).map(c -> MeasureField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getTrendGroups() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.trendGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrendGroups(Collection<DimensionField.BuilderImpl> trendGroups) {
            this.trendGroups = DimensionFieldListCopier.copyFromBuilder(trendGroups);
        }

        @Override
        public final Builder trendGroups(Collection<DimensionField> trendGroups) {
            this.trendGroups = DimensionFieldListCopier.copy(trendGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendGroups(DimensionField... trendGroups) {
            trendGroups(Arrays.asList(trendGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendGroups(Consumer<DimensionField.Builder>... trendGroups) {
            trendGroups(Stream.of(trendGroups).map(c -> DimensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public KPIFieldWells build() {
            return new KPIFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
