/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The polygon symbol style for a polygon layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialPolygonSymbolStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialPolygonSymbolStyle.Builder, GeospatialPolygonSymbolStyle> {
    private static final SdkField<GeospatialColor> FILL_COLOR_FIELD = SdkField
            .<GeospatialColor> builder(MarshallingType.SDK_POJO).memberName("FillColor")
            .getter(getter(GeospatialPolygonSymbolStyle::fillColor)).setter(setter(Builder::fillColor))
            .constructor(GeospatialColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillColor").build()).build();

    private static final SdkField<GeospatialColor> STROKE_COLOR_FIELD = SdkField
            .<GeospatialColor> builder(MarshallingType.SDK_POJO).memberName("StrokeColor")
            .getter(getter(GeospatialPolygonSymbolStyle::strokeColor)).setter(setter(Builder::strokeColor))
            .constructor(GeospatialColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrokeColor").build()).build();

    private static final SdkField<GeospatialLineWidth> STROKE_WIDTH_FIELD = SdkField
            .<GeospatialLineWidth> builder(MarshallingType.SDK_POJO).memberName("StrokeWidth")
            .getter(getter(GeospatialPolygonSymbolStyle::strokeWidth)).setter(setter(Builder::strokeWidth))
            .constructor(GeospatialLineWidth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrokeWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILL_COLOR_FIELD,
            STROKE_COLOR_FIELD, STROKE_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialColor fillColor;

    private final GeospatialColor strokeColor;

    private final GeospatialLineWidth strokeWidth;

    private GeospatialPolygonSymbolStyle(BuilderImpl builder) {
        this.fillColor = builder.fillColor;
        this.strokeColor = builder.strokeColor;
        this.strokeWidth = builder.strokeWidth;
    }

    /**
     * <p>
     * The color and opacity values for the fill color.
     * </p>
     * 
     * @return The color and opacity values for the fill color.
     */
    public final GeospatialColor fillColor() {
        return fillColor;
    }

    /**
     * <p>
     * The color and opacity values for the stroke color.
     * </p>
     * 
     * @return The color and opacity values for the stroke color.
     */
    public final GeospatialColor strokeColor() {
        return strokeColor;
    }

    /**
     * <p>
     * The width of the border stroke.
     * </p>
     * 
     * @return The width of the border stroke.
     */
    public final GeospatialLineWidth strokeWidth() {
        return strokeWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fillColor());
        hashCode = 31 * hashCode + Objects.hashCode(strokeColor());
        hashCode = 31 * hashCode + Objects.hashCode(strokeWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialPolygonSymbolStyle)) {
            return false;
        }
        GeospatialPolygonSymbolStyle other = (GeospatialPolygonSymbolStyle) obj;
        return Objects.equals(fillColor(), other.fillColor()) && Objects.equals(strokeColor(), other.strokeColor())
                && Objects.equals(strokeWidth(), other.strokeWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialPolygonSymbolStyle").add("FillColor", fillColor()).add("StrokeColor", strokeColor())
                .add("StrokeWidth", strokeWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FillColor":
            return Optional.ofNullable(clazz.cast(fillColor()));
        case "StrokeColor":
            return Optional.ofNullable(clazz.cast(strokeColor()));
        case "StrokeWidth":
            return Optional.ofNullable(clazz.cast(strokeWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FillColor", FILL_COLOR_FIELD);
        map.put("StrokeColor", STROKE_COLOR_FIELD);
        map.put("StrokeWidth", STROKE_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialPolygonSymbolStyle, T> g) {
        return obj -> g.apply((GeospatialPolygonSymbolStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialPolygonSymbolStyle> {
        /**
         * <p>
         * The color and opacity values for the fill color.
         * </p>
         * 
         * @param fillColor
         *        The color and opacity values for the fill color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillColor(GeospatialColor fillColor);

        /**
         * <p>
         * The color and opacity values for the fill color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialColor.Builder} avoiding the
         * need to create one manually via {@link GeospatialColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialColor.Builder#build()} is called immediately and its
         * result is passed to {@link #fillColor(GeospatialColor)}.
         * 
         * @param fillColor
         *        a consumer that will call methods on {@link GeospatialColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fillColor(GeospatialColor)
         */
        default Builder fillColor(Consumer<GeospatialColor.Builder> fillColor) {
            return fillColor(GeospatialColor.builder().applyMutation(fillColor).build());
        }

        /**
         * <p>
         * The color and opacity values for the stroke color.
         * </p>
         * 
         * @param strokeColor
         *        The color and opacity values for the stroke color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strokeColor(GeospatialColor strokeColor);

        /**
         * <p>
         * The color and opacity values for the stroke color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialColor.Builder} avoiding the
         * need to create one manually via {@link GeospatialColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialColor.Builder#build()} is called immediately and its
         * result is passed to {@link #strokeColor(GeospatialColor)}.
         * 
         * @param strokeColor
         *        a consumer that will call methods on {@link GeospatialColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #strokeColor(GeospatialColor)
         */
        default Builder strokeColor(Consumer<GeospatialColor.Builder> strokeColor) {
            return strokeColor(GeospatialColor.builder().applyMutation(strokeColor).build());
        }

        /**
         * <p>
         * The width of the border stroke.
         * </p>
         * 
         * @param strokeWidth
         *        The width of the border stroke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strokeWidth(GeospatialLineWidth strokeWidth);

        /**
         * <p>
         * The width of the border stroke.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLineWidth.Builder} avoiding the
         * need to create one manually via {@link GeospatialLineWidth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLineWidth.Builder#build()} is called immediately and
         * its result is passed to {@link #strokeWidth(GeospatialLineWidth)}.
         * 
         * @param strokeWidth
         *        a consumer that will call methods on {@link GeospatialLineWidth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #strokeWidth(GeospatialLineWidth)
         */
        default Builder strokeWidth(Consumer<GeospatialLineWidth.Builder> strokeWidth) {
            return strokeWidth(GeospatialLineWidth.builder().applyMutation(strokeWidth).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialColor fillColor;

        private GeospatialColor strokeColor;

        private GeospatialLineWidth strokeWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialPolygonSymbolStyle model) {
            fillColor(model.fillColor);
            strokeColor(model.strokeColor);
            strokeWidth(model.strokeWidth);
        }

        public final GeospatialColor.Builder getFillColor() {
            return fillColor != null ? fillColor.toBuilder() : null;
        }

        public final void setFillColor(GeospatialColor.BuilderImpl fillColor) {
            this.fillColor = fillColor != null ? fillColor.build() : null;
        }

        @Override
        public final Builder fillColor(GeospatialColor fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public final GeospatialColor.Builder getStrokeColor() {
            return strokeColor != null ? strokeColor.toBuilder() : null;
        }

        public final void setStrokeColor(GeospatialColor.BuilderImpl strokeColor) {
            this.strokeColor = strokeColor != null ? strokeColor.build() : null;
        }

        @Override
        public final Builder strokeColor(GeospatialColor strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public final GeospatialLineWidth.Builder getStrokeWidth() {
            return strokeWidth != null ? strokeWidth.toBuilder() : null;
        }

        public final void setStrokeWidth(GeospatialLineWidth.BuilderImpl strokeWidth) {
            this.strokeWidth = strokeWidth != null ? strokeWidth.build() : null;
        }

        @Override
        public final Builder strokeWidth(GeospatialLineWidth strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        @Override
        public GeospatialPolygonSymbolStyle build() {
            return new GeospatialPolygonSymbolStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
