/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a default formatting definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultFormatting.Builder, DefaultFormatting> {
    private static final SdkField<String> DISPLAY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayFormat").getter(getter(DefaultFormatting::displayFormatAsString))
            .setter(setter(Builder::displayFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormat").build()).build();

    private static final SdkField<DisplayFormatOptions> DISPLAY_FORMAT_OPTIONS_FIELD = SdkField
            .<DisplayFormatOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayFormatOptions")
            .getter(getter(DefaultFormatting::displayFormatOptions)).setter(setter(Builder::displayFormatOptions))
            .constructor(DisplayFormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormatOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_FORMAT_FIELD,
            DISPLAY_FORMAT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayFormat;

    private final DisplayFormatOptions displayFormatOptions;

    private DefaultFormatting(BuilderImpl builder) {
        this.displayFormat = builder.displayFormat;
        this.displayFormatOptions = builder.displayFormatOptions;
    }

    /**
     * <p>
     * The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
     * <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayFormat}
     * will return {@link DisplayFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #displayFormatAsString}.
     * </p>
     * 
     * @return The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
     *         <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
     * @see DisplayFormat
     */
    public final DisplayFormat displayFormat() {
        return DisplayFormat.fromValue(displayFormat);
    }

    /**
     * <p>
     * The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
     * <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayFormat}
     * will return {@link DisplayFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #displayFormatAsString}.
     * </p>
     * 
     * @return The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
     *         <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
     * @see DisplayFormat
     */
    public final String displayFormatAsString() {
        return displayFormat;
    }

    /**
     * <p>
     * The additional options for display formatting.
     * </p>
     * 
     * @return The additional options for display formatting.
     */
    public final DisplayFormatOptions displayFormatOptions() {
        return displayFormatOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayFormatOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFormatting)) {
            return false;
        }
        DefaultFormatting other = (DefaultFormatting) obj;
        return Objects.equals(displayFormatAsString(), other.displayFormatAsString())
                && Objects.equals(displayFormatOptions(), other.displayFormatOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultFormatting").add("DisplayFormat", displayFormatAsString())
                .add("DisplayFormatOptions", displayFormatOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayFormat":
            return Optional.ofNullable(clazz.cast(displayFormatAsString()));
        case "DisplayFormatOptions":
            return Optional.ofNullable(clazz.cast(displayFormatOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisplayFormat", DISPLAY_FORMAT_FIELD);
        map.put("DisplayFormatOptions", DISPLAY_FORMAT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultFormatting, T> g) {
        return obj -> g.apply((DefaultFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultFormatting> {
        /**
         * <p>
         * The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
         * <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
         * </p>
         * 
         * @param displayFormat
         *        The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
         *        <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
         * @see DisplayFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayFormat
         */
        Builder displayFormat(String displayFormat);

        /**
         * <p>
         * The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
         * <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
         * </p>
         * 
         * @param displayFormat
         *        The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>,
         *        <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.
         * @see DisplayFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayFormat
         */
        Builder displayFormat(DisplayFormat displayFormat);

        /**
         * <p>
         * The additional options for display formatting.
         * </p>
         * 
         * @param displayFormatOptions
         *        The additional options for display formatting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions);

        /**
         * <p>
         * The additional options for display formatting.
         * </p>
         * This is a convenience method that creates an instance of the {@link DisplayFormatOptions.Builder} avoiding
         * the need to create one manually via {@link DisplayFormatOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisplayFormatOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #displayFormatOptions(DisplayFormatOptions)}.
         * 
         * @param displayFormatOptions
         *        a consumer that will call methods on {@link DisplayFormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayFormatOptions(DisplayFormatOptions)
         */
        default Builder displayFormatOptions(Consumer<DisplayFormatOptions.Builder> displayFormatOptions) {
            return displayFormatOptions(DisplayFormatOptions.builder().applyMutation(displayFormatOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String displayFormat;

        private DisplayFormatOptions displayFormatOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFormatting model) {
            displayFormat(model.displayFormat);
            displayFormatOptions(model.displayFormatOptions);
        }

        public final String getDisplayFormat() {
            return displayFormat;
        }

        public final void setDisplayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
        }

        @Override
        public final Builder displayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
            return this;
        }

        @Override
        public final Builder displayFormat(DisplayFormat displayFormat) {
            this.displayFormat(displayFormat == null ? null : displayFormat.toString());
            return this;
        }

        public final DisplayFormatOptions.Builder getDisplayFormatOptions() {
            return displayFormatOptions != null ? displayFormatOptions.toBuilder() : null;
        }

        public final void setDisplayFormatOptions(DisplayFormatOptions.BuilderImpl displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions != null ? displayFormatOptions.build() : null;
        }

        @Override
        public final Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions;
            return this;
        }

        @Override
        public DefaultFormatting build() {
            return new DefaultFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
